/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.particle;

import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.particle.StackQueue;
import de.pirckheimer_gymnasium.jbox2d.pooling.normal.MutableStack;

public class VoronoiDiagram {
    private final Generator[] generatorBuffer;
    private int generatorCount;
    private int countX;
    private int countY;
    private Generator[] diagram;
    private final Vec2 lower = new Vec2();
    private final Vec2 upper = new Vec2();
    private final MutableStack<VoronoiDiagramTask> taskPool = new MutableStack<VoronoiDiagramTask>(50){

        @Override
        protected VoronoiDiagramTask newInstance() {
            return new VoronoiDiagramTask();
        }

        protected VoronoiDiagramTask[] newArray(int size) {
            return new VoronoiDiagramTask[size];
        }
    };
    private final StackQueue<VoronoiDiagramTask> queue = new StackQueue();

    public VoronoiDiagram(int generatorCapacity) {
        this.generatorBuffer = new Generator[generatorCapacity];
        for (int i = 0; i < generatorCapacity; ++i) {
            this.generatorBuffer[i] = new Generator();
        }
        this.generatorCount = 0;
        this.countX = 0;
        this.countY = 0;
        this.diagram = null;
    }

    public void getNodes(VoronoiDiagramCallback callback) {
        for (int y = 0; y < this.countY - 1; ++y) {
            for (int x = 0; x < this.countX - 1; ++x) {
                int i = x + y * this.countX;
                Generator a = this.diagram[i];
                Generator b = this.diagram[i + 1];
                Generator c = this.diagram[i + this.countX];
                Generator d = this.diagram[i + 1 + this.countX];
                if (b == c) continue;
                if (a != b && a != c) {
                    callback.callback(a.tag, b.tag, c.tag);
                }
                if (d == b || d == c) continue;
                callback.callback(b.tag, d.tag, c.tag);
            }
        }
    }

    public void addGenerator(Vec2 center, int tag) {
        Generator g = this.generatorBuffer[this.generatorCount++];
        g.center.x = center.x;
        g.center.y = center.y;
        g.tag = tag;
    }

    public void generate(float radius) {
        int y;
        Generator g;
        int k;
        assert (this.diagram == null);
        float inverseRadius = 1.0f / radius;
        this.lower.x = Float.MAX_VALUE;
        this.lower.y = Float.MAX_VALUE;
        this.upper.x = -3.4028235E38f;
        this.upper.y = -3.4028235E38f;
        for (k = 0; k < this.generatorCount; ++k) {
            g = this.generatorBuffer[k];
            Vec2.minToOut(this.lower, g.center, this.lower);
            Vec2.maxToOut(this.upper, g.center, this.upper);
        }
        this.countX = 1 + (int)(inverseRadius * (this.upper.x - this.lower.x));
        this.countY = 1 + (int)(inverseRadius * (this.upper.y - this.lower.y));
        this.diagram = new Generator[this.countX * this.countY];
        this.queue.reset((VoronoiDiagramTask[])new VoronoiDiagramTask[4 * this.countX * this.countX]);
        for (k = 0; k < this.generatorCount; ++k) {
            g = this.generatorBuffer[k];
            g.center.x = inverseRadius * (g.center.x - this.lower.x);
            g.center.y = inverseRadius * (g.center.y - this.lower.y);
            int x = MathUtils.max(0, MathUtils.min((int)g.center.x, this.countX - 1));
            int y2 = MathUtils.max(0, MathUtils.min((int)g.center.y, this.countY - 1));
            this.queue.push(this.taskPool.pop().set(x, y2, x + y2 * this.countX, g));
        }
        while (!this.queue.empty()) {
            VoronoiDiagramTask front = this.queue.pop();
            int x = front.x;
            y = front.y;
            int i = front.i;
            Generator g2 = front.generator;
            if (this.diagram[i] == null) {
                this.diagram[i] = g2;
                if (x > 0) {
                    this.queue.push(this.taskPool.pop().set(x - 1, y, i - 1, g2));
                }
                if (y > 0) {
                    this.queue.push(this.taskPool.pop().set(x, y - 1, i - this.countX, g2));
                }
                if (x < this.countX - 1) {
                    this.queue.push(this.taskPool.pop().set(x + 1, y, i + 1, g2));
                }
                if (y < this.countY - 1) {
                    this.queue.push(this.taskPool.pop().set(x, y + 1, i + this.countX, g2));
                }
            }
            this.taskPool.push(front);
        }
        int maxIteration = this.countX + this.countY;
        for (int iteration = 0; iteration < maxIteration; ++iteration) {
            Generator b;
            Generator a;
            for (y = 0; y < this.countY; ++y) {
                for (int x = 0; x < this.countX - 1; ++x) {
                    int i = x + y * this.countX;
                    a = this.diagram[i];
                    b = this.diagram[i + 1];
                    if (a == b) continue;
                    this.queue.push(this.taskPool.pop().set(x, y, i, b));
                    this.queue.push(this.taskPool.pop().set(x + 1, y, i + 1, a));
                }
            }
            for (y = 0; y < this.countY - 1; ++y) {
                for (int x = 0; x < this.countX; ++x) {
                    int i = x + y * this.countX;
                    a = this.diagram[i];
                    b = this.diagram[i + this.countX];
                    if (a == b) continue;
                    this.queue.push(this.taskPool.pop().set(x, y, i, b));
                    this.queue.push(this.taskPool.pop().set(x, y + 1, i + this.countX, a));
                }
            }
            boolean updated = false;
            while (!this.queue.empty()) {
                float by;
                float bx;
                float b2;
                float ay;
                float ax;
                float a2;
                VoronoiDiagramTask front = this.queue.pop();
                int x = front.x;
                int y3 = front.y;
                int i = front.i;
                Generator a3 = this.diagram[i];
                Generator k2 = front.generator;
                if (a3 != k2 && (a2 = (ax = a3.center.x - (float)x) * ax + (ay = a3.center.y - (float)y3) * ay) > (b2 = (bx = k2.center.x - (float)x) * bx + (by = k2.center.y - (float)y3) * by)) {
                    this.diagram[i] = k2;
                    if (x > 0) {
                        this.queue.push(this.taskPool.pop().set(x - 1, y3, i - 1, k2));
                    }
                    if (y3 > 0) {
                        this.queue.push(this.taskPool.pop().set(x, y3 - 1, i - this.countX, k2));
                    }
                    if (x < this.countX - 1) {
                        this.queue.push(this.taskPool.pop().set(x + 1, y3, i + 1, k2));
                    }
                    if (y3 < this.countY - 1) {
                        this.queue.push(this.taskPool.pop().set(x, y3 + 1, i + this.countX, k2));
                    }
                    updated = true;
                }
                this.taskPool.push(front);
            }
            if (!updated) break;
        }
    }

    public static class Generator {
        final Vec2 center = new Vec2();
        int tag;
    }

    public static interface VoronoiDiagramCallback {
        public void callback(int var1, int var2, int var3);
    }

    public static class VoronoiDiagramTask {
        int x;
        int y;
        int i;
        Generator generator;

        public VoronoiDiagramTask() {
        }

        public VoronoiDiagramTask(int x, int y, int i, Generator g) {
            this.x = x;
            this.y = y;
            this.i = i;
            this.generator = g;
        }

        public VoronoiDiagramTask set(int x, int y, int i, Generator g) {
            this.x = x;
            this.y = y;
            this.i = i;
            this.generator = g;
            return this;
        }
    }
}

