/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.resources.SoundContainer;
import de.pirckheimer_gymnasium.engine_pi.sound.IntroTrack;
import de.pirckheimer_gymnasium.engine_pi.sound.LoopedTrack;
import de.pirckheimer_gymnasium.engine_pi.sound.MusicPlayback;
import de.pirckheimer_gymnasium.engine_pi.sound.Sound;
import de.pirckheimer_gymnasium.engine_pi.sound.SoundPlayback;
import de.pirckheimer_gymnasium.engine_pi.sound.Track;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.LineUnavailableException;

public final class Jukebox {
    public static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactory(){
        private int id = 0;

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Sound Playback Thread " + ++this.id);
        }
    });
    private static final Logger log = Logger.getLogger(Jukebox.class.getName());
    private static MusicPlayback music;
    private static final Collection<MusicPlayback> allMusic;
    private static final Collection<SoundPlayback> allSounds;
    private static SoundContainer soundsContainer;
    private static boolean RESTART_DEFAULT;
    private static boolean STOP_DEFAULT;

    public static MusicPlayback playMusic(Sound sound) {
        return Jukebox.playMusic(new LoopedTrack(sound), RESTART_DEFAULT, STOP_DEFAULT);
    }

    public static MusicPlayback playMusic(Sound sound, boolean restart, boolean stop) {
        return Jukebox.playMusic(new LoopedTrack(sound), null, restart, stop);
    }

    public static MusicPlayback playMusic(Track track) {
        return Jukebox.playMusic(track, null, RESTART_DEFAULT, STOP_DEFAULT);
    }

    public static MusicPlayback playMusic(String music) {
        return Jukebox.playMusic(Jukebox.getSound(music));
    }

    public static MusicPlayback playMusic(String music, boolean restart, boolean stop) {
        return Jukebox.playMusic(Jukebox.getSound(music), restart, stop);
    }

    public static MusicPlayback playMusic(Track track, boolean restart) {
        return Jukebox.playMusic(track, null, restart, STOP_DEFAULT);
    }

    public static MusicPlayback playMusic(Track track, boolean restart, boolean stop) {
        return Jukebox.playMusic(track, null, restart, stop);
    }

    public static synchronized MusicPlayback playMusic(Track track, Consumer<? super MusicPlayback> config, boolean restart, boolean stop) {
        if (!restart && music != null && music.isPlaying() && music.getTrack().equals(track)) {
            return music;
        }
        try {
            MusicPlayback playback = new MusicPlayback(track);
            if (config != null) {
                config.accept(playback);
            }
            if (stop) {
                Jukebox.stopMusic();
            }
            allMusic.add(playback);
            playback.start();
            music = playback;
            return playback;
        }
        catch (IllegalArgumentException | LineUnavailableException e) {
            Jukebox.resourceFailure(e);
            return null;
        }
    }

    public static MusicPlayback playIntroTrack(String intro, String loop) {
        return Jukebox.playMusic(new IntroTrack(Jukebox.getSound(intro), Jukebox.getSound(loop)));
    }

    public static synchronized MusicPlayback getMusic() {
        return music;
    }

    public static synchronized Collection<MusicPlayback> getAllMusic() {
        return Collections.unmodifiableCollection(allMusic);
    }

    public static synchronized void stopMusic() {
        for (MusicPlayback track : allMusic) {
            track.cancel();
        }
    }

    public static Sound getSound(String filePath) {
        return (Sound)soundsContainer.get(filePath);
    }

    public static SoundPlayback createSoundPlayback(Sound sound, boolean loop) {
        try {
            return new SoundPlayback(sound, loop);
        }
        catch (IllegalArgumentException | LineUnavailableException e) {
            Jukebox.resourceFailure(e);
            return null;
        }
    }

    public static SoundPlayback createSoundPlayback(String filePath, boolean loop) {
        return Jukebox.createSoundPlayback(Jukebox.getSound(filePath), loop);
    }

    public static void addSound(SoundPlayback playback) {
        allSounds.add(playback);
    }

    public static SoundPlayback playSound(Sound sound, boolean loop) {
        if (sound == null) {
            return null;
        }
        SoundPlayback playback = Jukebox.createSoundPlayback(sound, loop);
        if (playback == null) {
            return null;
        }
        playback.start();
        return playback;
    }

    public static SoundPlayback playSound(String filePath, boolean loop) {
        return Jukebox.playSound(Jukebox.getSound(filePath), loop);
    }

    public static SoundPlayback playSound(String filePath) {
        return Jukebox.playSound(filePath, false);
    }

    private static void resourceFailure(Throwable e) {
        log.log(Level.WARNING, "could not open a line", e);
    }

    static {
        allMusic = ConcurrentHashMap.newKeySet();
        allSounds = ConcurrentHashMap.newKeySet();
        soundsContainer = Resources.SOUNDS;
        RESTART_DEFAULT = false;
        STOP_DEFAULT = true;
    }
}

