/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import java.util.concurrent.ThreadLocalRandom;

@API
public final class Random {
    @Internal
    private Random() {
    }

    @API
    public static boolean toggle() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    @API
    public static int range(int upperLimit) {
        if (upperLimit < 0) {
            throw new IllegalArgumentException("Achtung! F\u00fcr eine Zufallszahl muss die definierte Obergrenze (die inklusiv in der Ergebnismenge ist) eine nichtnegative Zahl sein!");
        }
        return ThreadLocalRandom.current().nextInt(upperLimit + 1);
    }

    @API
    public static int range(int lowerLimit, int upperLimit) {
        if (lowerLimit == upperLimit) {
            return lowerLimit;
        }
        if (lowerLimit < upperLimit) {
            return lowerLimit + ThreadLocalRandom.current().nextInt(upperLimit - lowerLimit + 1);
        }
        return upperLimit + ThreadLocalRandom.current().nextInt(lowerLimit - upperLimit + 1);
    }

    @API
    public static double range() {
        return ThreadLocalRandom.current().nextDouble();
    }

    @API
    public static double range(double lowerLimit, double upperLimit) {
        if (lowerLimit == upperLimit) {
            return lowerLimit;
        }
        if (lowerLimit < upperLimit) {
            return lowerLimit + ThreadLocalRandom.current().nextDouble() * (upperLimit - lowerLimit);
        }
        return upperLimit + ThreadLocalRandom.current().nextDouble() * (lowerLimit - upperLimit);
    }
}

