/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.resources.ColorScheme;
import de.pirckheimer_gymnasium.engine_pi.resources.ColorSchemeSelection;
import de.pirckheimer_gymnasium.engine_pi.resources.Container;
import de.pirckheimer_gymnasium.engine_pi.resources.NamedColor;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ColorContainer
implements Container<Color> {
    private final Map<String, Color> resources = new LinkedHashMap<String, Color>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    private String normalizeName(String name) {
        return name.toLowerCase().replaceAll("\\s", "").replaceAll("-", "").replaceAll("_", "").replaceAll("\u00e4", "ae").replaceAll("\u00f6", "oe").replaceAll("\u00fc", "ue").replaceAll("\u00df", "ss");
    }

    @Override
    public Color add(String name, Color color) {
        this.resources.put(this.normalizeName(name), color);
        return color;
    }

    public Color add(String name, int r, int g, int b, int a) {
        return this.add(name, new Color(r, g, b, a));
    }

    public Color add(String name, int r, int g, int b, int a, String ... alias) {
        return this.add(name, new Color(r, g, b, a), alias);
    }

    public Color add(String name, int r, int g, int b) {
        return this.add(name, new Color(r, g, b));
    }

    public Color add(String name, int r, int g, int b, String ... alias) {
        return this.add(name, new Color(r, g, b), alias);
    }

    @Override
    public Color add(String name, String color) {
        return this.add(this.normalizeName(name), ColorUtil.decode(color));
    }

    public Color add(String name, Color color, String ... alias) {
        this.addAlias(name, alias);
        return this.add(name, color);
    }

    public Color add(String name, String color, String ... alias) {
        return this.add(this.normalizeName(name), ColorUtil.decode(color), alias);
    }

    public void addAlias(String name, String ... alias) {
        name = this.normalizeName(name);
        for (String a : alias) {
            this.aliases.put(this.normalizeName(a), name);
        }
    }

    public void addScheme(ColorScheme schema) {
        this.clear();
        this.add("yellow", schema.getYellow(), "Gelb", "Hellgelb");
        this.add("yellow orange", schema.getYellowOrange(), "orange yellow", "gold", "Gelb-Orange", "Orange-Gelb", "Golden", "Dunkelgelb");
        this.add("orange", schema.getOrange());
        this.add("red orange", schema.getRedOrange(), "orange red", "brick red", "brick", "Rot-Orange", "Orange-Rot", "Ziegelrot", "Hellrot");
        this.add("red", schema.getRed(), "Rot");
        this.add("red purple", schema.getRedPurple(), "purple red", "magenta", "pink", "Rot-Violett", "Violett-Rot", "Rosa");
        this.add("purple", schema.getPurple(), "Violet", "Violett", "Lila");
        this.add("blue purple", schema.getBluePurple(), "purple blue", "indigo", "Violett Blau", "Blau Violett");
        this.add("blue", schema.getBlue(), "Blau");
        this.add("blue green", schema.getBlueGreen(), "green blue", "cyan", "Blau-Gr\u00fcn", "Gr\u00fcn-Blau", "T\u00fcrkis");
        this.add("green", schema.getGreen(), "Gr\u00fcn");
        this.add("yellow green", schema.getYellowGreen(), "green yellow", "lime", "lime green", "Gelb-Gr\u00fcn", "Gr\u00fcn-Gelb", "Limetten Gr\u00fcn", "Limette", "Hellgr\u00fcn");
        this.add("brown", schema.getBrown(), "Braun");
        this.add("white", schema.getWhite(), "Wei\u00df");
        this.add("gray", schema.getGray(), "grey", "Grau");
        this.add("black", schema.getBlack(), "Schwarz");
    }

    public Color getSafe(String name) {
        try {
            return this.get(name);
        }
        catch (Exception exception) {
            ColorScheme scheme = ColorSchemeSelection.GNOME.getScheme();
            return switch (this.normalizeName(name)) {
                case "yellow", "gelb", "hellgelb" -> scheme.getYellow();
                case "yelloworange", "orangeyellow", "gold", "gelborange", "orangegelb", "golden", "dunkelgelb" -> scheme.getYellowOrange();
                case "orange" -> scheme.getOrange();
                case "redorange", "orangered", "brickred", "brick", "rotorange", "orangerot", "ziegelrot", "hellrot" -> scheme.getRedOrange();
                case "red", "rot" -> scheme.getRed();
                case "redpurple", "purplered", "magenta", "pink", "rotviolett", "violettrot", "rosa" -> scheme.getRedPurple();
                case "purple", "violet", "violett", "lila" -> scheme.getPurple();
                case "bluepurple", "purpleblue", "indigo", "violettblau", "blauviolett" -> scheme.getBluePurple();
                case "blue", "blau" -> scheme.getBlue();
                case "bluegreen", "greenblue", "cyan", "blaugruen", "gruenblau", "tuerkis" -> scheme.getBlueGreen();
                case "green", "gruen" -> scheme.getGreen();
                case "yellowgreen", "greenyellow", "lime", "limegreen", "gelbgruen", "gruengelb", "limettengruen", "limette", "hellgruen" -> scheme.getYellowGreen();
                case "brown", "braun" -> scheme.getBrown();
                case "white", "weiss" -> scheme.getWhite();
                case "gray", "grey", "grau" -> scheme.getGray();
                case "black", "schwarz" -> scheme.getBlack();
                default -> Color.BLACK;
            };
        }
    }

    public Color getSafe(String name, int alpha) {
        return ColorUtil.changeAlpha(this.getSafe(name), alpha);
    }

    public Map<String, Color> getAll() {
        return this.resources;
    }

    @Override
    public void clear() {
        this.resources.clear();
        this.aliases.clear();
    }

    @Override
    public Color get(String name) {
        String alias;
        Color color = this.resources.get(name = this.normalizeName(name));
        if (color == null && (alias = this.aliases.get(name)) != null) {
            return this.resources.get(alias);
        }
        if (color == null && ColorUtil.isHexColorString(name)) {
            return ColorUtil.decode(name);
        }
        if (color == null) {
            throw new RuntimeException("Unbekannte Farbe: " + name);
        }
        return color;
    }

    public NamedColor getNamedColor(String name) {
        String nameFromAlias;
        Color color = this.resources.get(name = this.normalizeName(name));
        if (color == null && (nameFromAlias = this.aliases.get(name)) != null) {
            name = nameFromAlias;
        }
        ArrayList<String> a = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.aliases.entrySet()) {
            if (!entry.getValue().equals(name)) continue;
            a.add(entry.getKey());
        }
        return new NamedColor(name, color, a);
    }

    public Color get(String name, int alpha) {
        return ColorUtil.changeAlpha(this.get(name), alpha);
    }

    @Override
    public int count() {
        return this.resources.size();
    }
}

