/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StreamUtilities {
    private static final Logger log = Logger.getLogger(StreamUtilities.class.getName());

    private StreamUtilities() {
        throw new UnsupportedOperationException();
    }

    public static void copy(File file, OutputStream out) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            StreamUtilities.copy((InputStream)in, out);
        }
    }

    public static void copy(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            StreamUtilities.copy(in, (OutputStream)out);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        if (in.markSupported()) {
            in.mark(Integer.MAX_VALUE);
        }
        while ((readCount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readCount);
        }
        if (in.markSupported()) {
            in.reset();
        }
    }

    public static byte[] getBytes(InputStream in) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            StreamUtilities.copy(in, (OutputStream)buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return new byte[0];
        }
    }
}

