/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Bounds;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Layer;
import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.BodyType;
import de.pirckheimer_gymnasium.engine_pi.actor.DistanceJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.PrismaticJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.RevoluteJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.RopeJoint;
import de.pirckheimer_gymnasium.engine_pi.actor.WeldJoint;
import de.pirckheimer_gymnasium.engine_pi.animation.ValueAnimator;
import de.pirckheimer_gymnasium.engine_pi.animation.interpolation.EaseInOutDouble;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.debug.DebugConfiguration;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionEvent;
import de.pirckheimer_gymnasium.engine_pi.event.CollisionListener;
import de.pirckheimer_gymnasium.engine_pi.event.EventListenerBundle;
import de.pirckheimer_gymnasium.engine_pi.event.EventListeners;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListener;
import de.pirckheimer_gymnasium.engine_pi.event.KeyStrokeListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseClickListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollListenerRegistration;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import de.pirckheimer_gymnasium.engine_pi.physics.NullHandler;
import de.pirckheimer_gymnasium.engine_pi.physics.PhysicsData;
import de.pirckheimer_gymnasium.engine_pi.physics.PhysicsHandler;
import de.pirckheimer_gymnasium.engine_pi.physics.WorldHandler;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import de.pirckheimer_gymnasium.engine_pi.util.Graphics2DUtil;
import de.pirckheimer_gymnasium.engine_pi.util.TextUtil;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.CircleShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.PolygonShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Fixture;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.DistanceJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PrismaticJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RopeJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.WeldJointDef;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Actor
implements KeyStrokeListenerRegistration,
MouseClickListenerRegistration,
MouseScrollListenerRegistration,
FrameUpdateListenerRegistration {
    private boolean visible = true;
    protected Color color;
    private int layerPosition = 1;
    private double opacity = 1.0;
    private PhysicsHandler physicsHandler;
    private final EventListenerBundle listeners = new EventListenerBundle();
    private final EventListeners<KeyStrokeListener> keyStrokeListeners = new EventListeners(this.createParentSupplier(Layer::getKeyStrokeListeners));
    private final EventListeners<MouseClickListener> mouseClickListeners = new EventListeners(this.createParentSupplier(Layer::getMouseClickListeners));
    private final EventListeners<MouseScrollListener> mouseScrollListeners = new EventListeners(this.createParentSupplier(Layer::getMouseScrollListeners));
    private final EventListeners<FrameUpdateListener> frameUpdateListeners = new EventListeners(this.createParentSupplier(Layer::getFrameUpdateListeners));

    private <T> Supplier<T> createParentSupplier(Function<Layer, T> supplier) {
        return () -> {
            Layer layer = this.getLayer();
            if (layer == null) {
                return null;
            }
            return supplier.apply(layer);
        };
    }

    public Actor(Supplier<FixtureData> defaultFixtureSupplier) {
        this.physicsHandler = new NullHandler(new PhysicsData(() -> Collections.singletonList((FixtureData)defaultFixtureSupplier.get())));
        EventListeners.registerListeners(this);
    }

    @API
    public final Actor addMountListener(Runnable listener) {
        this.listeners.mount.add(listener);
        if (this.isMounted()) {
            listener.run();
        }
        return this;
    }

    @API
    public final Actor removeMountListener(Runnable listener) {
        this.listeners.mount.remove(listener);
        return this;
    }

    @API
    public final Actor addUnmountListener(Runnable listener) {
        this.listeners.unmount.add(listener);
        return this;
    }

    @API
    public final Actor removeUnmountListener(Runnable listener) {
        this.listeners.unmount.remove(listener);
        return this;
    }

    @API
    public final Actor setLayerPosition(int position) {
        this.layerPosition = position;
        return this;
    }

    @API
    public final int getLayerPosition() {
        return this.layerPosition;
    }

    @API
    public final Actor setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @API
    public final Actor toggleVisible() {
        this.visible = !this.visible;
        return this;
    }

    @API
    public final boolean isVisible() {
        return this.visible;
    }

    @API
    public final double getOpacity() {
        return this.opacity;
    }

    @API
    public final Actor setOpacity(double opacity) {
        this.opacity = opacity;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getComplementaryColor() {
        return ColorUtil.getComplementary(this.color);
    }

    @API
    public Actor setColor(Color color) {
        this.color = color;
        return this;
    }

    @API
    public Actor setColor(String color) {
        this.color = Resources.COLORS.getSafe(color);
        return this;
    }

    @API
    public final boolean contains(Vector point) {
        return this.physicsHandler.contains(point);
    }

    @API
    public final boolean overlaps(Actor other) {
        Body a = this.physicsHandler.getBody();
        Body b = other.getPhysicsHandler().getBody();
        return WorldHandler.isBodyCollision(a, b);
    }

    public final List<CollisionEvent<Actor>> getCollisions() {
        return this.physicsHandler.getCollisions();
    }

    @API
    public final Actor setBodyType(BodyType type) {
        Objects.requireNonNull(type, "Typ darf nicht null sein");
        this.physicsHandler.setType(type);
        return this;
    }

    @API
    public final Actor makeStatic() {
        this.setBodyType(BodyType.STATIC);
        return this;
    }

    @API
    public final Actor makeDynamic() {
        this.setBodyType(BodyType.DYNAMIC);
        return this;
    }

    @API
    public final Actor makeKinematic() {
        this.setBodyType(BodyType.KINEMATIC);
        return this;
    }

    @API
    public final Actor makeSensor() {
        this.setBodyType(BodyType.SENSOR);
        return this;
    }

    @API
    public final Actor makeParticle() {
        this.setBodyType(BodyType.PARTICLE);
        return this;
    }

    @API
    public final BodyType getBodyType() {
        return this.physicsHandler.getType();
    }

    @API
    public final Actor setFixtures(String code) {
        this.setFixtures(FixtureBuilder.fromString(code));
        return this;
    }

    @API
    public final Actor setFixture(Supplier<FixtureData> fixtureSupplier) {
        this.setFixtures(() -> Collections.singletonList((FixtureData)fixtureSupplier.get()));
        return this;
    }

    @API
    public final Actor setFixtures(Supplier<List<FixtureData>> fixturesSupplier) {
        this.physicsHandler.setFixtures(fixturesSupplier);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public final void renderBasic(Graphics2D g, Bounds r, double pixelPerMeter) {
        if (this.visible && this.isWithinBounds(r)) {
            Composite composite;
            double rotation = this.physicsHandler.getRotation();
            Vector position = this.physicsHandler.getPosition();
            AffineTransform transform = g.getTransform();
            g.rotate(-Math.toRadians(rotation), position.getX() * pixelPerMeter, -position.getY() * pixelPerMeter);
            g.translate(position.getX() * pixelPerMeter, -position.getY() * pixelPerMeter);
            if (this.opacity != 1.0) {
                composite = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, (float)this.opacity));
            } else {
                composite = null;
            }
            if (Game.getRenderActors()) {
                this.render(g, pixelPerMeter);
            }
            if (Game.isDebug()) {
                Actor actor = this;
                synchronized (actor) {
                    Body body = this.physicsHandler.getBody();
                    if (body != null) {
                        Fixture fixture = body.fixtureList;
                        while (fixture != null && fixture.shape != null) {
                            Actor.renderShape(fixture.shape, g, pixelPerMeter, this);
                            fixture = fixture.next;
                        }
                    }
                }
            }
            if (composite != null) {
                g.setComposite(composite);
            }
            g.setTransform(transform);
        }
    }

    @Internal
    private static void renderShape(Shape shape, Graphics2D g, double pixelPerMeter, Actor actor) {
        if (shape == null) {
            return;
        }
        AffineTransform pre = g.getTransform();
        Graphics2DUtil.setAntiAliasing(g, false);
        g.setColor(Resources.COLORS.getSafe("yellow"));
        g.drawOval(-1, -1, 2, 2);
        if (DebugConfiguration.showPositions) {
            Graphics2DUtil.drawText(g, actor.getPositionformatted(), 8, 5, 5);
        }
        g.setColor(actor.color != null ? actor.getComplementaryColor() : Resources.COLORS.getSafe("red"));
        if (shape instanceof PolygonShape) {
            PolygonShape polygonShape = (PolygonShape)shape;
            Vec2[] vec2s = polygonShape.getVertices();
            int[] xs = new int[polygonShape.getVertexCount()];
            int[] ys = new int[polygonShape.getVertexCount()];
            for (int i = 0; i < xs.length; ++i) {
                xs[i] = (int)((double)vec2s[i].x * pixelPerMeter);
                ys[i] = -1 * (int)((double)vec2s[i].y * pixelPerMeter);
            }
            g.drawPolygon(xs, ys, xs.length);
        } else if (shape instanceof CircleShape) {
            CircleShape circleShape = (CircleShape)shape;
            double diameter = circleShape.radius * 2.0f;
            g.drawOval((int)((double)(circleShape.p.x - circleShape.radius) * pixelPerMeter), (int)((double)(-circleShape.p.y - circleShape.radius) * pixelPerMeter), (int)(diameter * pixelPerMeter), (int)(diameter * pixelPerMeter));
        } else {
            throw new RuntimeException("Konnte die Shape (" + String.valueOf(shape) + ") nicht rendern, unerwartete Shape");
        }
        Graphics2DUtil.setAntiAliasing(g, true);
        g.setTransform(pre);
    }

    @Internal
    private boolean isWithinBounds(Bounds bounds) {
        return true;
    }

    @Internal
    public final PhysicsHandler getPhysicsHandler() {
        return this.physicsHandler;
    }

    @API
    public final <E extends Actor> Actor addCollisionListener(E collider, CollisionListener<E> listener) {
        WorldHandler.addSpecificCollisionListener(this, collider, listener);
        return this;
    }

    @API
    public final <E extends Actor> Actor addCollisionListener(final Class<E> clazz, final CollisionListener<E> listener) {
        WorldHandler.addGenericCollisionListener(new CollisionListener<Actor>(){

            @Override
            public void onCollision(CollisionEvent<Actor> collisionEvent) {
                if (clazz.isInstance(collisionEvent.getColliding())) {
                    listener.onCollision(collisionEvent);
                }
            }

            @Override
            public void onCollisionEnd(CollisionEvent<Actor> collisionEvent) {
                if (clazz.isInstance(collisionEvent.getColliding())) {
                    listener.onCollisionEnd(collisionEvent);
                }
            }
        }, this);
        return this;
    }

    @API
    public final Actor addCollisionListener(CollisionListener<Actor> listener) {
        WorldHandler.addGenericCollisionListener(listener, this);
        return this;
    }

    @Internal
    public abstract void render(Graphics2D var1, double var2);

    @Internal
    public final Actor setPhysicsHandler(PhysicsHandler handler) {
        WorldHandler worldHandler = handler.getWorldHandler();
        WorldHandler previousWorldHandler = this.physicsHandler.getWorldHandler();
        if (worldHandler == null) {
            if (previousWorldHandler == null) {
                return this;
            }
            Layer layer = previousWorldHandler.getLayer();
            this.keyStrokeListeners.invoke(layer::removeKeyStrokeListener);
            this.mouseClickListeners.invoke(layer::removeMouseClickListener);
            this.mouseScrollListeners.invoke(layer::removeMouseScrollListener);
            this.frameUpdateListeners.invoke(layer::removeFrameUpdateListener);
            this.listeners.unmount.invoke(Runnable::run);
            this.physicsHandler = handler;
        } else {
            if (previousWorldHandler != null) {
                return this;
            }
            this.physicsHandler = handler;
            Layer layer = worldHandler.getLayer();
            this.listeners.mount.invoke(Runnable::run);
            this.keyStrokeListeners.invoke(layer::addKeyStrokeListener);
            this.mouseClickListeners.invoke(layer::addMouseClickListener);
            this.mouseScrollListeners.invoke(layer::addMouseScrollListener);
            this.frameUpdateListeners.invoke(layer::addFrameUpdateListener);
        }
        return this;
    }

    public final Layer getLayer() {
        WorldHandler worldHandler = this.physicsHandler.getWorldHandler();
        if (worldHandler == null) {
            return null;
        }
        return worldHandler.getLayer();
    }

    public final Actor remove() {
        Layer layer = this.getLayer();
        if (layer != null) {
            layer.remove(this);
        }
        return this;
    }

    @API
    public final EventListenerBundle getListenerBundle() {
        return this.listeners;
    }

    @Override
    @API
    public final EventListeners<KeyStrokeListener> getKeyStrokeListeners() {
        return this.keyStrokeListeners;
    }

    @Override
    @API
    public final EventListeners<MouseClickListener> getMouseClickListeners() {
        return this.mouseClickListeners;
    }

    @Override
    @API
    public final EventListeners<MouseScrollListener> getMouseScrollListeners() {
        return this.mouseScrollListeners;
    }

    @Override
    @API
    public final EventListeners<FrameUpdateListener> getFrameUpdateListeners() {
        return this.frameUpdateListeners;
    }

    @API
    public final Actor setRotationLocked(boolean rotationLocked) {
        this.physicsHandler.setRotationLocked(rotationLocked);
        return this;
    }

    @API
    public final Actor lockRotation() {
        this.physicsHandler.setRotationLocked(true);
        return this;
    }

    @API
    public final boolean isRotationLocked() {
        return this.physicsHandler.isRotationLocked();
    }

    @API
    public final double getMass() {
        return this.physicsHandler.getMass();
    }

    @API
    public final Actor setDensity(double density) {
        this.physicsHandler.setDensity(density);
        return this;
    }

    @API
    public final double getDensity() {
        return this.physicsHandler.getDensity();
    }

    @API
    public final Actor setGravityScale(double factor) {
        this.physicsHandler.setGravityScale(factor);
        return this;
    }

    @API
    public final double getGravityScale() {
        return this.physicsHandler.getGravityScale();
    }

    @API
    public final Actor setFriction(double friction) {
        this.physicsHandler.setFriction(friction);
        return this;
    }

    @API
    public final double getFriction() {
        return this.physicsHandler.getFriction();
    }

    @API
    public final Actor setAngularDamping(double damping) {
        this.physicsHandler.setAngularDamping(damping);
        return this;
    }

    @API
    public final double getAngularDamping() {
        return this.physicsHandler.getAngularDamping();
    }

    @API
    public final Actor setLinearDamping(double damping) {
        this.physicsHandler.setLinearDamping(damping);
        return this;
    }

    @API
    public final double getLinearDamping() {
        return this.physicsHandler.getLinearDamping();
    }

    @API
    public final Actor setVelocity(Vector velocity) {
        if (velocity.isNaN()) {
            return this;
        }
        this.physicsHandler.setVelocity(velocity);
        return this;
    }

    @API
    public final Vector getVelocity() {
        return this.physicsHandler.getVelocity();
    }

    @API
    public final double getAngularVelocity() {
        return this.physicsHandler.getAngularVelocity();
    }

    @API
    public final Actor setAngularVelocity(double rotationsPerSecond) {
        if (Double.isNaN(rotationsPerSecond)) {
            return this;
        }
        this.physicsHandler.setAngularVelocity(rotationsPerSecond);
        return this;
    }

    @API
    public final Actor setElasticity(double elasticity) {
        if (Double.isNaN(elasticity)) {
            throw new RuntimeException("Ung\u00fcltige Sto\u00dfzahl: " + elasticity);
        }
        this.physicsHandler.setRestitution(elasticity);
        return this;
    }

    @API
    public final double getElasticity() {
        return this.physicsHandler.getRestitution();
    }

    @API
    public final Actor applyTorque(double torque) {
        if (Double.isNaN(torque)) {
            return this;
        }
        this.physicsHandler.applyTorque(torque);
        return this;
    }

    public final Actor applyRotationImpulse(double impulse) {
        if (Double.isNaN(impulse)) {
            return this;
        }
        this.physicsHandler.applyRotationImpulse(impulse);
        return this;
    }

    @API
    public final Actor applyForce(Vector force) {
        if (force.isNaN()) {
            return this;
        }
        this.physicsHandler.applyForce(force);
        return this;
    }

    public final Actor applyForce(double forceX, double forceY) {
        this.applyForce(new Vector(forceX, forceY));
        return this;
    }

    @API
    public final Actor applyForce(Vector force, Vector globalPoint) {
        if (force.isNaN() || globalPoint.isNaN()) {
            return this;
        }
        this.physicsHandler.applyForce(force, globalPoint);
        return this;
    }

    @API
    public final Actor applyImpulse(Vector impulse) {
        if (impulse.isNaN()) {
            return this;
        }
        this.physicsHandler.applyImpulse(impulse, this.physicsHandler.getCenter());
        return this;
    }

    public final Actor applyImpulse(double impulseX, double impulseY) {
        this.applyImpulse(new Vector(impulseX, impulseY));
        return this;
    }

    @API
    public final Actor applyImpulse(Vector impulse, Vector globalPoint) {
        this.physicsHandler.applyImpulse(impulse, globalPoint);
        return this;
    }

    @API
    public final Actor resetMovement() {
        this.physicsHandler.resetMovement();
        return this;
    }

    @API
    public final boolean isGrounded() {
        return this.physicsHandler.isGrounded();
    }

    @API
    public final RevoluteJoint createRevoluteJoint(Actor other, Vector anchor) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            RevoluteJointDef def = new RevoluteJointDef();
            def.initialize(a, b, this.getPosition().add(anchor).toVec2());
            def.collideConnected = false;
            return (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint)world.createJoint(def);
        }, new RevoluteJoint());
    }

    @API
    public final RopeJoint createRopeJoint(Actor other, Vector anchorThis, Vector anchorOther, double ropeLength) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            RopeJointDef def = new RopeJointDef();
            def.bodyA = a;
            def.bodyB = b;
            def.localAnchorA.set(anchorThis.toVec2());
            def.localAnchorB.set(anchorOther.toVec2());
            def.collideConnected = true;
            def.maxLength = (float)ropeLength;
            return (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RopeJoint)world.createJoint(def);
        }, new RopeJoint());
    }

    @API
    public final PrismaticJoint createPrismaticJoint(Actor other, Vector anchor, double axisAngle) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            double angleInRadians = Math.toRadians(axisAngle);
            PrismaticJointDef def = new PrismaticJointDef();
            def.initialize(a, b, this.getPosition().add(anchor).toVec2(), new Vec2((float)Math.cos(angleInRadians), (float)Math.sin(angleInRadians)));
            def.collideConnected = false;
            return (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PrismaticJoint)world.createJoint(def);
        }, new PrismaticJoint());
    }

    @API
    public final DistanceJoint createDistanceJoint(Actor other, Vector anchorThis, Vector anchorOther) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            DistanceJointDef def = new DistanceJointDef();
            def.bodyA = a;
            def.bodyB = b;
            def.localAnchorA.set(anchorThis.toVec2());
            def.localAnchorB.set(anchorOther.toVec2());
            Vector distanceBetweenBothActors = this.getPosition().add(anchorThis).getDistance(other.getPosition().add(anchorOther));
            def.length = (float)distanceBetweenBothActors.getLength();
            return (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.DistanceJoint)world.createJoint(def);
        }, new DistanceJoint());
    }

    @API
    public final WeldJoint createWeldJoint(Actor other, Vector anchorThis, Vector anchorOther) {
        return WorldHandler.createJoint(this, other, (world, a, b) -> {
            WeldJointDef def = new WeldJointDef();
            def.bodyA = a;
            def.bodyB = b;
            def.localAnchorA.set(anchorThis.toVec2());
            def.localAnchorB.set(anchorOther.toVec2());
            return (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.WeldJoint)world.createJoint(def);
        }, new WeldJoint());
    }

    @API
    public final Actor setPosition(double x, double y) {
        this.setPosition(new Vector(x, y));
        return this;
    }

    @API
    public final Actor setPosition(Vector position) {
        this.moveBy(position.subtract(this.getPosition()));
        return this;
    }

    @API
    public final Actor moveBy(Vector vector) {
        this.physicsHandler.moveBy(vector);
        return this;
    }

    @API
    public final Actor moveBy(double dX, double dY) {
        this.moveBy(new Vector(dX, dY));
        return this;
    }

    @API
    public final Actor setCenter(double x, double y) {
        this.setCenter(new Vector(x, y));
        return this;
    }

    @API
    public final Actor setCenter(Vector center) {
        this.moveBy(this.getCenter().negate().add(center));
        return this;
    }

    @API
    public final double getX() {
        return this.getPosition().getX();
    }

    @API
    public final Actor setX(double x) {
        this.moveBy(x - this.getX(), 0.0);
        return this;
    }

    @API
    public final double getY() {
        return this.getPosition().getY();
    }

    @API
    public final Actor setY(double y) {
        this.moveBy(0.0, y - this.getY());
        return this;
    }

    @API
    public final Vector getCenter() {
        return this.physicsHandler.getCenter();
    }

    @API
    public final Vector getCenterRelative() {
        return this.getCenter().subtract(this.getPosition());
    }

    @API
    public final Vector getPosition() {
        return this.physicsHandler.getPosition();
    }

    public final String getPositionformatted() {
        Vector pos = this.getPosition();
        return TextUtil.roundNumber(pos.getX()) + "|" + TextUtil.roundNumber(pos.getY());
    }

    @API
    public final Actor rotateBy(double angle) {
        this.physicsHandler.rotateBy(angle);
        return this;
    }

    @API
    public final double getRotation() {
        return this.physicsHandler.getRotation();
    }

    @API
    public final Actor setRotation(double winkel) {
        this.physicsHandler.setRotation(winkel);
        return this;
    }

    @API
    public final boolean isMounted() {
        return this.getLayer() != null;
    }

    @API
    public final ValueAnimator<Double> animateParticle(double lifetime) {
        this.setBodyType(BodyType.PARTICLE);
        this.setOpacity(1.0);
        ValueAnimator<Double> animator = this.animateOpacity(lifetime, 0.0);
        animator.addCompletionListener(value -> this.remove());
        return animator;
    }

    @API
    public final ValueAnimator<Double> animateOpacity(double time, double toOpacityValue) {
        ValueAnimator<Double> animator = new ValueAnimator<Double>(time, this::setOpacity, new EaseInOutDouble(this.getOpacity(), toOpacityValue), this);
        this.addFrameUpdateListener(animator);
        return animator;
    }

    @Internal
    static void assertPositiveWidthAndHeight(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException("Breite und H\u00f6he m\u00fcssen gr\u00f6\u00dfer 0 sein! " + width + " / " + height);
        }
    }

    public Actor awake() {
        this.physicsHandler.setAwake(true);
        return this;
    }

    public Actor sleep() {
        this.physicsHandler.setAwake(false);
        return this;
    }

    @Internal
    public Actor getActor() {
        return this;
    }
}

