/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Geometry;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

@API
public class Polygon
extends Geometry {
    private double[] px;
    private double[] py;
    private int[] scaledPx;
    private int[] scaledPy;

    @API
    public Polygon(Vector ... points) {
        super(() -> FixtureBuilder.polygon(points));
        this.resetPoints(points);
    }

    @API
    public void resetPoints(Vector ... points) {
        if (points.length < 3) {
            throw new RuntimeException("Der Streckenzug muss mindestens aus 3 Punkten bestehen, um ein g\u00fcltiges Polygon zu beschreiben.");
        }
        this.px = new double[points.length];
        this.py = new double[points.length];
        this.scaledPx = new int[points.length];
        this.scaledPy = new int[points.length];
        for (int i = 0; i < points.length; ++i) {
            this.px[i] = points[i].getX();
            this.py[i] = points[i].getY();
        }
        this.setFixture(() -> FixtureBuilder.polygon(points));
    }

    @Override
    @Internal
    public void render(Graphics2D g, double pixelPerMeter) {
        for (int i = 0; i < this.scaledPx.length; ++i) {
            this.scaledPx[i] = (int)(this.px[i] * pixelPerMeter);
            this.scaledPy[i] = (int)(this.py[i] * pixelPerMeter);
        }
        AffineTransform at = g.getTransform();
        g.scale(1.0, -1.0);
        g.setColor(this.getColor());
        g.fillPolygon(this.scaledPx, this.scaledPy, this.scaledPx.length);
        g.setTransform(at);
    }
}

