/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.debug;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Random;
import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.actor.Circle;
import de.pirckheimer_gymnasium.engine_pi.actor.Logo;
import de.pirckheimer_gymnasium.engine_pi.actor.Polygon;
import de.pirckheimer_gymnasium.engine_pi.actor.Rectangle;
import de.pirckheimer_gymnasium.engine_pi.actor.Text;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.debug.Version;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Color;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

@Internal
public final class MainAnimation
extends Scene
implements FrameUpdateListener {
    private final Color rectangleItemColor = this.darkenColor("red");
    private final Color circleItemColor = this.darkenColor("blue");
    private final Color triangleItemColor = this.darkenColor("yellow");
    private final List<Actor> items = new ArrayList<Actor>();
    private final Logo logo = new Logo(this, new Vector(-4.0, -5.0), 2.3);
    private double yMovementCircleI = 0.01;

    public MainAnimation() {
        Text enginePiText = new Text("E   n   g   i   n   e         P   i", 2.0, "fonts/Cantarell-Bold.ttf", 0);
        enginePiText.makeStatic();
        enginePiText.setColor("white");
        enginePiText.setCenter(0.0, -7.0);
        this.add(enginePiText);
        this.setGravityOfEarth();
        this.createGround();
        for (int i = 0; i < 3; ++i) {
            this.createRectangleItem();
            this.createCircleItem();
            this.createTriangleItem();
        }
        Text text = new Text("Build #" + Version.getGitCommitIdAbbrev() + "   " + this.formatBuildTime(), 0.5, "fonts/Cantarell-Regular.ttf");
        text.setPosition(-10.0, 9.0);
        text.setColor(Color.WHITE);
        text.makeStatic();
        this.add(text);
    }

    private Color darkenColor(String color) {
        return ColorUtil.interpolate(Resources.COLORS.get(color), Resources.COLORS.get("black"), 0.5);
    }

    private void createGround() {
        Rectangle ground = new Rectangle(20.0, 0.2);
        ground.setColor("white");
        ground.setCenter(0.0, -6.0);
        ground.setElasticity(0.95);
        ground.setFriction(0.2);
        ground.makeStatic();
        this.add(ground);
    }

    private void createRectangleItem() {
        Rectangle rectangle = new Rectangle(1.0, 2.0);
        rectangle.setColor(this.rectangleItemColor);
        rectangle.setPosition(-5.0, 10.0);
        this.makeItemDynamic(rectangle);
        rectangle.setRotation(30.0);
        this.dropDownItem(rectangle);
    }

    private void createCircleItem() {
        Circle circle = new Circle();
        circle.setColor(this.circleItemColor);
        circle.setPosition(5.0, 10.0);
        this.makeItemDynamic(circle);
        circle.applyImpulse(new Vector(Random.range(-100, 100), 0.0));
        this.dropDownItem(circle);
    }

    private void createTriangleItem() {
        Polygon triangle = new Polygon(new Vector(0.0, 0.0), new Vector(1.0, 0.0), new Vector(0.5, -1.0));
        triangle.setColor(this.triangleItemColor);
        this.makeItemDynamic(triangle);
        triangle.setRotation(-20.0);
        this.dropDownItem(triangle);
    }

    private void makeItemDynamic(Actor item) {
        item.setElasticity(0.9);
        item.setFriction(1.0);
        item.makeDynamic();
    }

    @Override
    public void onFrameUpdate(double pastTime) {
        for (Actor item : this.items) {
            if (!(item.getCenter().getY() < -10.0)) continue;
            this.dropDownItem(item);
        }
        if (this.logo.circleI.getY() >= 4.0) {
            this.yMovementCircleI = -0.01;
        } else if (this.logo.circleI.getY() <= 2.0) {
            this.yMovementCircleI = 0.01;
        }
        this.logo.circleI.moveBy(0.0, this.yMovementCircleI);
    }

    private String formatBuildTime() {
        Date date = new Date(Version.getBuildTime());
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss z");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    private void dropDownItem(Actor item) {
        if (!item.isMounted()) {
            this.delay(Random.range(5), () -> {
                this.items.add(item);
                this.add(item);
            });
        }
        item.resetMovement();
        item.setCenter(Random.range(-7, 7), Random.range(5, 8));
    }

    public static void main(String[] args) throws IOException {
        Game.start(new MainAnimation());
        Game.setTitle("Engine Pi " + Version.getVersion());
    }
}

