/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.event;

import de.pirckheimer_gymnasium.engine_pi.Camera;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.debug.DebugConfiguration;
import de.pirckheimer_gymnasium.engine_pi.event.DefaultListener;
import de.pirckheimer_gymnasium.engine_pi.event.MouseScrollEvent;
import java.awt.event.KeyEvent;

public class DefaultControl
implements DefaultListener {
    private static final double CAMERA_SPEED = 7.0;

    private Camera getCamera() {
        Scene scene = Game.getActiveScene();
        if (scene != null) {
            return scene.getCamera();
        }
        return null;
    }

    private boolean hasNoScene() {
        return Game.getActiveScene() == null;
    }

    @Override
    public void onKeyDown(KeyEvent event) {
        if (Game.isKeyPressed(18)) {
            double zoomFactor = 0.05;
            if (Game.isKeyPressed(16)) {
                zoomFactor = 0.2;
            }
            switch (event.getKeyCode()) {
                case 65: {
                    Game.toggleRenderActors();
                    break;
                }
                case 68: {
                    Game.toggleDebug();
                    break;
                }
                case 80: {
                    DebugConfiguration.toogleShowPositions();
                    break;
                }
                case 83: {
                    Game.takeScreenshot();
                    break;
                }
                case 521: {
                    this.getCamera().zoomIn(zoomFactor);
                    break;
                }
                case 45: {
                    this.getCamera().zoomOut(zoomFactor);
                }
            }
        }
        if (event.getKeyCode() == 27) {
            Game.exit();
        }
    }

    @Override
    public void onFrameUpdate(double pastTime) {
        if (this.hasNoScene()) {
            return;
        }
        Camera camera = this.getCamera();
        if (camera == null) {
            return;
        }
        if (Game.isKeyPressed(18)) {
            double dX = 0.0;
            double dY = 0.0;
            if (Game.isKeyPressed(38)) {
                dY = 7.0 * pastTime;
            } else if (Game.isKeyPressed(40)) {
                dY = -7.0 * pastTime;
            }
            if (Game.isKeyPressed(37)) {
                dX = -7.0 * pastTime;
            } else if (Game.isKeyPressed(39)) {
                dX = 7.0 * pastTime;
            }
            if (dX != 0.0 || dY != 0.0) {
                camera.moveBy(dX, dY);
            }
        }
    }

    @Override
    public void onMouseScrollMove(MouseScrollEvent event) {
        if (!Game.isKeyPressed(18)) {
            return;
        }
        if (this.hasNoScene()) {
            return;
        }
        Camera camera = this.getCamera();
        if (camera == null) {
            return;
        }
        double rotation = event.getPreciseWheelRotation();
        double factor = rotation > 0.0 ? 1.0 + 0.3 * rotation : 1.0 / (1.0 - 0.3 * rotation);
        double newZoom = camera.getMeter() * factor;
        if (newZoom <= 0.0) {
            return;
        }
        camera.setMeter(newZoom);
    }
}

