/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.little_engine;

import de.pirckheimer_gymnasium.engine_pi.little_engine.DrawingWindow;

public class Circle {
    public int x = 60;
    public int y = 60;
    public int radius = 50;
    public String color = "rot";
    public boolean visible = true;
    public int rotation = 0;
    DrawingWindow.GrafikSymbol symbol = DrawingWindow.SymbolErzeugen(DrawingWindow.SymbolArt.kreis);

    public Circle() {
        this.symbol.setPosition(this.x - this.radius, this.y - this.radius);
        this.symbol.setSize(this.radius * 2, this.radius * 2);
        this.symbol.setColor(this.color);
        this.symbol.setVisibility(this.visible);
        this.symbol.setRotation(this.rotation);
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.symbol.setPosition(x - this.radius, y - this.radius);
    }

    public void move(int deltaX, int deltaY) {
        this.x += deltaX;
        this.y += deltaY;
        this.symbol.setPosition(this.x - this.radius, this.y - this.radius);
    }

    public void rotate(int angle) {
        this.rotation += angle;
        this.symbol.setRotation(this.rotation);
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.symbol.setSize(radius * 2, radius * 2);
        this.symbol.setPosition(this.x - radius, this.y - radius);
    }

    public void setColor(String color) {
        this.color = color;
        this.symbol.setColor(color);
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
        this.symbol.setRotation(rotation);
    }

    public void setVisibility(boolean sichtbar) {
        this.visible = sichtbar;
        this.symbol.setVisibility(sichtbar);
    }

    public void remove() {
        this.symbol.remove();
    }

    public void raiseLayer() {
        this.symbol.raiseLayer();
    }

    public void bringToFront() {
        this.symbol.bringToFront();
    }

    public void lowerLayer() {
        this.symbol.lowerLayer();
    }

    public void bringToBack() {
        this.symbol.bringToBack();
    }
}

