/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourcesContainer;
import de.pirckheimer_gymnasium.engine_pi.util.ImageUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public final class ImageContainer
extends ResourcesContainer<BufferedImage> {
    @Override
    protected BufferedImage load(URL name) throws IOException {
        BufferedImage image = ImageIO.read(name);
        if (image == null) {
            return null;
        }
        if (Game.getPixelMultiplication() > 1) {
            image = ImageUtil.multiplyPixel(image, Game.getPixelMultiplication());
        }
        return ImageUtil.toCompatibleImage(image);
    }

    public BufferedImage get(String name, int pixelMultiplication, Color[] fromColors, Color[] toColors) {
        BufferedImage image = (BufferedImage)this.get(name);
        if (pixelMultiplication > 1) {
            image = ImageUtil.multiplyPixel(image, pixelMultiplication);
        }
        if (fromColors != null && toColors != null) {
            image = ImageUtil.replaceColors(image, fromColors, toColors);
        }
        return image;
    }

    public BufferedImage get(String name, int pixelMultiplication) {
        return this.get(name, pixelMultiplication, null, null);
    }

    public BufferedImage get(String name, Color[] fromColors, Color[] toColors) {
        return this.get(name, Game.getPixelMultiplication(), fromColors, toColors);
    }
}

