/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ResourceLoader {
    private static final Logger log = Logger.getLogger(Resources.class.getName());

    private ResourceLoader() {
    }

    public static byte[] load(String filename) throws IOException {
        String normalizedFilename = FileUtil.normalizePath(filename);
        Path path = Paths.get(normalizedFilename, new String[0]);
        URL url = ResourceLoader.class.getResource("/" + normalizedFilename);
        if (url != null) {
            try {
                path = Paths.get(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException("Could not convert URL to URI", e);
            }
        }
        return Files.readAllBytes(path);
    }

    public static InputStream loadAsStream(String filename) throws IOException {
        String normalizedFilename = FileUtil.normalizePath(filename);
        if (ResourceLoader.class.getResource("/" + normalizedFilename) != null) {
            return ResourceLoader.class.getResourceAsStream("/" + normalizedFilename);
        }
        return new FileInputStream(FileUtil.normalizePath(normalizedFilename));
    }

    public static File loadAsFile(String filename) {
        String normalizedFilename = FileUtil.normalizePath(filename);
        URL url = ResourceLoader.class.getResource("/" + normalizedFilename);
        if (url != null) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                log.log(Level.WARNING, "IO " + filename, e);
            }
        }
        return new File(FileUtil.normalizePath(normalizedFilename));
    }

    public static InputStream get(String file) {
        return ResourceLoader.get(ResourceLoader.getLocation(file));
    }

    public static InputStream get(URL file) {
        InputStream stream = ResourceLoader.getResource(file);
        if (stream == null) {
            return null;
        }
        return stream.markSupported() ? stream : new BufferedInputStream(stream);
    }

    public static String read(String file) {
        return ResourceLoader.read(file, StandardCharsets.UTF_8);
    }

    public static String read(String file, Charset charset) {
        URL location = ResourceLoader.getLocation(file);
        if (location == null) {
            return null;
        }
        return ResourceLoader.read(location, charset);
    }

    public static String read(URL file) {
        return ResourceLoader.read(file, StandardCharsets.UTF_8);
    }

    public static String read(URL file, Charset charset) {
        Scanner scanner = new Scanner(file.openStream(), charset.toString());
        try {
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : null;
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage());
                return null;
            }
        }
    }

    public static URL getLocation(String name) {
        URL fromClass = ClassLoader.getSystemResource(name);
        if (fromClass != null) {
            return fromClass;
        }
        try {
            return new URL(name);
        }
        catch (MalformedURLException e) {
            try {
                return new File(name).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    private static InputStream getResource(URL file) {
        try {
            return file.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }
}

