/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.tweening;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.event.FrameUpdateListener;
import de.pirckheimer_gymnasium.engine_pi.tweening.Tween;
import de.pirckheimer_gymnasium.engine_pi.tweening.TweenFunction;
import de.pirckheimer_gymnasium.engine_pi.tweening.TweenType;
import de.pirckheimer_gymnasium.engine_pi.tweening.Tweenable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TweenEngine
implements FrameUpdateListener {
    private final Map<Tweenable, Map<TweenType, Tween>> tweens = new ConcurrentHashMap<Tweenable, Map<TweenType, Tween>>();

    public Tween begin(Tweenable target, TweenType type, int duration) {
        Tween tween = this.getTween(target, type);
        if (tween == null) {
            tween = new Tween(target, type, duration).ease(TweenFunction.QUAD_INOUT);
            this.getTweens().get(target).put(type, tween);
        } else {
            tween.setDuration(duration);
        }
        tween.begin();
        return tween;
    }

    public Tween getTween(Tweenable target, TweenType type) {
        if (this.getTweens().get(target) == null) {
            this.getTweens().put(target, new ConcurrentHashMap());
        }
        return this.getTweens().get(target).get((Object)type);
    }

    public Map<Tweenable, Map<TweenType, Tween>> getTweens() {
        return this.tweens;
    }

    public Tween reset(Tweenable target, TweenType type) {
        Tween tween = this.getTween(target, type);
        if (tween != null) {
            tween.stop();
            tween.reset();
        }
        return tween;
    }

    public Tween resume(Tweenable target, TweenType type) {
        Tween tween = this.getTween(target, type);
        if (tween != null) {
            tween.resume();
        }
        return tween;
    }

    public void start() {
        Game.addFrameUpdateListener(this);
    }

    public void remove(Tweenable target, TweenType type) {
        Tween tween = this.getTween(target, type);
        if (tween != null) {
            this.getTweens().get(target).remove((Object)type);
        }
    }

    public Tween stop(Tweenable target, TweenType type) {
        Tween tween = this.getTween(target, type);
        if (tween != null) {
            tween.stop();
        }
        return tween;
    }

    public void terminate() {
        Game.removeFrameUpdateListener(this);
    }

    @Override
    public void onFrameUpdate(double pastTime) {
        for (Tweenable target : this.getTweens().keySet()) {
            for (Tween tween : this.getTweens().get(target).values()) {
                if (tween.hasStopped()) continue;
                long elapsed = tween.getStartTime();
                if (elapsed >= (long)tween.getDuration()) {
                    tween.stop();
                    continue;
                }
                float[] currentValues = new float[tween.getTargetValues().length];
                for (int i = 0; i < tween.getTargetValues().length; ++i) {
                    currentValues[i] = tween.getStartValues()[i] + tween.getEquation().compute((float)elapsed / (float)tween.getDuration()) * (tween.getTargetValues()[i] - tween.getStartValues()[i]);
                }
                tween.getTarget().setTweenValues(tween.getType(), currentValues);
            }
        }
    }
}

