/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.util;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.util.ColorUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;

public class Graphics2DUtil {
    private static final int DEBUG_INFO_HEIGHT = 20;
    private static final int DEBUG_INFO_LEFT = 10;
    private static final int DEBUG_INFO_TEXT_OFFSET = 16;
    private static final int FONT_SIZE = 12;
    private static final String FONT_COLOR = "white";

    private Graphics2DUtil() {
        throw new UnsupportedOperationException();
    }

    public static Font getFont(int size) {
        return new Font("Monospaced", 0, size);
    }

    public static Font getFont() {
        return Graphics2DUtil.getFont(12);
    }

    public static Font setFont(Graphics2D g, Font font) {
        g.setColor(Resources.COLORS.getSafe(FONT_COLOR));
        g.setFont(font);
        return font;
    }

    public static Font setFont(Graphics2D g, int size, String color) {
        Font font = Graphics2DUtil.getFont(size);
        g.setColor(Resources.COLORS.get(color));
        g.setFont(font);
        return font;
    }

    public static Font setFont(Graphics2D g, int size) {
        return Graphics2DUtil.setFont(g, size, FONT_COLOR);
    }

    public static Font setFont(Graphics2D g, String color) {
        return Graphics2DUtil.setFont(g, 12, color);
    }

    public static Font setFont(Graphics2D g) {
        return Graphics2DUtil.setFont(g, 12, FONT_COLOR);
    }

    public static void drawText(Graphics2D g, String text, int x, int y) {
        Graphics2DUtil.setFont(g);
        g.drawString(text, x, y);
    }

    public static void drawText(Graphics2D g, String text, int size, int x, int y) {
        Graphics2DUtil.setFont(g, size);
        g.drawString(text, x, y);
    }

    public static void drawTextBox(Graphics2D g, String text, int y, Color background) {
        Font font = Graphics2DUtil.getFont();
        FontMetrics fm = g.getFontMetrics(font);
        Rectangle2D bounds = fm.getStringBounds(text, g);
        g.setColor(ColorUtil.changeAlpha(background, 150));
        g.fillRect(10, y, (int)bounds.getWidth() + 20, (int)bounds.getHeight() + 16);
        g.setColor(ColorUtil.changeAlpha(background.darker().darker(), 150));
        g.drawRect(10, y, (int)bounds.getWidth() + 20 - 1, (int)bounds.getHeight() + 16 - 1);
        Graphics2DUtil.setFont(g, font);
        g.drawString(text, 20, y + 8 + fm.getHeight() - fm.getDescent());
    }

    public static void drawArrowLine(Graphics2D g, int x1, int y1, int x2, int y2, int arrowWidth, int arrowHeight, Color color) {
        double xm;
        int dx = x2 - x1;
        int dy = y2 - y1;
        double D = Math.sqrt(dx * dx + dy * dy);
        double xn = xm = D - (double)arrowWidth;
        double ym = arrowHeight;
        double yn = -arrowHeight;
        double sin = (double)dy / D;
        double cos = (double)dx / D;
        double x = xm * cos - ym * sin + (double)x1;
        ym = xm * sin + ym * cos + (double)y1;
        xm = x;
        x = xn * cos - yn * sin + (double)x1;
        yn = xn * sin + yn * cos + (double)y1;
        xn = x;
        int[] xPoints = new int[]{x2, (int)xm, (int)xn};
        int[] yPoints = new int[]{y2, (int)ym, (int)yn};
        g.setColor(color);
        g.drawLine(x1, y1, x2, y2);
        g.fillPolygon(xPoints, yPoints, 3);
    }

    public static void setAntiAliasing(Graphics2D g, boolean on) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, on ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public static void main(String[] args) {
        Game.debug();
        Game.start(new Scene(){
            {
                this.setGravityOfEarth();
                this.addCircle(7.0).setCenter(0.0, 0.0).makeStatic();
            }
        });
    }
}

