/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.collision;

import de.pirckheimer_gymnasium.jbox2d.collision.DistanceInput;
import de.pirckheimer_gymnasium.jbox2d.collision.DistanceOutput;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ChainShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.CircleShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.EdgeShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.PolygonShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;

public class Distance {
    public static final int MAX_ITERS = 20;
    public static int GJK_CALLS = 0;
    public static int GJK_ITERS = 0;
    public static int GJK_MAX_ITERS = 20;
    private final Simplex simplex = new Simplex();
    private final int[] saveA = new int[3];
    private final int[] saveB = new int[3];
    private final Vec2 closestPoint = new Vec2();
    private final Vec2 d = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 normal = new Vec2();

    public final void distance(DistanceOutput output, SimplexCache cache, DistanceInput input) {
        ++GJK_CALLS;
        DistanceProxy proxyA = input.proxyA;
        DistanceProxy proxyB = input.proxyB;
        Transform transformA = input.transformA;
        Transform transformB = input.transformB;
        this.simplex.readCache(cache, proxyA, transformA, proxyB, transformB);
        SimplexVertex[] vertices = this.simplex.vertices;
        this.simplex.getClosestPoint(this.closestPoint);
        int iter = 0;
        while (iter < 20) {
            int saveCount = this.simplex.count;
            for (int i = 0; i < saveCount; ++i) {
                this.saveA[i] = vertices[i].indexA;
                this.saveB[i] = vertices[i].indexB;
            }
            switch (this.simplex.count) {
                case 1: {
                    break;
                }
                case 2: {
                    this.simplex.solve2();
                    break;
                }
                case 3: {
                    this.simplex.solve3();
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.simplex.count == 3) break;
            this.simplex.getClosestPoint(this.closestPoint);
            this.simplex.getSearchDirection(this.d);
            if (this.d.lengthSquared() < 1.4210855E-14f) break;
            SimplexVertex vertex = vertices[this.simplex.count];
            Rot.mulTransUnsafe(transformA.q, this.d.negateLocal(), this.temp);
            vertex.indexA = proxyA.getSupport(this.temp);
            Transform.mulToOutUnsafe(transformA, proxyA.getVertex(vertex.indexA), vertex.wA);
            Rot.mulTransUnsafe(transformB.q, this.d.negateLocal(), this.temp);
            vertex.indexB = proxyB.getSupport(this.temp);
            Transform.mulToOutUnsafe(transformB, proxyB.getVertex(vertex.indexB), vertex.wB);
            vertex.w.set(vertex.wB).subLocal(vertex.wA);
            ++iter;
            ++GJK_ITERS;
            boolean duplicate = false;
            for (int i = 0; i < saveCount; ++i) {
                if (vertex.indexA != this.saveA[i] || vertex.indexB != this.saveB[i]) continue;
                duplicate = true;
                break;
            }
            if (duplicate) break;
            ++this.simplex.count;
        }
        GJK_MAX_ITERS = MathUtils.max(GJK_MAX_ITERS, iter);
        this.simplex.getWitnessPoints(output.pointA, output.pointB);
        output.distance = MathUtils.distance(output.pointA, output.pointB);
        output.iterations = iter;
        this.simplex.writeCache(cache);
        if (input.useRadii) {
            float rA = proxyA.radius;
            float rB = proxyB.radius;
            if (output.distance > rA + rB && output.distance > 1.1920929E-7f) {
                output.distance -= rA + rB;
                this.normal.set(output.pointB).subLocal(output.pointA);
                this.normal.normalize();
                this.temp.set(this.normal).mulLocal(rA);
                output.pointA.addLocal(this.temp);
                this.temp.set(this.normal).mulLocal(rB);
                output.pointB.subLocal(this.temp);
            } else {
                output.pointA.addLocal(output.pointB).mulLocal(0.5f);
                output.pointB.set(output.pointA);
                output.distance = 0.0f;
            }
        }
    }

    private static class Simplex {
        public final SimplexVertex v1 = new SimplexVertex();
        public final SimplexVertex v2 = new SimplexVertex();
        public final SimplexVertex v3 = new SimplexVertex();
        public final SimplexVertex[] vertices = new SimplexVertex[]{this.v1, this.v2, this.v3};
        public int count;
        private final Vec2 e12 = new Vec2();
        private final Vec2 case2 = new Vec2();
        private final Vec2 case22 = new Vec2();
        private final Vec2 case3 = new Vec2();
        private final Vec2 case33 = new Vec2();
        private final Vec2 e13 = new Vec2();
        private final Vec2 e23 = new Vec2();
        private final Vec2 w1 = new Vec2();
        private final Vec2 w2 = new Vec2();
        private final Vec2 w3 = new Vec2();

        private Simplex() {
        }

        public void readCache(SimplexCache cache, DistanceProxy proxyA, Transform transformA, DistanceProxy proxyB, Transform transformB) {
            assert (cache.count <= 3);
            this.count = cache.count;
            for (int i = 0; i < this.count; ++i) {
                SimplexVertex v = this.vertices[i];
                v.indexA = cache.indexA[i];
                v.indexB = cache.indexB[i];
                Vec2 wALocal = proxyA.getVertex(v.indexA);
                Vec2 wBLocal = proxyB.getVertex(v.indexB);
                Transform.mulToOutUnsafe(transformA, wALocal, v.wA);
                Transform.mulToOutUnsafe(transformB, wBLocal, v.wB);
                v.w.set(v.wB).subLocal(v.wA);
                v.a = 0.0f;
            }
            if (this.count > 1) {
                float metric1 = cache.metric;
                float metric2 = this.getMetric();
                if (metric2 < 0.5f * metric1 || 2.0f * metric1 < metric2 || metric2 < 1.1920929E-7f) {
                    this.count = 0;
                }
            }
            if (this.count == 0) {
                SimplexVertex v = this.vertices[0];
                v.indexA = 0;
                v.indexB = 0;
                Vec2 wALocal = proxyA.getVertex(0);
                Vec2 wBLocal = proxyB.getVertex(0);
                Transform.mulToOutUnsafe(transformA, wALocal, v.wA);
                Transform.mulToOutUnsafe(transformB, wBLocal, v.wB);
                v.w.set(v.wB).subLocal(v.wA);
                this.count = 1;
            }
        }

        public void writeCache(SimplexCache cache) {
            cache.metric = this.getMetric();
            cache.count = this.count;
            for (int i = 0; i < this.count; ++i) {
                cache.indexA[i] = this.vertices[i].indexA;
                cache.indexB[i] = this.vertices[i].indexB;
            }
        }

        public final void getSearchDirection(Vec2 out) {
            switch (this.count) {
                case 1: {
                    out.set(this.v1.w).negateLocal();
                    return;
                }
                case 2: {
                    this.e12.set(this.v2.w).subLocal(this.v1.w);
                    out.set(this.v1.w).negateLocal();
                    float sgn = Vec2.cross(this.e12, out);
                    if (sgn > 0.0f) {
                        Vec2.crossToOutUnsafe(1.0f, this.e12, out);
                    } else {
                        Vec2.crossToOutUnsafe(this.e12, 1.0f, out);
                    }
                    return;
                }
            }
            assert (false);
            out.setZero();
        }

        public void getClosestPoint(Vec2 out) {
            switch (this.count) {
                case 1: {
                    out.set(this.v1.w);
                    return;
                }
                case 2: {
                    this.case22.set(this.v2.w).mulLocal(this.v2.a);
                    this.case2.set(this.v1.w).mulLocal(this.v1.a).addLocal(this.case22);
                    out.set(this.case2);
                    return;
                }
                case 3: {
                    out.setZero();
                    return;
                }
            }
            assert (false);
            out.setZero();
        }

        public void getWitnessPoints(Vec2 pA, Vec2 pB) {
            switch (this.count) {
                case 1: {
                    pA.set(this.v1.wA);
                    pB.set(this.v1.wB);
                    break;
                }
                case 2: {
                    this.case2.set(this.v1.wA).mulLocal(this.v1.a);
                    pA.set(this.v2.wA).mulLocal(this.v2.a).addLocal(this.case2);
                    this.case2.set(this.v1.wB).mulLocal(this.v1.a);
                    pB.set(this.v2.wB).mulLocal(this.v2.a).addLocal(this.case2);
                    break;
                }
                case 3: {
                    pA.set(this.v1.wA).mulLocal(this.v1.a);
                    this.case3.set(this.v2.wA).mulLocal(this.v2.a);
                    this.case33.set(this.v3.wA).mulLocal(this.v3.a);
                    pA.addLocal(this.case3).addLocal(this.case33);
                    pB.set(pA);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public float getMetric() {
            switch (this.count) {
                case 1: {
                    return 0.0f;
                }
                case 2: {
                    return MathUtils.distance(this.v1.w, this.v2.w);
                }
                case 3: {
                    this.case3.set(this.v2.w).subLocal(this.v1.w);
                    this.case33.set(this.v3.w).subLocal(this.v1.w);
                    return Vec2.cross(this.case3, this.case33);
                }
            }
            assert (false);
            return 0.0f;
        }

        public void solve2() {
            Vec2 w1 = this.v1.w;
            Vec2 w2 = this.v2.w;
            this.e12.set(w2).subLocal(w1);
            float d12_2 = -Vec2.dot(w1, this.e12);
            if (d12_2 <= 0.0f) {
                this.v1.a = 1.0f;
                this.count = 1;
                return;
            }
            float d12_1 = Vec2.dot(w2, this.e12);
            if (d12_1 <= 0.0f) {
                this.v2.a = 1.0f;
                this.count = 1;
                this.v1.set(this.v2);
                return;
            }
            float inv_d12 = 1.0f / (d12_1 + d12_2);
            this.v1.a = d12_1 * inv_d12;
            this.v2.a = d12_2 * inv_d12;
            this.count = 2;
        }

        public void solve3() {
            this.w1.set(this.v1.w);
            this.w2.set(this.v2.w);
            this.w3.set(this.v3.w);
            this.e12.set(this.w2).subLocal(this.w1);
            float w1e12 = Vec2.dot(this.w1, this.e12);
            float d12_1 = Vec2.dot(this.w2, this.e12);
            float d12_2 = -w1e12;
            this.e13.set(this.w3).subLocal(this.w1);
            float w1e13 = Vec2.dot(this.w1, this.e13);
            float d13_1 = Vec2.dot(this.w3, this.e13);
            float d13_2 = -w1e13;
            this.e23.set(this.w3).subLocal(this.w2);
            float w2e23 = Vec2.dot(this.w2, this.e23);
            float d23_1 = Vec2.dot(this.w3, this.e23);
            float d23_2 = -w2e23;
            float n123 = Vec2.cross(this.e12, this.e13);
            float d123_1 = n123 * Vec2.cross(this.w2, this.w3);
            float d123_2 = n123 * Vec2.cross(this.w3, this.w1);
            float d123_3 = n123 * Vec2.cross(this.w1, this.w2);
            if (d12_2 <= 0.0f && d13_2 <= 0.0f) {
                this.v1.a = 1.0f;
                this.count = 1;
                return;
            }
            if (d12_1 > 0.0f && d12_2 > 0.0f && d123_3 <= 0.0f) {
                float inv_d12 = 1.0f / (d12_1 + d12_2);
                this.v1.a = d12_1 * inv_d12;
                this.v2.a = d12_2 * inv_d12;
                this.count = 2;
                return;
            }
            if (d13_1 > 0.0f && d13_2 > 0.0f && d123_2 <= 0.0f) {
                float inv_d13 = 1.0f / (d13_1 + d13_2);
                this.v1.a = d13_1 * inv_d13;
                this.v3.a = d13_2 * inv_d13;
                this.count = 2;
                this.v2.set(this.v3);
                return;
            }
            if (d12_1 <= 0.0f && d23_2 <= 0.0f) {
                this.v2.a = 1.0f;
                this.count = 1;
                this.v1.set(this.v2);
                return;
            }
            if (d13_1 <= 0.0f && d23_1 <= 0.0f) {
                this.v3.a = 1.0f;
                this.count = 1;
                this.v1.set(this.v3);
                return;
            }
            if (d23_1 > 0.0f && d23_2 > 0.0f && d123_1 <= 0.0f) {
                float inv_d23 = 1.0f / (d23_1 + d23_2);
                this.v2.a = d23_1 * inv_d23;
                this.v3.a = d23_2 * inv_d23;
                this.count = 2;
                this.v1.set(this.v3);
                return;
            }
            float inv_d123 = 1.0f / (d123_1 + d123_2 + d123_3);
            this.v1.a = d123_1 * inv_d123;
            this.v2.a = d123_2 * inv_d123;
            this.v3.a = d123_3 * inv_d123;
            this.count = 3;
        }
    }

    public static class DistanceProxy {
        public final Vec2[] vertices = new Vec2[Settings.maxPolygonVertices];
        public int count;
        public float radius;
        public final Vec2[] buffer;

        public DistanceProxy() {
            for (int i = 0; i < this.vertices.length; ++i) {
                this.vertices[i] = new Vec2();
            }
            this.buffer = new Vec2[2];
            this.count = 0;
            this.radius = 0.0f;
        }

        public final void set(Shape shape, int index) {
            switch (shape.getType()) {
                case CIRCLE: {
                    CircleShape circle = (CircleShape)shape;
                    this.vertices[0].set(circle.p);
                    this.count = 1;
                    this.radius = circle.radius;
                    break;
                }
                case POLYGON: {
                    PolygonShape poly = (PolygonShape)shape;
                    this.count = poly.count;
                    this.radius = poly.radius;
                    for (int i = 0; i < this.count; ++i) {
                        this.vertices[i].set(poly.vertices[i]);
                    }
                    break;
                }
                case CHAIN: {
                    ChainShape chain = (ChainShape)shape;
                    assert (0 <= index && index < chain.count);
                    this.buffer[0] = chain.vertices[index];
                    this.buffer[1] = index + 1 < chain.count ? chain.vertices[index + 1] : chain.vertices[0];
                    this.vertices[0].set(this.buffer[0]);
                    this.vertices[1].set(this.buffer[1]);
                    this.count = 2;
                    this.radius = chain.radius;
                    break;
                }
                case EDGE: {
                    EdgeShape edge = (EdgeShape)shape;
                    this.vertices[0].set(edge.vertex1);
                    this.vertices[1].set(edge.vertex2);
                    this.count = 2;
                    this.radius = edge.radius;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public final int getSupport(Vec2 d) {
            int bestIndex = 0;
            float bestValue = Vec2.dot(this.vertices[0], d);
            for (int i = 1; i < this.count; ++i) {
                float value = Vec2.dot(this.vertices[i], d);
                if (!(value > bestValue)) continue;
                bestIndex = i;
                bestValue = value;
            }
            return bestIndex;
        }

        public final Vec2 getSupportVertex(Vec2 d) {
            int bestIndex = 0;
            float bestValue = Vec2.dot(this.vertices[0], d);
            for (int i = 1; i < this.count; ++i) {
                float value = Vec2.dot(this.vertices[i], d);
                if (!(value > bestValue)) continue;
                bestIndex = i;
                bestValue = value;
            }
            return this.vertices[bestIndex];
        }

        public final int getVertexCount() {
            return this.count;
        }

        public final Vec2 getVertex(int index) {
            assert (0 <= index && index < this.count);
            return this.vertices[index];
        }
    }

    public static class SimplexCache {
        public float metric = 0.0f;
        public int count = 0;
        public final int[] indexA = new int[3];
        public final int[] indexB = new int[3];

        public SimplexCache() {
            this.indexA[0] = Integer.MAX_VALUE;
            this.indexA[1] = Integer.MAX_VALUE;
            this.indexA[2] = Integer.MAX_VALUE;
            this.indexB[0] = Integer.MAX_VALUE;
            this.indexB[1] = Integer.MAX_VALUE;
            this.indexB[2] = Integer.MAX_VALUE;
        }

        public void set(SimplexCache sc) {
            System.arraycopy(sc.indexA, 0, this.indexA, 0, this.indexA.length);
            System.arraycopy(sc.indexB, 0, this.indexB, 0, this.indexB.length);
            this.metric = sc.metric;
            this.count = sc.count;
        }
    }

    private static class SimplexVertex {
        public final Vec2 wA = new Vec2();
        public final Vec2 wB = new Vec2();
        public final Vec2 w = new Vec2();
        public float a;
        public int indexA;
        public int indexB;

        private SimplexVertex() {
        }

        public void set(SimplexVertex sv) {
            this.wA.set(sv.wA);
            this.wB.set(sv.wB);
            this.w.set(sv.w);
            this.a = sv.a;
            this.indexA = sv.indexA;
            this.indexB = sv.indexB;
        }
    }
}

