/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.collision.broadphase;

import de.pirckheimer_gymnasium.jbox2d.callbacks.DebugDraw;
import de.pirckheimer_gymnasium.jbox2d.callbacks.TreeCallback;
import de.pirckheimer_gymnasium.jbox2d.callbacks.TreeRayCastCallback;
import de.pirckheimer_gymnasium.jbox2d.collision.AABB;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastInput;
import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.BroadPhaseStrategy;
import de.pirckheimer_gymnasium.jbox2d.common.BufferUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Color3f;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;

public class DynamicTreeFlatNodes
implements BroadPhaseStrategy {
    public static final int MAX_STACK_SIZE = 64;
    public static final int NULL_NODE = -1;
    public static final int INITIAL_BUFFER_LENGTH = 16;
    public int root = -1;
    public AABB[] memberAabb;
    public Object[] userData;
    protected int[] parent;
    protected int[] child1;
    protected int[] child2;
    protected int[] height;
    private int nodeCount = 0;
    private int nodeCapacity = 16;
    private int freeList;
    private final Vec2[] drawVecs = new Vec2[4];
    private int[] nodeStack = new int[20];
    private int nodeStackIndex;
    private final Vec2 r = new Vec2();
    private final AABB aabb = new AABB();
    private final RayCastInput subInput = new RayCastInput();
    private final AABB combinedAABB = new AABB();
    private final Color3f color = new Color3f();
    private final Vec2 textVec = new Vec2();

    public DynamicTreeFlatNodes() {
        this.expandBuffers(0, this.nodeCapacity);
        for (int i = 0; i < this.drawVecs.length; ++i) {
            this.drawVecs[i] = new Vec2();
        }
    }

    private void expandBuffers(int oldSize, int newSize) {
        this.memberAabb = BufferUtils.reallocateBuffer(AABB.class, this.memberAabb, oldSize, newSize);
        this.userData = BufferUtils.reallocateBuffer(Object.class, this.userData, oldSize, newSize);
        this.parent = BufferUtils.reallocateBuffer(this.parent, oldSize, newSize);
        this.child1 = BufferUtils.reallocateBuffer(this.child1, oldSize, newSize);
        this.child2 = BufferUtils.reallocateBuffer(this.child2, oldSize, newSize);
        this.height = BufferUtils.reallocateBuffer(this.height, oldSize, newSize);
        for (int i = oldSize; i < newSize; ++i) {
            this.memberAabb[i] = new AABB();
            this.parent[i] = i == newSize - 1 ? -1 : i + 1;
            this.height[i] = -1;
            this.child1[i] = -1;
            this.child2[i] = -1;
        }
        this.freeList = oldSize;
    }

    @Override
    public final int createProxy(AABB aabb, Object userData) {
        int node = this.allocateNode();
        AABB nodeAABB = this.memberAabb[node];
        nodeAABB.lowerBound.x = aabb.lowerBound.x - Settings.aabbExtension;
        nodeAABB.lowerBound.y = aabb.lowerBound.y - Settings.aabbExtension;
        nodeAABB.upperBound.x = aabb.upperBound.x + Settings.aabbExtension;
        nodeAABB.upperBound.y = aabb.upperBound.y + Settings.aabbExtension;
        this.userData[node] = userData;
        this.insertLeaf(node);
        return node;
    }

    @Override
    public final void destroyProxy(int proxyId) {
        assert (0 <= proxyId && proxyId < this.nodeCapacity);
        assert (this.child1[proxyId] == -1);
        this.removeLeaf(proxyId);
        this.freeNode(proxyId);
    }

    @Override
    public final boolean moveProxy(int proxyId, AABB aabb, Vec2 displacement) {
        assert (0 <= proxyId && proxyId < this.nodeCapacity);
        int node = proxyId;
        assert (this.child1[node] == -1);
        AABB nodeAABB = this.memberAabb[node];
        if (nodeAABB.lowerBound.x <= aabb.lowerBound.x && nodeAABB.lowerBound.y <= aabb.lowerBound.y && aabb.upperBound.x <= nodeAABB.upperBound.x && aabb.upperBound.y <= nodeAABB.upperBound.y) {
            return false;
        }
        this.removeLeaf(node);
        Vec2 lowerBound = nodeAABB.lowerBound;
        Vec2 upperBound = nodeAABB.upperBound;
        lowerBound.x = aabb.lowerBound.x - Settings.aabbExtension;
        lowerBound.y = aabb.lowerBound.y - Settings.aabbExtension;
        upperBound.x = aabb.upperBound.x + Settings.aabbExtension;
        upperBound.y = aabb.upperBound.y + Settings.aabbExtension;
        float dx = displacement.x * Settings.aabbMultiplier;
        float dy = displacement.y * Settings.aabbMultiplier;
        if (dx < 0.0f) {
            lowerBound.x += dx;
        } else {
            upperBound.x += dx;
        }
        if (dy < 0.0f) {
            lowerBound.y += dy;
        } else {
            upperBound.y += dy;
        }
        this.insertLeaf(proxyId);
        return true;
    }

    @Override
    public final Object getUserData(int proxyId) {
        assert (0 <= proxyId && proxyId < this.nodeCount);
        return this.userData[proxyId];
    }

    @Override
    public final AABB getFatAABB(int proxyId) {
        assert (0 <= proxyId && proxyId < this.nodeCount);
        return this.memberAabb[proxyId];
    }

    @Override
    public final void query(TreeCallback callback, AABB aabb) {
        this.nodeStackIndex = 0;
        this.nodeStack[this.nodeStackIndex++] = this.root;
        while (this.nodeStackIndex > 0) {
            int node;
            if ((node = this.nodeStack[--this.nodeStackIndex]) == -1 || !AABB.testOverlap(this.memberAabb[node], aabb)) continue;
            int child1 = this.child1[node];
            if (child1 == -1) {
                boolean proceed = callback.treeCallback(node);
                if (proceed) continue;
                return;
            }
            if (this.nodeStack.length - this.nodeStackIndex - 2 <= 0) {
                this.nodeStack = BufferUtils.reallocateBuffer(this.nodeStack, this.nodeStack.length, this.nodeStack.length * 2);
            }
            this.nodeStack[this.nodeStackIndex++] = child1;
            this.nodeStack[this.nodeStackIndex++] = this.child2[node];
        }
    }

    @Override
    public void raycast(TreeRayCastCallback callback, RayCastInput input) {
        Vec2 p1 = input.p1;
        Vec2 p2 = input.p2;
        float p1x = p1.x;
        float p2x = p2.x;
        float p1y = p1.y;
        float p2y = p2.y;
        this.r.x = p2x - p1x;
        this.r.y = p2y - p1y;
        assert (this.r.x * this.r.x + this.r.y * this.r.y > 0.0f);
        this.r.normalize();
        float rx = this.r.x;
        float ry = this.r.y;
        float vx = -1.0f * ry;
        float vy = rx;
        float absVx = MathUtils.abs(vx);
        float absVy = MathUtils.abs(vy);
        float maxFraction = input.maxFraction;
        AABB segAABB = this.aabb;
        float tempx = (p2x - p1x) * maxFraction + p1x;
        float tempy = (p2y - p1y) * maxFraction + p1y;
        segAABB.lowerBound.x = Math.min(p1x, tempx);
        segAABB.lowerBound.y = Math.min(p1y, tempy);
        segAABB.upperBound.x = Math.max(p1x, tempx);
        segAABB.upperBound.y = Math.max(p1y, tempy);
        this.nodeStackIndex = 0;
        this.nodeStack[this.nodeStackIndex++] = this.root;
        while (this.nodeStackIndex > 0) {
            AABB nodeAABB;
            this.nodeStack[--this.nodeStackIndex] = this.root;
            int node = this.nodeStack[--this.nodeStackIndex];
            if (node == -1 || !AABB.testOverlap(nodeAABB = this.memberAabb[node], segAABB)) continue;
            float cx = (nodeAABB.lowerBound.x + nodeAABB.upperBound.x) * 0.5f;
            float cy = (nodeAABB.lowerBound.y + nodeAABB.upperBound.y) * 0.5f;
            float hx = (nodeAABB.upperBound.x - nodeAABB.lowerBound.x) * 0.5f;
            float hy = (nodeAABB.upperBound.y - nodeAABB.lowerBound.y) * 0.5f;
            tempx = p1x - cx;
            tempy = p1y - cy;
            float separation = MathUtils.abs(vx * tempx + vy * tempy) - (absVx * hx + absVy * hy);
            if (separation > 0.0f) continue;
            int child1 = this.child1[node];
            if (child1 == -1) {
                this.subInput.p1.x = p1x;
                this.subInput.p1.y = p1y;
                this.subInput.p2.x = p2x;
                this.subInput.p2.y = p2y;
                this.subInput.maxFraction = maxFraction;
                float value = callback.raycastCallback(this.subInput, node);
                if (value == 0.0f) {
                    return;
                }
                if (!(value > 0.0f)) continue;
                maxFraction = value;
                tempx = (p2x - p1x) * maxFraction + p1x;
                tempy = (p2y - p1y) * maxFraction + p1y;
                segAABB.lowerBound.x = Math.min(p1x, tempx);
                segAABB.lowerBound.y = Math.min(p1y, tempy);
                segAABB.upperBound.x = Math.max(p1x, tempx);
                segAABB.upperBound.y = Math.max(p1y, tempy);
                continue;
            }
            this.nodeStack[this.nodeStackIndex++] = child1;
            this.nodeStack[this.nodeStackIndex++] = this.child2[node];
        }
    }

    @Override
    public final int computeHeight() {
        return this.computeHeight(this.root);
    }

    private int computeHeight(int node) {
        assert (0 <= node && node < this.nodeCapacity);
        if (this.child1[node] == -1) {
            return 0;
        }
        int height1 = this.computeHeight(this.child1[node]);
        int height2 = this.computeHeight(this.child2[node]);
        return 1 + MathUtils.max(height1, height2);
    }

    public void validate() {
        this.validateStructure(this.root);
        this.validateMetrics(this.root);
        int freeCount = 0;
        int freeNode = this.freeList;
        while (freeNode != -1) {
            assert (0 <= freeNode && freeNode < this.nodeCapacity);
            freeNode = this.parent[freeNode];
            ++freeCount;
        }
        assert (this.getHeight() == this.computeHeight());
        assert (this.nodeCount + freeCount == this.nodeCapacity);
    }

    @Override
    public int getHeight() {
        if (this.root == -1) {
            return 0;
        }
        return this.height[this.root];
    }

    @Override
    public int getMaxBalance() {
        int maxBalance = 0;
        for (int i = 0; i < this.nodeCapacity; ++i) {
            if (this.height[i] <= 1) continue;
            assert (this.child1[i] != -1);
            int child1 = this.child1[i];
            int child2 = this.child2[i];
            int balance = MathUtils.abs(this.height[child2] - this.height[child1]);
            maxBalance = MathUtils.max(maxBalance, balance);
        }
        return maxBalance;
    }

    @Override
    public float getAreaRatio() {
        if (this.root == -1) {
            return 0.0f;
        }
        int root = this.root;
        float rootArea = this.memberAabb[root].getPerimeter();
        float totalArea = 0.0f;
        for (int i = 0; i < this.nodeCapacity; ++i) {
            if (this.height[i] < 0) continue;
            totalArea += this.memberAabb[i].getPerimeter();
        }
        return totalArea / rootArea;
    }

    private final int allocateNode() {
        if (this.freeList == -1) {
            assert (this.nodeCount == this.nodeCapacity);
            this.nodeCapacity *= 2;
            this.expandBuffers(this.nodeCount, this.nodeCapacity);
        }
        assert (this.freeList != -1);
        int node = this.freeList;
        this.freeList = this.parent[node];
        this.parent[node] = -1;
        this.child1[node] = -1;
        this.height[node] = 0;
        ++this.nodeCount;
        return node;
    }

    private final void freeNode(int node) {
        assert (node != -1);
        assert (0 < this.nodeCount);
        this.parent[node] = this.freeList != -1 ? this.freeList : -1;
        this.height[node] = -1;
        this.freeList = node;
        --this.nodeCount;
    }

    private final void insertLeaf(int leaf) {
        if (this.root == -1) {
            this.root = leaf;
            this.parent[this.root] = -1;
            return;
        }
        AABB leafAABB = this.memberAabb[leaf];
        int index = this.root;
        while (this.child1[index] != -1) {
            float cost2;
            float cost1;
            int node = index;
            int child1 = this.child1[node];
            int child2 = this.child2[node];
            AABB nodeAABB = this.memberAabb[node];
            float area = nodeAABB.getPerimeter();
            this.combinedAABB.combine(nodeAABB, leafAABB);
            float combinedArea = this.combinedAABB.getPerimeter();
            float cost = 2.0f * combinedArea;
            float inheritanceCost = 2.0f * (combinedArea - area);
            AABB child1AABB = this.memberAabb[child1];
            if (this.child1[child1] == -1) {
                this.combinedAABB.combine(leafAABB, child1AABB);
                cost1 = this.combinedAABB.getPerimeter() + inheritanceCost;
            } else {
                this.combinedAABB.combine(leafAABB, child1AABB);
                float oldArea = child1AABB.getPerimeter();
                float newArea = this.combinedAABB.getPerimeter();
                cost1 = newArea - oldArea + inheritanceCost;
            }
            AABB child2AABB = this.memberAabb[child2];
            if (this.child1[child2] == -1) {
                this.combinedAABB.combine(leafAABB, child2AABB);
                cost2 = this.combinedAABB.getPerimeter() + inheritanceCost;
            } else {
                this.combinedAABB.combine(leafAABB, child2AABB);
                float oldArea = child2AABB.getPerimeter();
                float newArea = this.combinedAABB.getPerimeter();
                cost2 = newArea - oldArea + inheritanceCost;
            }
            if (cost < cost1 && cost < cost2) break;
            if (cost1 < cost2) {
                index = child1;
                continue;
            }
            index = child2;
        }
        int sibling = index;
        int oldParent = this.parent[sibling];
        int newParent = this.allocateNode();
        this.parent[newParent] = oldParent;
        this.userData[newParent] = null;
        this.memberAabb[newParent].combine(leafAABB, this.memberAabb[sibling]);
        this.height[newParent] = this.height[sibling] + 1;
        if (oldParent != -1) {
            if (this.child1[oldParent] == sibling) {
                this.child1[oldParent] = newParent;
            } else {
                this.child2[oldParent] = newParent;
            }
            this.child1[newParent] = sibling;
            this.child2[newParent] = leaf;
            this.parent[sibling] = newParent;
            this.parent[leaf] = newParent;
        } else {
            this.child1[newParent] = sibling;
            this.child2[newParent] = leaf;
            this.parent[sibling] = newParent;
            this.parent[leaf] = newParent;
            this.root = newParent;
        }
        index = this.parent[leaf];
        while (index != -1) {
            index = this.balance(index);
            int child1 = this.child1[index];
            int child2 = this.child2[index];
            assert (child1 != -1);
            assert (child2 != -1);
            this.height[index] = 1 + MathUtils.max(this.height[child1], this.height[child2]);
            this.memberAabb[index].combine(this.memberAabb[child1], this.memberAabb[child2]);
            index = this.parent[index];
        }
    }

    private final void removeLeaf(int leaf) {
        if (leaf == this.root) {
            this.root = -1;
            return;
        }
        int parent = this.parent[leaf];
        int grandParent = this.parent[parent];
        int parentChild1 = this.child1[parent];
        int parentChild2 = this.child2[parent];
        int sibling = parentChild1 == leaf ? parentChild2 : parentChild1;
        if (grandParent != -1) {
            if (this.child1[grandParent] == parent) {
                this.child1[grandParent] = sibling;
            } else {
                this.child2[grandParent] = sibling;
            }
            this.parent[sibling] = grandParent;
            this.freeNode(parent);
            int index = grandParent;
            while (index != -1) {
                index = this.balance(index);
                int child1 = this.child1[index];
                int child2 = this.child2[index];
                this.memberAabb[index].combine(this.memberAabb[child1], this.memberAabb[child2]);
                this.height[index] = 1 + MathUtils.max(this.height[child1], this.height[child2]);
                index = this.parent[index];
            }
        } else {
            this.root = sibling;
            this.parent[sibling] = -1;
            this.freeNode(parent);
        }
    }

    private int balance(int iA) {
        assert (iA != -1);
        int A = iA;
        if (this.child1[A] == -1 || this.height[A] < 2) {
            return iA;
        }
        int iB = this.child1[A];
        int iC = this.child2[A];
        assert (0 <= iB && iB < this.nodeCapacity);
        assert (0 <= iC && iC < this.nodeCapacity);
        int C = iC;
        int B = iB;
        int balance = this.height[C] - this.height[B];
        if (balance > 1) {
            int iF = this.child1[C];
            int iG = this.child2[C];
            int F = iF;
            int G = iG;
            assert (0 <= iF && iF < this.nodeCapacity);
            assert (0 <= iG && iG < this.nodeCapacity);
            this.child1[C] = iA;
            int cParent = this.parent[C] = this.parent[A];
            this.parent[A] = iC;
            if (cParent != -1) {
                if (this.child1[cParent] == iA) {
                    this.child1[cParent] = iC;
                } else {
                    assert (this.child2[cParent] == iA);
                    this.child2[cParent] = iC;
                }
            } else {
                this.root = iC;
            }
            if (this.height[F] > this.height[G]) {
                this.child2[C] = iF;
                this.child2[A] = iG;
                this.parent[G] = iA;
                this.memberAabb[A].combine(this.memberAabb[B], this.memberAabb[G]);
                this.memberAabb[C].combine(this.memberAabb[A], this.memberAabb[F]);
                this.height[A] = 1 + MathUtils.max(this.height[B], this.height[G]);
                this.height[C] = 1 + MathUtils.max(this.height[A], this.height[F]);
            } else {
                this.child2[C] = iG;
                this.child2[A] = iF;
                this.parent[F] = iA;
                this.memberAabb[A].combine(this.memberAabb[B], this.memberAabb[F]);
                this.memberAabb[C].combine(this.memberAabb[A], this.memberAabb[G]);
                this.height[A] = 1 + MathUtils.max(this.height[B], this.height[F]);
                this.height[C] = 1 + MathUtils.max(this.height[A], this.height[G]);
            }
            return iC;
        }
        if (balance < -1) {
            int iD = this.child1[B];
            int iE = this.child2[B];
            int D = iD;
            int E = iE;
            assert (0 <= iD && iD < this.nodeCapacity);
            assert (0 <= iE && iE < this.nodeCapacity);
            this.child1[B] = iA;
            int Bparent = this.parent[B] = this.parent[A];
            this.parent[A] = iB;
            if (Bparent != -1) {
                if (this.child1[Bparent] == iA) {
                    this.child1[Bparent] = iB;
                } else {
                    assert (this.child2[Bparent] == iA);
                    this.child2[Bparent] = iB;
                }
            } else {
                this.root = iB;
            }
            if (this.height[D] > this.height[E]) {
                this.child2[B] = iD;
                this.child1[A] = iE;
                this.parent[E] = iA;
                this.memberAabb[A].combine(this.memberAabb[C], this.memberAabb[E]);
                this.memberAabb[B].combine(this.memberAabb[A], this.memberAabb[D]);
                this.height[A] = 1 + MathUtils.max(this.height[C], this.height[E]);
                this.height[B] = 1 + MathUtils.max(this.height[A], this.height[D]);
            } else {
                this.child2[B] = iE;
                this.child1[A] = iD;
                this.parent[D] = iA;
                this.memberAabb[A].combine(this.memberAabb[C], this.memberAabb[D]);
                this.memberAabb[B].combine(this.memberAabb[A], this.memberAabb[E]);
                this.height[A] = 1 + MathUtils.max(this.height[C], this.height[D]);
                this.height[B] = 1 + MathUtils.max(this.height[A], this.height[E]);
            }
            return iB;
        }
        return iA;
    }

    private void validateStructure(int node) {
        if (node == -1) {
            return;
        }
        assert (node != this.root || this.parent[node] == -1);
        int child1 = this.child1[node];
        int child2 = this.child2[node];
        if (child1 == -1) {
            assert (child2 == -1);
            assert (this.height[node] == 0);
            return;
        }
        assert (0 <= child1 && child1 < this.nodeCapacity);
        assert (0 <= child2 && child2 < this.nodeCapacity);
        assert (this.parent[child1] == node);
        assert (this.parent[child2] == node);
        this.validateStructure(child1);
        this.validateStructure(child2);
    }

    private void validateMetrics(int node) {
        if (node == -1) {
            return;
        }
        int child1 = this.child1[node];
        int child2 = this.child2[node];
        if (child1 == -1) {
            assert (child2 == -1);
            assert (this.height[node] == 0);
            return;
        }
        assert (0 <= child1 && child1 < this.nodeCapacity);
        assert (child2 != child1 && 0 <= child2 && child2 < this.nodeCapacity);
        int height1 = this.height[child1];
        int height2 = this.height[child2];
        int height = 1 + MathUtils.max(height1, height2);
        assert (this.height[node] == height);
        AABB aabb = new AABB();
        aabb.combine(this.memberAabb[child1], this.memberAabb[child2]);
        assert (aabb.lowerBound.equals(this.memberAabb[node].lowerBound));
        assert (aabb.upperBound.equals(this.memberAabb[node].upperBound));
        this.validateMetrics(child1);
        this.validateMetrics(child2);
    }

    @Override
    public void drawTree(DebugDraw argDraw) {
        if (this.root == -1) {
            return;
        }
        int height = this.computeHeight();
        this.drawTree(argDraw, this.root, 0, height);
    }

    public void drawTree(DebugDraw argDraw, int node, int spot, int height) {
        AABB a = this.memberAabb[node];
        a.getVertices(this.drawVecs);
        this.color.set(1.0f, (float)(height - spot) * 1.0f / (float)height, (float)(height - spot) * 1.0f / (float)height);
        argDraw.drawPolygon(this.drawVecs, 4, this.color);
        argDraw.getViewportTranform().getWorldToScreen(a.upperBound, this.textVec);
        argDraw.drawString(this.textVec.x, this.textVec.y, node + "-" + (spot + 1) + "/" + height, this.color);
        int c1 = this.child1[node];
        int c2 = this.child2[node];
        if (c1 != -1) {
            this.drawTree(argDraw, c1, spot + 1, height);
        }
        if (c2 != -1) {
            this.drawTree(argDraw, c2, spot + 1, height);
        }
    }
}

