/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.collision.shapes;

import de.pirckheimer_gymnasium.jbox2d.collision.AABB;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastInput;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastOutput;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.MassData;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ShapeType;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;

public class CircleShape
extends Shape {
    public final Vec2 p = new Vec2();

    public CircleShape() {
        super(ShapeType.CIRCLE);
        this.radius = 0.0f;
    }

    @Override
    public final Shape clone() {
        CircleShape shape = new CircleShape();
        shape.p.x = this.p.x;
        shape.p.y = this.p.y;
        shape.radius = this.radius;
        return shape;
    }

    @Override
    public final int getChildCount() {
        return 1;
    }

    public final int getSupport(Vec2 d) {
        return 0;
    }

    public final Vec2 getSupportVertex(Vec2 d) {
        return this.p;
    }

    public final int getVertexCount() {
        return 1;
    }

    public final Vec2 getVertex(int index) {
        assert (index == 0);
        return this.p;
    }

    @Override
    public final boolean testPoint(Transform transform, Vec2 p) {
        Rot q = transform.q;
        Vec2 tp = transform.p;
        float centerx = -(q.c * this.p.x - q.s * this.p.y + tp.x - p.x);
        float centery = -(q.s * this.p.x + q.c * this.p.y + tp.y - p.y);
        return centerx * centerx + centery * centery <= this.radius * this.radius;
    }

    @Override
    public float computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        Rot xfq = xf.q;
        float centerx = xfq.c * this.p.x - xfq.s * this.p.y + xf.p.x;
        float centery = xfq.s * this.p.x + xfq.c * this.p.y + xf.p.y;
        float dx = p.x - centerx;
        float dy = p.y - centery;
        float d1 = MathUtils.sqrt(dx * dx + dy * dy);
        normalOut.x = dx * 1.0f / d1;
        normalOut.y = dy * 1.0f / d1;
        return d1 - this.radius;
    }

    @Override
    public final boolean raycast(RayCastOutput output, RayCastInput input, Transform transform, int childIndex) {
        Vec2 inputP1 = input.p1;
        Vec2 inputP2 = input.p2;
        Rot tq = transform.q;
        Vec2 tp = transform.p;
        float positionX = tq.c * this.p.x - tq.s * this.p.y + tp.x;
        float sx = inputP1.x - positionX;
        float rx = inputP2.x - inputP1.x;
        float positionY = tq.s * this.p.x + tq.c * this.p.y + tp.y;
        float sy = inputP1.y - positionY;
        float ry = inputP2.y - inputP1.y;
        float c = sx * rx + sy * ry;
        float rr = rx * rx + ry * ry;
        float b = sx * sx + sy * sy - this.radius * this.radius;
        float sigma = c * c - rr * b;
        if (sigma < 0.0f || rr < 1.1920929E-7f) {
            return false;
        }
        float a = -(c + MathUtils.sqrt(sigma));
        if (0.0f <= a && a <= input.maxFraction * rr) {
            output.fraction = a /= rr;
            output.normal.x = rx * a + sx;
            output.normal.y = ry * a + sy;
            output.normal.normalize();
            return true;
        }
        return false;
    }

    @Override
    public final void computeAABB(AABB aabb, Transform transform, int childIndex) {
        Rot tq = transform.q;
        Vec2 tp = transform.p;
        float px = tq.c * this.p.x - tq.s * this.p.y + tp.x;
        float py = tq.s * this.p.x + tq.c * this.p.y + tp.y;
        aabb.lowerBound.x = px - this.radius;
        aabb.lowerBound.y = py - this.radius;
        aabb.upperBound.x = px + this.radius;
        aabb.upperBound.y = py + this.radius;
    }

    @Override
    public final void computeMass(MassData massData, float density) {
        massData.mass = density * (float)Math.PI * this.radius * this.radius;
        massData.center.x = this.p.x;
        massData.center.y = this.p.y;
        massData.I = massData.mass * (0.5f * this.radius * this.radius + (this.p.x * this.p.x + this.p.y * this.p.y));
    }
}

