/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.collision.shapes;

import de.pirckheimer_gymnasium.jbox2d.collision.AABB;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastInput;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastOutput;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.MassData;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ShapeType;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;

public class EdgeShape
extends Shape {
    public final Vec2 vertex1 = new Vec2();
    public final Vec2 vertex2 = new Vec2();
    public final Vec2 vertex0 = new Vec2();
    public final Vec2 vertex3 = new Vec2();
    public boolean hasVertex0 = false;
    public boolean hasVertex3 = false;
    private final Vec2 normal = new Vec2();

    public EdgeShape() {
        super(ShapeType.EDGE);
        this.radius = Settings.polygonRadius;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    public void set(Vec2 v1, Vec2 v2) {
        this.vertex1.set(v1);
        this.vertex2.set(v2);
        this.hasVertex3 = false;
        this.hasVertex0 = false;
    }

    @Override
    public boolean testPoint(Transform xf, Vec2 p) {
        return false;
    }

    @Override
    public float computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        float d1;
        float xfqc = xf.q.c;
        float xfqs = xf.q.s;
        float xfpx = xf.p.x;
        float v1x = xfqc * this.vertex1.x - xfqs * this.vertex1.y + xfpx;
        float dx = p.x - v1x;
        float v2x = xfqc * this.vertex2.x - xfqs * this.vertex2.y + xfpx;
        float sx = v2x - v1x;
        float xfpy = xf.p.y;
        float v1y = xfqs * this.vertex1.x + xfqc * this.vertex1.y + xfpy;
        float dy = p.y - v1y;
        float v2y = xfqs * this.vertex2.x + xfqc * this.vertex2.y + xfpy;
        float sy = v2y - v1y;
        float ds = dx * sx + dy * sy;
        if (ds > 0.0f) {
            float s2 = sx * sx + sy * sy;
            if (ds > s2) {
                dx = p.x - v2x;
                dy = p.y - v2y;
            } else {
                dx -= ds / s2 * sx;
                dy -= ds / s2 * sy;
            }
        }
        if ((d1 = MathUtils.sqrt(dx * dx + dy * dy)) > 0.0f) {
            normalOut.x = 1.0f / d1 * dx;
            normalOut.y = 1.0f / d1 * dy;
        } else {
            normalOut.x = 0.0f;
            normalOut.y = 0.0f;
        }
        return d1;
    }

    @Override
    public boolean raycast(RayCastOutput output, RayCastInput input, Transform xf, int childIndex) {
        Vec2 v1 = this.vertex1;
        Vec2 v2 = this.vertex2;
        Rot xfq = xf.q;
        Vec2 xfp = xf.p;
        float tempx = input.p1.x - xfp.x;
        float tempy = input.p1.y - xfp.y;
        float p1x = xfq.c * tempx + xfq.s * tempy;
        float p1y = -xfq.s * tempx + xfq.c * tempy;
        tempx = input.p2.x - xfp.x;
        tempy = input.p2.y - xfp.y;
        float p2x = xfq.c * tempx + xfq.s * tempy;
        float p2y = -xfq.s * tempx + xfq.c * tempy;
        float dx = p2x - p1x;
        float dy = p2y - p1y;
        this.normal.x = v2.y - v1.y;
        this.normal.y = v1.x - v2.x;
        this.normal.normalize();
        float normalx = this.normal.x;
        float normaly = this.normal.y;
        tempx = v1.x - p1x;
        tempy = v1.y - p1y;
        float numerator = normalx * tempx + normaly * tempy;
        float denominator = normalx * dx + normaly * dy;
        if (denominator == 0.0f) {
            return false;
        }
        float t = numerator / denominator;
        if (t < 0.0f || 1.0f < t) {
            return false;
        }
        float qx = p1x + t * dx;
        float qy = p1y + t * dy;
        float rx = v2.x - v1.x;
        float ry = v2.y - v1.y;
        float rr = rx * rx + ry * ry;
        if (rr == 0.0f) {
            return false;
        }
        tempx = qx - v1.x;
        tempy = qy - v1.y;
        float s = (tempx * rx + tempy * ry) / rr;
        if (s < 0.0f || 1.0f < s) {
            return false;
        }
        output.fraction = t;
        if (numerator > 0.0f) {
            output.normal.x = -xfq.c * this.normal.x + xfq.s * this.normal.y;
            output.normal.y = -xfq.s * this.normal.x - xfq.c * this.normal.y;
        } else {
            output.normal.x = xfq.c * this.normal.x - xfq.s * this.normal.y;
            output.normal.y = xfq.s * this.normal.x + xfq.c * this.normal.y;
        }
        return true;
    }

    @Override
    public void computeAABB(AABB aabb, Transform xf, int childIndex) {
        Vec2 lowerBound = aabb.lowerBound;
        Vec2 upperBound = aabb.upperBound;
        Rot xfq = xf.q;
        float v1x = xfq.c * this.vertex1.x - xfq.s * this.vertex1.y + xf.p.x;
        float v1y = xfq.s * this.vertex1.x + xfq.c * this.vertex1.y + xf.p.y;
        float v2x = xfq.c * this.vertex2.x - xfq.s * this.vertex2.y + xf.p.x;
        float v2y = xfq.s * this.vertex2.x + xfq.c * this.vertex2.y + xf.p.y;
        lowerBound.x = Math.min(v1x, v2x);
        lowerBound.y = Math.min(v1y, v2y);
        upperBound.x = Math.max(v1x, v2x);
        upperBound.y = Math.max(v1y, v2y);
        lowerBound.x -= this.radius;
        lowerBound.y -= this.radius;
        upperBound.x += this.radius;
        upperBound.y += this.radius;
    }

    @Override
    public void computeMass(MassData massData, float density) {
        massData.mass = 0.0f;
        massData.center.set(this.vertex1).addLocal(this.vertex2).mulLocal(0.5f);
        massData.I = 0.0f;
    }

    @Override
    public Shape clone() {
        EdgeShape edge = new EdgeShape();
        edge.radius = this.radius;
        edge.hasVertex0 = this.hasVertex0;
        edge.hasVertex3 = this.hasVertex3;
        edge.vertex0.set(this.vertex0);
        edge.vertex1.set(this.vertex1);
        edge.vertex2.set(this.vertex2);
        edge.vertex3.set(this.vertex3);
        return edge;
    }
}

