/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.collision.shapes;

import de.pirckheimer_gymnasium.jbox2d.collision.AABB;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastInput;
import de.pirckheimer_gymnasium.jbox2d.collision.RayCastOutput;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.MassData;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ShapeType;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.pooling.arrays.IntArray;
import de.pirckheimer_gymnasium.jbox2d.pooling.arrays.Vec2Array;

public class PolygonShape
extends Shape {
    private static final boolean debug = false;
    public final Vec2 centroid = new Vec2();
    public final Vec2[] vertices;
    public final Vec2[] normals;
    public int count = 0;
    private final Vec2 pool1 = new Vec2();
    private final Vec2 pool2 = new Vec2();
    private final Vec2 pool3 = new Vec2();
    private final Vec2 pool4 = new Vec2();
    private Transform poolt1 = new Transform();

    public PolygonShape() {
        super(ShapeType.POLYGON);
        int i;
        this.vertices = new Vec2[Settings.maxPolygonVertices];
        for (i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = new Vec2();
        }
        this.normals = new Vec2[Settings.maxPolygonVertices];
        for (i = 0; i < this.normals.length; ++i) {
            this.normals[i] = new Vec2();
        }
        this.setRadius(Settings.polygonRadius);
        this.centroid.setZero();
    }

    @Override
    public final Shape clone() {
        PolygonShape shape = new PolygonShape();
        shape.centroid.set(this.centroid);
        for (int i = 0; i < shape.normals.length; ++i) {
            shape.normals[i].set(this.normals[i]);
            shape.vertices[i].set(this.vertices[i]);
        }
        shape.setRadius(this.getRadius());
        shape.count = this.count;
        return shape;
    }

    public final void set(Vec2[] vertices, int count) {
        this.set(vertices, count, null, null);
    }

    public final void set(Vec2[] verts, int num, Vec2Array vecPool, IntArray intPool) {
        int ie;
        assert (3 <= num && num <= Settings.maxPolygonVertices);
        int n = MathUtils.min(num, Settings.maxPolygonVertices);
        Vec2[] ps = vecPool != null ? vecPool.get(Settings.maxPolygonVertices) : new Vec2[Settings.maxPolygonVertices];
        int tempCount = 0;
        for (int i = 0; i < n; ++i) {
            Vec2 v = verts[i];
            boolean unique = true;
            for (int j = 0; j < tempCount; ++j) {
                if (!(MathUtils.distanceSquared(v, ps[j]) < 0.5f * Settings.linearSlop)) continue;
                unique = false;
                break;
            }
            if (!unique) continue;
            ps[tempCount++] = v;
        }
        n = tempCount;
        if (n < 3) {
            assert (false);
            this.setAsBox(1.0f, 1.0f);
            return;
        }
        int i0 = 0;
        float x0 = ps[0].x;
        for (int i = 1; i < n; ++i) {
            float x = ps[i].x;
            if (!(x > x0) && (x != x0 || !(ps[i].y < ps[i0].y))) continue;
            i0 = i;
            x0 = x;
        }
        int[] hull = intPool != null ? intPool.get(Settings.maxPolygonVertices) : new int[Settings.maxPolygonVertices];
        int m = 0;
        int ih = i0;
        do {
            hull[m] = ih;
            ie = 0;
            for (int j = 1; j < n; ++j) {
                Vec2 v;
                if (ie == ih) {
                    ie = j;
                    continue;
                }
                Vec2 r = this.pool1.set(ps[ie]).subLocal(ps[hull[m]]);
                float c = Vec2.cross(r, v = this.pool2.set(ps[j]).subLocal(ps[hull[m]]));
                if (c < 0.0f) {
                    ie = j;
                }
                if (c != 0.0f || !(v.lengthSquared() > r.lengthSquared())) continue;
                ie = j;
            }
            ++m;
            ih = ie;
        } while (ie != i0);
        this.count = m;
        for (int i = 0; i < this.count; ++i) {
            if (this.vertices[i] == null) {
                this.vertices[i] = new Vec2();
            }
            this.vertices[i].set(ps[hull[i]]);
        }
        Vec2 edge = this.pool1;
        for (int i = 0; i < this.count; ++i) {
            int i1 = i;
            int i2 = i + 1 < this.count ? i + 1 : 0;
            edge.set(this.vertices[i2]).subLocal(this.vertices[i1]);
            assert (edge.lengthSquared() > 1.4210855E-14f);
            Vec2.crossToOutUnsafe(edge, 1.0f, this.normals[i]);
            this.normals[i].normalize();
        }
        this.computeCentroidToOut(this.vertices, this.count, this.centroid);
    }

    public final void setAsBox(float hx, float hy) {
        this.count = 4;
        this.vertices[0].set(-hx, -hy);
        this.vertices[1].set(hx, -hy);
        this.vertices[2].set(hx, hy);
        this.vertices[3].set(-hx, hy);
        this.normals[0].set(0.0f, -1.0f);
        this.normals[1].set(1.0f, 0.0f);
        this.normals[2].set(0.0f, 1.0f);
        this.normals[3].set(-1.0f, 0.0f);
        this.centroid.setZero();
    }

    public final void setAsBox(float hx, float hy, Vec2 center, float angle) {
        this.count = 4;
        this.vertices[0].set(-hx, -hy);
        this.vertices[1].set(hx, -hy);
        this.vertices[2].set(hx, hy);
        this.vertices[3].set(-hx, hy);
        this.normals[0].set(0.0f, -1.0f);
        this.normals[1].set(1.0f, 0.0f);
        this.normals[2].set(0.0f, 1.0f);
        this.normals[3].set(-1.0f, 0.0f);
        this.centroid.set(center);
        Transform xf = this.poolt1;
        xf.p.set(center);
        xf.q.set(angle);
        for (int i = 0; i < this.count; ++i) {
            Transform.mulToOut(xf, this.vertices[i], this.vertices[i]);
            Rot.mulToOut(xf.q, this.normals[i], this.normals[i]);
        }
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public final boolean testPoint(Transform xf, Vec2 p) {
        Rot xfq = xf.q;
        float tempx = p.x - xf.p.x;
        float tempy = p.y - xf.p.y;
        float pLocalx = xfq.c * tempx + xfq.s * tempy;
        float pLocaly = -xfq.s * tempx + xfq.c * tempy;
        for (int i = 0; i < this.count; ++i) {
            Vec2 vertex = this.vertices[i];
            Vec2 normal = this.normals[i];
            tempx = pLocalx - vertex.x;
            tempy = pLocaly - vertex.y;
            float dot = normal.x * tempx + normal.y * tempy;
            if (!(dot > 0.0f)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void computeAABB(AABB aabb, Transform xf, int childIndex) {
        Vec2 lower = aabb.lowerBound;
        Vec2 upper = aabb.upperBound;
        Vec2 v1 = this.vertices[0];
        float xfqc = xf.q.c;
        float xfqs = xf.q.s;
        float xfpx = xf.p.x;
        float xfpy = xf.p.y;
        lower.x = xfqc * v1.x - xfqs * v1.y + xfpx;
        lower.y = xfqs * v1.x + xfqc * v1.y + xfpy;
        upper.x = lower.x;
        upper.y = lower.y;
        for (int i = 1; i < this.count; ++i) {
            Vec2 v2 = this.vertices[i];
            float vx = xfqc * v2.x - xfqs * v2.y + xfpx;
            float vy = xfqs * v2.x + xfqc * v2.y + xfpy;
            lower.x = Math.min(lower.x, vx);
            lower.y = Math.min(lower.y, vy);
            upper.x = Math.max(upper.x, vx);
            upper.y = Math.max(upper.y, vy);
        }
        lower.x -= this.radius;
        lower.y -= this.radius;
        upper.x += this.radius;
        upper.y += this.radius;
    }

    public final int getVertexCount() {
        return this.count;
    }

    public final Vec2 getVertex(int index) {
        assert (0 <= index && index < this.count);
        return this.vertices[index];
    }

    @Override
    public float computeDistanceToOut(Transform xf, Vec2 p, int childIndex, Vec2 normalOut) {
        float distance;
        float xfqc = xf.q.c;
        float xfqs = xf.q.s;
        float tx = p.x - xf.p.x;
        float ty = p.y - xf.p.y;
        float pLocalX = xfqc * tx + xfqs * ty;
        float pLocalY = -xfqs * tx + xfqc * ty;
        float maxDistance = -3.4028235E38f;
        float normalForMaxDistanceX = pLocalX;
        float normalForMaxDistanceY = pLocalY;
        for (int i = 0; i < this.count; ++i) {
            Vec2 vertex = this.vertices[i];
            Vec2 normal = this.normals[i];
            tx = pLocalX - vertex.x;
            ty = pLocalY - vertex.y;
            float dot = normal.x * tx + normal.y * ty;
            if (!(dot > maxDistance)) continue;
            maxDistance = dot;
            normalForMaxDistanceX = normal.x;
            normalForMaxDistanceY = normal.y;
        }
        if (maxDistance > 0.0f) {
            float minDistanceX = normalForMaxDistanceX;
            float minDistanceY = normalForMaxDistanceY;
            float minDistance2 = maxDistance * maxDistance;
            for (int i = 0; i < this.count; ++i) {
                Vec2 vertex = this.vertices[i];
                float distanceVecX = pLocalX - vertex.x;
                float distanceVecY = pLocalY - vertex.y;
                float distance2 = distanceVecX * distanceVecX + distanceVecY * distanceVecY;
                if (!(minDistance2 > distance2)) continue;
                minDistanceX = distanceVecX;
                minDistanceY = distanceVecY;
                minDistance2 = distance2;
            }
            distance = MathUtils.sqrt(minDistance2);
            normalOut.x = xfqc * minDistanceX - xfqs * minDistanceY;
            normalOut.y = xfqs * minDistanceX + xfqc * minDistanceY;
            normalOut.normalize();
        } else {
            distance = maxDistance;
            normalOut.x = xfqc * normalForMaxDistanceX - xfqs * normalForMaxDistanceY;
            normalOut.y = xfqs * normalForMaxDistanceX + xfqc * normalForMaxDistanceY;
        }
        return distance;
    }

    @Override
    public final boolean raycast(RayCastOutput output, RayCastInput input, Transform xf, int childIndex) {
        float xfqc = xf.q.c;
        float xfqs = xf.q.s;
        Vec2 xfp = xf.p;
        float tempx = input.p1.x - xfp.x;
        float tempy = input.p1.y - xfp.y;
        float p1x = xfqc * tempx + xfqs * tempy;
        float p1y = -xfqs * tempx + xfqc * tempy;
        tempx = input.p2.x - xfp.x;
        tempy = input.p2.y - xfp.y;
        float p2x = xfqc * tempx + xfqs * tempy;
        float p2y = -xfqs * tempx + xfqc * tempy;
        float dx = p2x - p1x;
        float dy = p2y - p1y;
        float lower = 0.0f;
        float upper = input.maxFraction;
        int index = -1;
        for (int i = 0; i < this.count; ++i) {
            Vec2 normal = this.normals[i];
            Vec2 vertex = this.vertices[i];
            float tempxn = vertex.x - p1x;
            float tempyn = vertex.y - p1y;
            float numerator = normal.x * tempxn + normal.y * tempyn;
            float denominator = normal.x * dx + normal.y * dy;
            if (denominator == 0.0f) {
                if (numerator < 0.0f) {
                    return false;
                }
            } else if (denominator < 0.0f && numerator < lower * denominator) {
                lower = numerator / denominator;
                index = i;
            } else if (denominator > 0.0f && numerator < upper * denominator) {
                upper = numerator / denominator;
            }
            if (!(upper < lower)) continue;
            return false;
        }
        assert (0.0f <= lower && lower <= input.maxFraction);
        if (index >= 0) {
            output.fraction = lower;
            Vec2 normal = this.normals[index];
            Vec2 out = output.normal;
            out.x = xfqc * normal.x - xfqs * normal.y;
            out.y = xfqs * normal.x + xfqc * normal.y;
            return true;
        }
        return false;
    }

    public final void computeCentroidToOut(Vec2[] vs, int count, Vec2 out) {
        assert (count >= 3);
        out.set(0.0f, 0.0f);
        float area = 0.0f;
        Vec2 pRef = this.pool1;
        pRef.setZero();
        Vec2 e1 = this.pool2;
        Vec2 e2 = this.pool3;
        float inv3 = 0.33333334f;
        for (int i = 0; i < count; ++i) {
            Vec2 p1 = pRef;
            Vec2 p2 = vs[i];
            Vec2 p3 = i + 1 < count ? vs[i + 1] : vs[0];
            e1.set(p2).subLocal(p1);
            e2.set(p3).subLocal(p1);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            e1.set(p1).addLocal(p2).addLocal(p3).mulLocal(triangleArea * 0.33333334f);
            out.addLocal(e1);
        }
        assert (area > 1.1920929E-7f);
        out.mulLocal(1.0f / area);
    }

    @Override
    public void computeMass(MassData massData, float density) {
        assert (this.count >= 3);
        Vec2 center = this.pool1;
        center.setZero();
        float area = 0.0f;
        float I = 0.0f;
        Vec2 s = this.pool2;
        s.setZero();
        for (int i = 0; i < this.count; ++i) {
            s.addLocal(this.vertices[i]);
        }
        s.mulLocal(1.0f / (float)this.count);
        float inv3 = 0.33333334f;
        Vec2 e1 = this.pool3;
        Vec2 e2 = this.pool4;
        for (int i = 0; i < this.count; ++i) {
            e1.set(this.vertices[i]).subLocal(s);
            e2.set(s).negateLocal().addLocal(i + 1 < this.count ? this.vertices[i + 1] : this.vertices[0]);
            float D = Vec2.cross(e1, e2);
            float triangleArea = 0.5f * D;
            area += triangleArea;
            center.x += triangleArea * 0.33333334f * (e1.x + e2.x);
            center.y += triangleArea * 0.33333334f * (e1.y + e2.y);
            float ex1 = e1.x;
            float ey1 = e1.y;
            float ex2 = e2.x;
            float ey2 = e2.y;
            float intX2 = ex1 * ex1 + ex2 * ex1 + ex2 * ex2;
            float intY2 = ey1 * ey1 + ey2 * ey1 + ey2 * ey2;
            I += 0.083333336f * D * (intX2 + intY2);
        }
        massData.mass = density * area;
        assert (area > 1.1920929E-7f);
        center.mulLocal(1.0f / area);
        massData.center.set(center).addLocal(s);
        massData.I = I * density;
        massData.I += massData.mass * Vec2.dot(massData.center, massData.center);
    }

    public boolean validate() {
        for (int i = 0; i < this.count; ++i) {
            int i1 = i;
            int i2 = i < this.count - 1 ? i1 + 1 : 0;
            Vec2 p = this.vertices[i1];
            Vec2 e = this.pool1.set(this.vertices[i2]).subLocal(p);
            for (int j = 0; j < this.count; ++j) {
                Vec2 v;
                float c;
                if (j == i1 || j == i2 || !((c = Vec2.cross(e, v = this.pool2.set(this.vertices[j]).subLocal(p))) < 0.0f)) continue;
                return false;
            }
        }
        return true;
    }

    public Vec2[] getVertices() {
        return this.vertices;
    }

    public Vec2[] getNormals() {
        return this.normals;
    }

    public Vec2 centroid(Transform xf) {
        return Transform.mul(xf, this.centroid);
    }

    public Vec2 centroidToOut(Transform xf, Vec2 out) {
        Transform.mulToOutUnsafe(xf, this.centroid, out);
        return out;
    }
}

