/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics;

import de.pirckheimer_gymnasium.jbox2d.collision.broadphase.BroadPhase;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.MassData;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Sweep;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.BodyDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.BodyType;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Fixture;
import de.pirckheimer_gymnasium.jbox2d.dynamics.FixtureDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.World;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Contact;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactEdge;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.JointEdge;

public class Body {
    public static final int islandFlag = 1;
    public static final int awakeFlag = 2;
    public static final int autoSleepFlag = 4;
    public static final int bulletFlag = 8;
    public static final int fixedRotationFlag = 16;
    public static final int activeFlag = 32;
    public static final int toiFlag = 64;
    public BodyType type;
    public int flags;
    public int islandIndex;
    public final Transform xf = new Transform();
    public final Transform xf0 = new Transform();
    public final Sweep sweep = new Sweep();
    public final Vec2 linearVelocity = new Vec2();
    public float angularVelocity;
    public final Vec2 force = new Vec2();
    public float torque;
    public World world;
    public Body prev;
    public Body next;
    public Fixture fixtureList;
    public int fixtureCount;
    public JointEdge jointList;
    public ContactEdge contactList;
    public float mass;
    public float invMass;
    public float I;
    public float invI;
    public float linearDamping;
    public float angularDamping;
    public float gravityScale;
    public float sleepTime;
    public Object userData;
    private final FixtureDef fixDef = new FixtureDef();
    private final MassData pmd = new MassData();
    private final Transform pxf = new Transform();

    public Body(BodyDef bd, World world) {
        assert (bd.position.isValid());
        assert (bd.linearVelocity.isValid());
        assert (bd.gravityScale >= 0.0f);
        assert (bd.angularDamping >= 0.0f);
        assert (bd.linearDamping >= 0.0f);
        this.flags = 0;
        if (bd.bullet) {
            this.flags |= 8;
        }
        if (bd.fixedRotation) {
            this.flags |= 0x10;
        }
        if (bd.allowSleep) {
            this.flags |= 4;
        }
        if (bd.awake) {
            this.flags |= 2;
        }
        if (bd.active) {
            this.flags |= 0x20;
        }
        this.world = world;
        this.xf.p.set(bd.position);
        this.xf.q.set(bd.angle);
        this.sweep.localCenter.setZero();
        this.sweep.c0.set(this.xf.p);
        this.sweep.c.set(this.xf.p);
        this.sweep.a0 = bd.angle;
        this.sweep.a = bd.angle;
        this.sweep.alpha0 = 0.0f;
        this.jointList = null;
        this.contactList = null;
        this.prev = null;
        this.next = null;
        this.linearVelocity.set(bd.linearVelocity);
        this.angularVelocity = bd.angularVelocity;
        this.linearDamping = bd.linearDamping;
        this.angularDamping = bd.angularDamping;
        this.gravityScale = bd.gravityScale;
        this.force.setZero();
        this.torque = 0.0f;
        this.sleepTime = 0.0f;
        this.type = bd.type;
        if (this.type == BodyType.DYNAMIC) {
            this.mass = 1.0f;
            this.invMass = 1.0f;
        } else {
            this.mass = 0.0f;
            this.invMass = 0.0f;
        }
        this.I = 0.0f;
        this.invI = 0.0f;
        this.userData = bd.userData;
        this.fixtureList = null;
        this.fixtureCount = 0;
    }

    public final Fixture createFixture(FixtureDef def) {
        assert (!this.world.isLocked());
        if (this.world.isLocked()) {
            return null;
        }
        Fixture fixture = new Fixture();
        fixture.create(this, def);
        if ((this.flags & 0x20) == 32) {
            BroadPhase broadPhase = this.world.contactManager.broadPhase;
            fixture.createProxies(broadPhase, this.xf);
        }
        fixture.next = this.fixtureList;
        this.fixtureList = fixture;
        ++this.fixtureCount;
        fixture.body = this;
        if (fixture.density > 0.0f) {
            this.resetMassData();
        }
        this.world.flags |= 1;
        return fixture;
    }

    public final Fixture createFixture(Shape shape, float density) {
        this.fixDef.shape = shape;
        this.fixDef.density = density;
        return this.createFixture(this.fixDef);
    }

    public final void destroyFixture(Fixture fixture) {
        assert (!this.world.isLocked());
        if (this.world.isLocked()) {
            return;
        }
        assert (fixture.body == this);
        assert (this.fixtureCount > 0);
        Fixture node = this.fixtureList;
        Fixture last = null;
        boolean found = false;
        while (node != null) {
            if (node == fixture) {
                node = fixture.next;
                found = true;
                break;
            }
            last = node;
            node = node.next;
        }
        assert (found);
        if (last == null) {
            this.fixtureList = fixture.next;
        } else {
            last.next = fixture.next;
        }
        ContactEdge edge = this.contactList;
        while (edge != null) {
            Contact c = edge.contact;
            edge = edge.next;
            Fixture fixtureA = c.getFixtureA();
            Fixture fixtureB = c.getFixtureB();
            if (fixture != fixtureA && fixture != fixtureB) continue;
            this.world.contactManager.destroy(c);
        }
        if ((this.flags & 0x20) == 32) {
            BroadPhase broadPhase = this.world.contactManager.broadPhase;
            fixture.destroyProxies(broadPhase);
        }
        fixture.destroy();
        fixture.body = null;
        fixture.next = null;
        fixture = null;
        --this.fixtureCount;
        this.resetMassData();
    }

    public final void setTransform(Vec2 position, float angle) {
        assert (!this.world.isLocked());
        if (this.world.isLocked()) {
            return;
        }
        this.xf.q.set(angle);
        this.xf.p.set(position);
        Transform.mulToOutUnsafe(this.xf, this.sweep.localCenter, this.sweep.c);
        this.sweep.a = angle;
        this.sweep.c0.set(this.sweep.c);
        this.sweep.a0 = this.sweep.a;
        BroadPhase broadPhase = this.world.contactManager.broadPhase;
        Fixture f = this.fixtureList;
        while (f != null) {
            f.synchronize(broadPhase, this.xf, this.xf);
            f = f.next;
        }
    }

    public final Transform getTransform() {
        return this.xf;
    }

    public final Vec2 getPosition() {
        return this.xf.p;
    }

    public final float getAngle() {
        return this.sweep.a;
    }

    public final Vec2 getWorldCenter() {
        return this.sweep.c;
    }

    public final Vec2 getLocalCenter() {
        return this.sweep.localCenter;
    }

    public final void setLinearVelocity(Vec2 v) {
        if (this.type == BodyType.STATIC) {
            return;
        }
        if (Vec2.dot(v, v) > 0.0f) {
            this.setAwake(true);
        }
        this.linearVelocity.set(v);
    }

    public final Vec2 getLinearVelocity() {
        return this.linearVelocity;
    }

    public final void setAngularVelocity(float w) {
        if (this.type == BodyType.STATIC) {
            return;
        }
        if (w * w > 0.0f) {
            this.setAwake(true);
        }
        this.angularVelocity = w;
    }

    public final float getAngularVelocity() {
        return this.angularVelocity;
    }

    public float getGravityScale() {
        return this.gravityScale;
    }

    public void setGravityScale(float gravityScale) {
        this.gravityScale = gravityScale;
    }

    public final void applyForce(Vec2 force, Vec2 point) {
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.force.x += force.x;
        this.force.y += force.y;
        this.torque += (point.x - this.sweep.c.x) * force.y - (point.y - this.sweep.c.y) * force.x;
    }

    public final void applyForceToCenter(Vec2 force) {
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.force.x += force.x;
        this.force.y += force.y;
    }

    public final void applyTorque(float torque) {
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.torque += torque;
    }

    public final void applyLinearImpulse(Vec2 impulse, Vec2 point, boolean wake) {
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            if (wake) {
                this.setAwake(true);
            } else {
                return;
            }
        }
        this.linearVelocity.x += impulse.x * this.invMass;
        this.linearVelocity.y += impulse.y * this.invMass;
        this.angularVelocity += this.invI * ((point.x - this.sweep.c.x) * impulse.y - (point.y - this.sweep.c.y) * impulse.x);
    }

    public void applyAngularImpulse(float impulse) {
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        if (!this.isAwake()) {
            this.setAwake(true);
        }
        this.angularVelocity += this.invI * impulse;
    }

    public final float getMass() {
        return this.mass;
    }

    public final float getInertia() {
        return this.I + this.mass * (this.sweep.localCenter.x * this.sweep.localCenter.x + this.sweep.localCenter.y * this.sweep.localCenter.y);
    }

    public final void getMassData(MassData data) {
        data.mass = this.mass;
        data.I = this.I + this.mass * (this.sweep.localCenter.x * this.sweep.localCenter.x + this.sweep.localCenter.y * this.sweep.localCenter.y);
        data.center.x = this.sweep.localCenter.x;
        data.center.y = this.sweep.localCenter.y;
    }

    public final void setMassData(MassData massData) {
        assert (!this.world.isLocked());
        if (this.world.isLocked()) {
            return;
        }
        if (this.type != BodyType.DYNAMIC) {
            return;
        }
        this.invMass = 0.0f;
        this.I = 0.0f;
        this.invI = 0.0f;
        this.mass = massData.mass;
        if (this.mass <= 0.0f) {
            this.mass = 1.0f;
        }
        this.invMass = 1.0f / this.mass;
        if (massData.I > 0.0f && (this.flags & 0x10) == 0) {
            this.I = massData.I - this.mass * Vec2.dot(massData.center, massData.center);
            assert (this.I > 0.0f);
            this.invI = 1.0f / this.I;
        }
        Vec2 oldCenter = this.world.getPool().popVec2();
        oldCenter.set(this.sweep.c);
        this.sweep.localCenter.set(massData.center);
        Transform.mulToOutUnsafe(this.xf, this.sweep.localCenter, this.sweep.c0);
        this.sweep.c.set(this.sweep.c0);
        Vec2 temp = this.world.getPool().popVec2();
        temp.set(this.sweep.c).subLocal(oldCenter);
        Vec2.crossToOut(this.angularVelocity, temp, temp);
        this.linearVelocity.addLocal(temp);
        this.world.getPool().pushVec2(2);
    }

    public final void resetMassData() {
        this.mass = 0.0f;
        this.invMass = 0.0f;
        this.I = 0.0f;
        this.invI = 0.0f;
        this.sweep.localCenter.setZero();
        if (this.type == BodyType.STATIC || this.type == BodyType.KINEMATIC) {
            this.sweep.c0.set(this.xf.p);
            this.sweep.c.set(this.xf.p);
            this.sweep.a0 = this.sweep.a;
            return;
        }
        assert (this.type == BodyType.DYNAMIC);
        Vec2 localCenter = this.world.getPool().popVec2();
        localCenter.setZero();
        Vec2 temp = this.world.getPool().popVec2();
        MassData massData = this.pmd;
        Fixture f = this.fixtureList;
        while (f != null) {
            if (f.density != 0.0f) {
                f.getMassData(massData);
                this.mass += massData.mass;
                temp.set(massData.center).mulLocal(massData.mass);
                localCenter.addLocal(temp);
                this.I += massData.I;
            }
            f = f.next;
        }
        if (this.mass > 0.0f) {
            this.invMass = 1.0f / this.mass;
            localCenter.mulLocal(this.invMass);
        } else {
            this.mass = 1.0f;
            this.invMass = 1.0f;
        }
        if (this.I > 0.0f && (this.flags & 0x10) == 0) {
            this.I -= this.mass * Vec2.dot(localCenter, localCenter);
            assert (this.I > 0.0f);
            this.invI = 1.0f / this.I;
        } else {
            this.I = 0.0f;
            this.invI = 0.0f;
        }
        Vec2 oldCenter = this.world.getPool().popVec2();
        oldCenter.set(this.sweep.c);
        this.sweep.localCenter.set(localCenter);
        Transform.mulToOutUnsafe(this.xf, this.sweep.localCenter, this.sweep.c0);
        this.sweep.c.set(this.sweep.c0);
        temp.set(this.sweep.c).subLocal(oldCenter);
        Vec2.crossToOutUnsafe(this.angularVelocity, temp, oldCenter);
        this.linearVelocity.addLocal(oldCenter);
        this.world.getPool().pushVec2(3);
    }

    public final Vec2 getWorldPoint(Vec2 localPoint) {
        Vec2 v = new Vec2();
        this.getWorldPointToOut(localPoint, v);
        return v;
    }

    public final void getWorldPointToOut(Vec2 localPoint, Vec2 out) {
        Transform.mulToOut(this.xf, localPoint, out);
    }

    public final Vec2 getWorldVector(Vec2 localVector) {
        Vec2 out = new Vec2();
        this.getWorldVectorToOut(localVector, out);
        return out;
    }

    public final void getWorldVectorToOut(Vec2 localVector, Vec2 out) {
        Rot.mulToOut(this.xf.q, localVector, out);
    }

    public final void getWorldVectorToOutUnsafe(Vec2 localVector, Vec2 out) {
        Rot.mulToOutUnsafe(this.xf.q, localVector, out);
    }

    public final Vec2 getLocalPoint(Vec2 worldPoint) {
        Vec2 out = new Vec2();
        this.getLocalPointToOut(worldPoint, out);
        return out;
    }

    public final void getLocalPointToOut(Vec2 worldPoint, Vec2 out) {
        Transform.mulTransToOut(this.xf, worldPoint, out);
    }

    public final Vec2 getLocalVector(Vec2 worldVector) {
        Vec2 out = new Vec2();
        this.getLocalVectorToOut(worldVector, out);
        return out;
    }

    public final void getLocalVectorToOut(Vec2 worldVector, Vec2 out) {
        Rot.mulTrans(this.xf.q, worldVector, out);
    }

    public final void getLocalVectorToOutUnsafe(Vec2 worldVector, Vec2 out) {
        Rot.mulTransUnsafe(this.xf.q, worldVector, out);
    }

    public final Vec2 getLinearVelocityFromWorldPoint(Vec2 worldPoint) {
        Vec2 out = new Vec2();
        this.getLinearVelocityFromWorldPointToOut(worldPoint, out);
        return out;
    }

    public final void getLinearVelocityFromWorldPointToOut(Vec2 worldPoint, Vec2 out) {
        float tempX = worldPoint.x - this.sweep.c.x;
        float tempY = worldPoint.y - this.sweep.c.y;
        out.x = -this.angularVelocity * tempY + this.linearVelocity.x;
        out.y = this.angularVelocity * tempX + this.linearVelocity.y;
    }

    public final Vec2 getLinearVelocityFromLocalPoint(Vec2 localPoint) {
        Vec2 out = new Vec2();
        this.getLinearVelocityFromLocalPointToOut(localPoint, out);
        return out;
    }

    public final void getLinearVelocityFromLocalPointToOut(Vec2 localPoint, Vec2 out) {
        this.getWorldPointToOut(localPoint, out);
        this.getLinearVelocityFromWorldPointToOut(out, out);
    }

    public final float getLinearDamping() {
        return this.linearDamping;
    }

    public final void setLinearDamping(float linearDamping) {
        this.linearDamping = linearDamping;
    }

    public final float getAngularDamping() {
        return this.angularDamping;
    }

    public final void setAngularDamping(float angularDamping) {
        this.angularDamping = angularDamping;
    }

    public BodyType getType() {
        return this.type;
    }

    public void setType(BodyType type) {
        assert (!this.world.isLocked());
        if (this.world.isLocked()) {
            return;
        }
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.resetMassData();
        if (this.type == BodyType.STATIC) {
            this.linearVelocity.setZero();
            this.angularVelocity = 0.0f;
            this.sweep.a0 = this.sweep.a;
            this.sweep.c0.set(this.sweep.c);
            this.synchronizeFixtures();
        }
        this.setAwake(true);
        this.force.setZero();
        this.torque = 0.0f;
        ContactEdge ce = this.contactList;
        while (ce != null) {
            ContactEdge ce0 = ce;
            ce = ce.next;
            this.world.contactManager.destroy(ce0.contact);
        }
        this.contactList = null;
        BroadPhase broadPhase = this.world.contactManager.broadPhase;
        Fixture f = this.fixtureList;
        while (f != null) {
            int proxyCount = f.proxyCount;
            for (int i = 0; i < proxyCount; ++i) {
                broadPhase.touchProxy(f.proxies[i].proxyId);
            }
            f = f.next;
        }
    }

    public final boolean isBullet() {
        return (this.flags & 8) == 8;
    }

    public final void setBullet(boolean flag) {
        this.flags = flag ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public void setSleepingAllowed(boolean flag) {
        if (flag) {
            this.flags |= 4;
        } else {
            this.flags &= 0xFFFFFFFB;
            this.setAwake(true);
        }
    }

    public boolean isSleepingAllowed() {
        return (this.flags & 4) == 4;
    }

    public void setAwake(boolean flag) {
        if (flag) {
            if ((this.flags & 2) == 0) {
                this.flags |= 2;
                this.sleepTime = 0.0f;
            }
        } else {
            this.flags &= 0xFFFFFFFD;
            this.sleepTime = 0.0f;
            this.linearVelocity.setZero();
            this.angularVelocity = 0.0f;
            this.force.setZero();
            this.torque = 0.0f;
        }
    }

    public boolean isAwake() {
        return (this.flags & 2) == 2;
    }

    public void setActive(boolean flag) {
        assert (!this.world.isLocked());
        if (flag == this.isActive()) {
            return;
        }
        if (flag) {
            this.flags |= 0x20;
            BroadPhase broadPhase = this.world.contactManager.broadPhase;
            Fixture f = this.fixtureList;
            while (f != null) {
                f.createProxies(broadPhase, this.xf);
                f = f.next;
            }
        } else {
            this.flags &= 0xFFFFFFDF;
            BroadPhase broadPhase = this.world.contactManager.broadPhase;
            Fixture f = this.fixtureList;
            while (f != null) {
                f.destroyProxies(broadPhase);
                f = f.next;
            }
            ContactEdge ce = this.contactList;
            while (ce != null) {
                ContactEdge ce0 = ce;
                ce = ce.next;
                this.world.contactManager.destroy(ce0.contact);
            }
            this.contactList = null;
        }
    }

    public boolean isActive() {
        return (this.flags & 0x20) == 32;
    }

    public void setFixedRotation(boolean flag) {
        this.flags = flag ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
        this.resetMassData();
    }

    public boolean isFixedRotation() {
        return (this.flags & 0x10) == 16;
    }

    public final Fixture getFixtureList() {
        return this.fixtureList;
    }

    public final JointEdge getJointList() {
        return this.jointList;
    }

    public final ContactEdge getContactList() {
        return this.contactList;
    }

    public final Body getNext() {
        return this.next;
    }

    public final Object getUserData() {
        return this.userData;
    }

    public final void setUserData(Object data) {
        this.userData = data;
    }

    public final World getWorld() {
        return this.world;
    }

    protected final void synchronizeFixtures() {
        Transform xf1 = this.pxf;
        xf1.q.s = MathUtils.sin(this.sweep.a0);
        xf1.q.c = MathUtils.cos(this.sweep.a0);
        xf1.p.x = this.sweep.c0.x - xf1.q.c * this.sweep.localCenter.x + xf1.q.s * this.sweep.localCenter.y;
        xf1.p.y = this.sweep.c0.y - xf1.q.s * this.sweep.localCenter.x - xf1.q.c * this.sweep.localCenter.y;
        Fixture f = this.fixtureList;
        while (f != null) {
            f.synchronize(this.world.contactManager.broadPhase, xf1, this.xf);
            f = f.next;
        }
    }

    public final void synchronizeTransform() {
        this.xf.q.s = MathUtils.sin(this.sweep.a);
        this.xf.q.c = MathUtils.cos(this.sweep.a);
        Rot q = this.xf.q;
        Vec2 v = this.sweep.localCenter;
        this.xf.p.x = this.sweep.c.x - q.c * v.x + q.s * v.y;
        this.xf.p.y = this.sweep.c.y - q.s * v.x - q.c * v.y;
    }

    public boolean shouldCollide(Body other) {
        if (this.type != BodyType.DYNAMIC && other.type != BodyType.DYNAMIC) {
            return false;
        }
        JointEdge jn = this.jointList;
        while (jn != null) {
            if (jn.other == other && !jn.joint.getCollideConnected()) {
                return false;
            }
            jn = jn.next;
        }
        return true;
    }

    protected final void advance(float t) {
        this.sweep.advance(t);
        this.sweep.c.set(this.sweep.c0);
        this.sweep.a = this.sweep.a0;
        this.xf.q.set(this.sweep.a);
        Rot.mulToOutUnsafe(this.xf.q, this.sweep.localCenter, this.xf.p);
        this.xf.p.mulLocal(-1.0f).addLocal(this.sweep.c);
    }
}

