/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.contacts;

import de.pirckheimer_gymnasium.jbox2d.collision.Manifold;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ChainShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.EdgeShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.PolygonShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.ShapeType;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Fixture;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Contact;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class ChainAndPolygonContact
extends Contact {
    private final EdgeShape edge = new EdgeShape();

    public ChainAndPolygonContact(IWorldPool argPool) {
        super(argPool);
    }

    @Override
    public void init(Fixture fA, int indexA, Fixture fB, int indexB) {
        super.init(fA, indexA, fB, indexB);
        assert (this.fixtureA.getType() == ShapeType.CHAIN);
        assert (this.fixtureB.getType() == ShapeType.POLYGON);
    }

    @Override
    public void evaluate(Manifold manifold, Transform xfA, Transform xfB) {
        ChainShape chain = (ChainShape)this.fixtureA.getShape();
        chain.getChildEdge(this.edge, this.indexA);
        this.pool.getCollision().collideEdgeAndPolygon(manifold, this.edge, xfA, (PolygonShape)this.fixtureB.getShape(), xfB);
    }
}

