/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.contacts;

import de.pirckheimer_gymnasium.jbox2d.collision.Manifold;
import de.pirckheimer_gymnasium.jbox2d.collision.ManifoldPoint;
import de.pirckheimer_gymnasium.jbox2d.collision.WorldManifold;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.common.Mat22;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Fixture;
import de.pirckheimer_gymnasium.jbox2d.dynamics.TimeStep;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Contact;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactPositionConstraint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactVelocityConstraint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Position;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.PositionSolverManifold;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Velocity;

public class ContactSolver {
    public static final boolean DEBUG_SOLVER = false;
    public static final float errorTol = 0.001f;
    public static final int INITIAL_NUM_CONSTRAINTS = 256;
    public static final float maxConditionNumber = 100.0f;
    public TimeStep step;
    public Position[] positions;
    public Velocity[] velocities;
    public ContactPositionConstraint[] positionConstraints;
    public ContactVelocityConstraint[] velocityConstraints;
    public Contact[] contacts;
    public int count;
    private final Transform xfA = new Transform();
    private final Transform xfB = new Transform();
    private final WorldManifold worldManifold = new WorldManifold();
    private final PositionSolverManifold psolver = new PositionSolverManifold();

    public ContactSolver() {
        this.positionConstraints = new ContactPositionConstraint[256];
        this.velocityConstraints = new ContactVelocityConstraint[256];
        for (int i = 0; i < 256; ++i) {
            this.positionConstraints[i] = new ContactPositionConstraint();
            this.velocityConstraints[i] = new ContactVelocityConstraint();
        }
    }

    public final void init(ContactSolverDef def) {
        int i;
        Object[] old;
        this.step = def.step;
        this.count = def.count;
        if (this.positionConstraints.length < this.count) {
            old = this.positionConstraints;
            this.positionConstraints = new ContactPositionConstraint[MathUtils.max(old.length * 2, this.count)];
            System.arraycopy(old, 0, this.positionConstraints, 0, old.length);
            for (i = old.length; i < this.positionConstraints.length; ++i) {
                this.positionConstraints[i] = new ContactPositionConstraint();
            }
        }
        if (this.velocityConstraints.length < this.count) {
            old = this.velocityConstraints;
            this.velocityConstraints = new ContactVelocityConstraint[MathUtils.max(old.length * 2, this.count)];
            System.arraycopy(old, 0, this.velocityConstraints, 0, old.length);
            for (i = old.length; i < this.velocityConstraints.length; ++i) {
                this.velocityConstraints[i] = new ContactVelocityConstraint();
            }
        }
        this.positions = def.positions;
        this.velocities = def.velocities;
        this.contacts = def.contacts;
        for (int i2 = 0; i2 < this.count; ++i2) {
            Contact contact = this.contacts[i2];
            Fixture fixtureA = contact.fixtureA;
            Fixture fixtureB = contact.fixtureB;
            Shape shapeA = fixtureA.getShape();
            Shape shapeB = fixtureB.getShape();
            float radiusA = shapeA.radius;
            float radiusB = shapeB.radius;
            Body bodyA = fixtureA.getBody();
            Body bodyB = fixtureB.getBody();
            Manifold manifold = contact.getManifold();
            int pointCount = manifold.pointCount;
            assert (pointCount > 0);
            ContactVelocityConstraint vc = this.velocityConstraints[i2];
            vc.friction = contact.friction;
            vc.restitution = contact.restitution;
            vc.tangentSpeed = contact.tangentSpeed;
            vc.indexA = bodyA.islandIndex;
            vc.indexB = bodyB.islandIndex;
            vc.invMassA = bodyA.invMass;
            vc.invMassB = bodyB.invMass;
            vc.invIA = bodyA.invI;
            vc.invIB = bodyB.invI;
            vc.contactIndex = i2;
            vc.pointCount = pointCount;
            vc.K.setZero();
            vc.normalMass.setZero();
            ContactPositionConstraint pc = this.positionConstraints[i2];
            pc.indexA = bodyA.islandIndex;
            pc.indexB = bodyB.islandIndex;
            pc.invMassA = bodyA.invMass;
            pc.invMassB = bodyB.invMass;
            pc.localCenterA.set(bodyA.sweep.localCenter);
            pc.localCenterB.set(bodyB.sweep.localCenter);
            pc.invIA = bodyA.invI;
            pc.invIB = bodyB.invI;
            pc.localNormal.set(manifold.localNormal);
            pc.localPoint.set(manifold.localPoint);
            pc.pointCount = pointCount;
            pc.radiusA = radiusA;
            pc.radiusB = radiusB;
            pc.type = manifold.type;
            for (int j = 0; j < pointCount; ++j) {
                ManifoldPoint cp = manifold.points[j];
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[j];
                if (this.step.warmStarting) {
                    vcp.normalImpulse = this.step.dtRatio * cp.normalImpulse;
                    vcp.tangentImpulse = this.step.dtRatio * cp.tangentImpulse;
                } else {
                    vcp.normalImpulse = 0.0f;
                    vcp.tangentImpulse = 0.0f;
                }
                vcp.rA.setZero();
                vcp.rB.setZero();
                vcp.normalMass = 0.0f;
                vcp.tangentMass = 0.0f;
                vcp.velocityBias = 0.0f;
                pc.localPoints[j].x = cp.localPoint.x;
                pc.localPoints[j].y = cp.localPoint.y;
            }
        }
    }

    public void warmStart() {
        for (int i = 0; i < this.count; ++i) {
            ContactVelocityConstraint vc = this.velocityConstraints[i];
            int indexA = vc.indexA;
            int indexB = vc.indexB;
            float mA = vc.invMassA;
            float iA = vc.invIA;
            float mB = vc.invMassB;
            float iB = vc.invIB;
            int pointCount = vc.pointCount;
            Vec2 vA = this.velocities[indexA].v;
            float wA = this.velocities[indexA].w;
            Vec2 vB = this.velocities[indexB].v;
            float wB = this.velocities[indexB].w;
            Vec2 normal = vc.normal;
            float tangentx = 1.0f * normal.y;
            float tangenty = -1.0f * normal.x;
            for (int j = 0; j < pointCount; ++j) {
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[j];
                float Px = tangentx * vcp.tangentImpulse + normal.x * vcp.normalImpulse;
                float Py = tangenty * vcp.tangentImpulse + normal.y * vcp.normalImpulse;
                wA -= iA * (vcp.rA.x * Py - vcp.rA.y * Px);
                vA.x -= Px * mA;
                vA.y -= Py * mA;
                wB += iB * (vcp.rB.x * Py - vcp.rB.y * Px);
                vB.x += Px * mB;
                vB.y += Py * mB;
            }
            this.velocities[indexA].w = wA;
            this.velocities[indexB].w = wB;
        }
    }

    public final void initializeVelocityConstraints() {
        for (int i = 0; i < this.count; ++i) {
            ContactVelocityConstraint vc = this.velocityConstraints[i];
            ContactPositionConstraint pc = this.positionConstraints[i];
            float radiusA = pc.radiusA;
            float radiusB = pc.radiusB;
            Manifold manifold = this.contacts[vc.contactIndex].getManifold();
            int indexA = vc.indexA;
            int indexB = vc.indexB;
            float mA = vc.invMassA;
            float mB = vc.invMassB;
            float iA = vc.invIA;
            float iB = vc.invIB;
            Vec2 localCenterA = pc.localCenterA;
            Vec2 localCenterB = pc.localCenterB;
            Vec2 cA = this.positions[indexA].c;
            float aA = this.positions[indexA].a;
            Vec2 vA = this.velocities[indexA].v;
            float wA = this.velocities[indexA].w;
            Vec2 cB = this.positions[indexB].c;
            float aB = this.positions[indexB].a;
            Vec2 vB = this.velocities[indexB].v;
            float wB = this.velocities[indexB].w;
            assert (manifold.pointCount > 0);
            Rot xfAq = this.xfA.q;
            Rot xfBq = this.xfB.q;
            xfAq.set(aA);
            xfBq.set(aB);
            this.xfA.p.x = cA.x - (xfAq.c * localCenterA.x - xfAq.s * localCenterA.y);
            this.xfA.p.y = cA.y - (xfAq.s * localCenterA.x + xfAq.c * localCenterA.y);
            this.xfB.p.x = cB.x - (xfBq.c * localCenterB.x - xfBq.s * localCenterB.y);
            this.xfB.p.y = cB.y - (xfBq.s * localCenterB.x + xfBq.c * localCenterB.y);
            this.worldManifold.initialize(manifold, this.xfA, radiusA, this.xfB, radiusB);
            Vec2 vcnormal = vc.normal;
            vcnormal.x = this.worldManifold.normal.x;
            vcnormal.y = this.worldManifold.normal.y;
            int pointCount = vc.pointCount;
            for (int j = 0; j < pointCount; ++j) {
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[j];
                Vec2 wmPj = this.worldManifold.points[j];
                Vec2 vcprA = vcp.rA;
                Vec2 vcprB = vcp.rB;
                vcprA.x = wmPj.x - cA.x;
                vcprA.y = wmPj.y - cA.y;
                vcprB.x = wmPj.x - cB.x;
                vcprB.y = wmPj.y - cB.y;
                float rnA = vcprA.x * vcnormal.y - vcprA.y * vcnormal.x;
                float rnB = vcprB.x * vcnormal.y - vcprB.y * vcnormal.x;
                float kNormal = mA + mB + iA * rnA * rnA + iB * rnB * rnB;
                vcp.normalMass = kNormal > 0.0f ? 1.0f / kNormal : 0.0f;
                float tangentX = vcnormal.y;
                float tangentY = -1.0f * vcnormal.x;
                float rtA = vcprA.x * tangentY - vcprA.y * tangentX;
                float rtB = vcprB.x * tangentY - vcprB.y * tangentX;
                float kTangent = mA + mB + iA * rtA * rtA + iB * rtB * rtB;
                vcp.tangentMass = kTangent > 0.0f ? 1.0f / kTangent : 0.0f;
                vcp.velocityBias = 0.0f;
                float tempx = vB.x + -wB * vcprB.y - vA.x - -wA * vcprA.y;
                float tempy = vB.y + wB * vcprB.x - vA.y - wA * vcprA.x;
                float vRel = vcnormal.x * tempx + vcnormal.y * tempy;
                if (!(vRel < -Settings.velocityThreshold)) continue;
                vcp.velocityBias = -vc.restitution * vRel;
            }
            if (vc.pointCount != 2) continue;
            ContactVelocityConstraint.VelocityConstraintPoint vcp1 = vc.points[0];
            ContactVelocityConstraint.VelocityConstraintPoint vcp2 = vc.points[1];
            float rn1A = vcp1.rA.x * vcnormal.y - vcp1.rA.y * vcnormal.x;
            float rn1B = vcp1.rB.x * vcnormal.y - vcp1.rB.y * vcnormal.x;
            float k11 = mA + mB + iA * rn1A * rn1A + iB * rn1B * rn1B;
            float rn2A = vcp2.rA.x * vcnormal.y - vcp2.rA.y * vcnormal.x;
            float rn2B = vcp2.rB.x * vcnormal.y - vcp2.rB.y * vcnormal.x;
            float k22 = mA + mB + iA * rn2A * rn2A + iB * rn2B * rn2B;
            float k12 = mA + mB + iA * rn1A * rn2A + iB * rn1B * rn2B;
            if (k11 * k11 < 100.0f * (k11 * k22 - k12 * k12)) {
                vc.K.ex.x = k11;
                vc.K.ex.y = k12;
                vc.K.ey.x = k12;
                vc.K.ey.y = k22;
                vc.K.invertToOut(vc.normalMass);
                continue;
            }
            vc.pointCount = 1;
        }
    }

    public final void solveVelocityConstraints() {
        for (int i = 0; i < this.count; ++i) {
            ContactVelocityConstraint vc = this.velocityConstraints[i];
            int indexA = vc.indexA;
            int indexB = vc.indexB;
            float mA = vc.invMassA;
            float mB = vc.invMassB;
            float iA = vc.invIA;
            float iB = vc.invIB;
            int pointCount = vc.pointCount;
            Vec2 vA = this.velocities[indexA].v;
            float wA = this.velocities[indexA].w;
            Vec2 vB = this.velocities[indexB].v;
            float wB = this.velocities[indexB].w;
            Vec2 normal = vc.normal;
            float normalX = normal.x;
            float normalY = normal.y;
            float tangentX = vc.normal.y;
            float tangentY = -1.0f * vc.normal.x;
            float friction = vc.friction;
            assert (pointCount == 1 || pointCount == 2);
            for (int j = 0; j < pointCount; ++j) {
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[j];
                Vec2 a = vcp.rA;
                float dvx = -wB * vcp.rB.y + vB.x - vA.x + wA * a.y;
                float dvy = wB * vcp.rB.x + vB.y - vA.y - wA * a.x;
                float vt = dvx * tangentX + dvy * tangentY - vc.tangentSpeed;
                float lambda = vcp.tangentMass * -vt;
                float maxFriction = friction * vcp.normalImpulse;
                float newImpulse = MathUtils.clamp(vcp.tangentImpulse + lambda, -maxFriction, maxFriction);
                lambda = newImpulse - vcp.tangentImpulse;
                vcp.tangentImpulse = newImpulse;
                float Px = tangentX * lambda;
                float Py = tangentY * lambda;
                vA.x -= Px * mA;
                vA.y -= Py * mA;
                wA -= iA * (vcp.rA.x * Py - vcp.rA.y * Px);
                vB.x += Px * mB;
                vB.y += Py * mB;
                wB += iB * (vcp.rB.x * Py - vcp.rB.y * Px);
            }
            if (vc.pointCount == 1) {
                ContactVelocityConstraint.VelocityConstraintPoint vcp = vc.points[0];
                float dvx = -wB * vcp.rB.y + vB.x - vA.x + wA * vcp.rA.y;
                float dvy = wB * vcp.rB.x + vB.y - vA.y - wA * vcp.rA.x;
                float vn = dvx * normalX + dvy * normalY;
                float lambda = -vcp.normalMass * (vn - vcp.velocityBias);
                float a = vcp.normalImpulse + lambda;
                float newImpulse = Math.max(a, 0.0f);
                lambda = newImpulse - vcp.normalImpulse;
                vcp.normalImpulse = newImpulse;
                float Px = normalX * lambda;
                float Py = normalY * lambda;
                vA.x -= Px * mA;
                vA.y -= Py * mA;
                wA -= iA * (vcp.rA.x * Py - vcp.rA.y * Px);
                vB.x += Px * mB;
                vB.y += Py * mB;
                wB += iB * (vcp.rB.x * Py - vcp.rB.y * Px);
            } else {
                ContactVelocityConstraint.VelocityConstraintPoint cp1 = vc.points[0];
                ContactVelocityConstraint.VelocityConstraintPoint cp2 = vc.points[1];
                Vec2 cp1rA = cp1.rA;
                Vec2 cp1rB = cp1.rB;
                Vec2 cp2rA = cp2.rA;
                Vec2 cp2rB = cp2.rB;
                float ax = cp1.normalImpulse;
                float ay = cp2.normalImpulse;
                assert (ax >= 0.0f && ay >= 0.0f);
                float dv1x = -wB * cp1rB.y + vB.x - vA.x + wA * cp1rA.y;
                float dv1y = wB * cp1rB.x + vB.y - vA.y - wA * cp1rA.x;
                float dv2x = -wB * cp2rB.y + vB.x - vA.x + wA * cp2rA.y;
                float dv2y = wB * cp2rB.x + vB.y - vA.y - wA * cp2rA.x;
                float vn1 = dv1x * normalX + dv1y * normalY;
                float vn2 = dv2x * normalX + dv2y * normalY;
                float bx = vn1 - cp1.velocityBias;
                float by = vn2 - cp2.velocityBias;
                Mat22 R = vc.K;
                Mat22 R1 = vc.normalMass;
                float xx = R1.ex.x * (bx -= R.ex.x * ax + R.ey.x * ay) + R1.ey.x * (by -= R.ex.y * ax + R.ey.y * ay);
                float xy = R1.ex.y * bx + R1.ey.y * by;
                xx *= -1.0f;
                xy *= -1.0f;
                if (xx >= 0.0f && xy >= 0.0f) {
                    dx = xx - ax;
                    dy = xy - ay;
                    P1x = dx * normalX;
                    P1y = dx * normalY;
                    P2x = dy * normalX;
                    P2y = dy * normalY;
                    vA.x -= mA * (P1x + P2x);
                    vA.y -= mA * (P1y + P2y);
                    vB.x += mB * (P1x + P2x);
                    vB.y += mB * (P1y + P2y);
                    wA -= iA * (cp1rA.x * P1y - cp1rA.y * P1x + (cp2rA.x * P2y - cp2rA.y * P2x));
                    wB += iB * (cp1rB.x * P1y - cp1rB.y * P1x + (cp2rB.x * P2y - cp2rB.y * P2x));
                    cp1.normalImpulse = xx;
                    cp2.normalImpulse = xy;
                } else {
                    xx = -cp1.normalMass * bx;
                    xy = 0.0f;
                    vn1 = 0.0f;
                    vn2 = vc.K.ex.y * xx + by;
                    if (xx >= 0.0f && vn2 >= 0.0f) {
                        dx = xx - ax;
                        dy = xy - ay;
                        P1x = normalX * dx;
                        P1y = normalY * dx;
                        P2x = normalX * dy;
                        P2y = normalY * dy;
                        vA.x -= mA * (P1x + P2x);
                        vA.y -= mA * (P1y + P2y);
                        vB.x += mB * (P1x + P2x);
                        vB.y += mB * (P1y + P2y);
                        wA -= iA * (cp1rA.x * P1y - cp1rA.y * P1x + (cp2rA.x * P2y - cp2rA.y * P2x));
                        wB += iB * (cp1rB.x * P1y - cp1rB.y * P1x + (cp2rB.x * P2y - cp2rB.y * P2x));
                        cp1.normalImpulse = xx;
                        cp2.normalImpulse = xy;
                    } else {
                        xx = 0.0f;
                        xy = -cp2.normalMass * by;
                        vn1 = vc.K.ey.x * xy + bx;
                        vn2 = 0.0f;
                        if (xy >= 0.0f && vn1 >= 0.0f) {
                            dx = xx - ax;
                            dy = xy - ay;
                            P1x = normalX * dx;
                            P1y = normalY * dx;
                            P2x = normalX * dy;
                            P2y = normalY * dy;
                            vA.x -= mA * (P1x + P2x);
                            vA.y -= mA * (P1y + P2y);
                            vB.x += mB * (P1x + P2x);
                            vB.y += mB * (P1y + P2y);
                            wA -= iA * (cp1rA.x * P1y - cp1rA.y * P1x + (cp2rA.x * P2y - cp2rA.y * P2x));
                            wB += iB * (cp1rB.x * P1y - cp1rB.y * P1x + (cp2rB.x * P2y - cp2rB.y * P2x));
                            cp1.normalImpulse = xx;
                            cp2.normalImpulse = xy;
                        } else {
                            xx = 0.0f;
                            xy = 0.0f;
                            vn1 = bx;
                            vn2 = by;
                            if (vn1 >= 0.0f && vn2 >= 0.0f) {
                                dx = xx - ax;
                                dy = xy - ay;
                                P1x = normalX * dx;
                                P1y = normalY * dx;
                                P2x = normalX * dy;
                                P2y = normalY * dy;
                                vA.x -= mA * (P1x + P2x);
                                vA.y -= mA * (P1y + P2y);
                                vB.x += mB * (P1x + P2x);
                                vB.y += mB * (P1y + P2y);
                                wA -= iA * (cp1rA.x * P1y - cp1rA.y * P1x + (cp2rA.x * P2y - cp2rA.y * P2x));
                                wB += iB * (cp1rB.x * P1y - cp1rB.y * P1x + (cp2rB.x * P2y - cp2rB.y * P2x));
                                cp1.normalImpulse = xx;
                                cp2.normalImpulse = xy;
                            }
                        }
                    }
                }
            }
            this.velocities[indexA].w = wA;
            this.velocities[indexB].w = wB;
        }
    }

    public void storeImpulses() {
        for (int i = 0; i < this.count; ++i) {
            ContactVelocityConstraint vc = this.velocityConstraints[i];
            Manifold manifold = this.contacts[vc.contactIndex].getManifold();
            for (int j = 0; j < vc.pointCount; ++j) {
                manifold.points[j].normalImpulse = vc.points[j].normalImpulse;
                manifold.points[j].tangentImpulse = vc.points[j].tangentImpulse;
            }
        }
    }

    public final boolean solvePositionConstraints() {
        float minSeparation = 0.0f;
        for (int i = 0; i < this.count; ++i) {
            ContactPositionConstraint pc = this.positionConstraints[i];
            int indexA = pc.indexA;
            int indexB = pc.indexB;
            float mA = pc.invMassA;
            float iA = pc.invIA;
            Vec2 localCenterA = pc.localCenterA;
            float localCenterAx = localCenterA.x;
            float localCenterAy = localCenterA.y;
            float mB = pc.invMassB;
            float iB = pc.invIB;
            Vec2 localCenterB = pc.localCenterB;
            float localCenterBx = localCenterB.x;
            float localCenterBy = localCenterB.y;
            int pointCount = pc.pointCount;
            Vec2 cA = this.positions[indexA].c;
            float aA = this.positions[indexA].a;
            Vec2 cB = this.positions[indexB].c;
            float aB = this.positions[indexB].a;
            for (int j = 0; j < pointCount; ++j) {
                Rot xfAq = this.xfA.q;
                Rot xfBq = this.xfB.q;
                xfAq.set(aA);
                xfBq.set(aB);
                this.xfA.p.x = cA.x - xfAq.c * localCenterAx + xfAq.s * localCenterAy;
                this.xfA.p.y = cA.y - xfAq.s * localCenterAx - xfAq.c * localCenterAy;
                this.xfB.p.x = cB.x - xfBq.c * localCenterBx + xfBq.s * localCenterBy;
                this.xfB.p.y = cB.y - xfBq.s * localCenterBx - xfBq.c * localCenterBy;
                PositionSolverManifold psm = this.psolver;
                psm.initialize(pc, this.xfA, this.xfB, j);
                Vec2 normal = psm.normal;
                Vec2 point = psm.point;
                float separation = psm.separation;
                float rAx = point.x - cA.x;
                float rAy = point.y - cA.y;
                float rBx = point.x - cB.x;
                float rBy = point.y - cB.y;
                minSeparation = MathUtils.min(minSeparation, separation);
                float C = MathUtils.clamp(Settings.baumgarte * (separation + Settings.linearSlop), -Settings.maxLinearCorrection, 0.0f);
                float rnA = rAx * normal.y - rAy * normal.x;
                float rnB = rBx * normal.y - rBy * normal.x;
                float K = mA + mB + iA * rnA * rnA + iB * rnB * rnB;
                float impulse = K > 0.0f ? -C / K : 0.0f;
                float Px = normal.x * impulse;
                float Py = normal.y * impulse;
                cA.x -= Px * mA;
                cA.y -= Py * mA;
                aA -= iA * (rAx * Py - rAy * Px);
                cB.x += Px * mB;
                cB.y += Py * mB;
                aB += iB * (rBx * Py - rBy * Px);
            }
            this.positions[indexA].a = aA;
            this.positions[indexB].a = aB;
        }
        return minSeparation >= -3.0f * Settings.linearSlop;
    }

    public boolean solveTOIPositionConstraints(int toiIndexA, int toiIndexB) {
        float minSeparation = 0.0f;
        for (int i = 0; i < this.count; ++i) {
            ContactPositionConstraint pc = this.positionConstraints[i];
            int indexA = pc.indexA;
            int indexB = pc.indexB;
            Vec2 localCenterA = pc.localCenterA;
            Vec2 localCenterB = pc.localCenterB;
            float localCenterAx = localCenterA.x;
            float localCenterAy = localCenterA.y;
            float localCenterBx = localCenterB.x;
            float localCenterBy = localCenterB.y;
            int pointCount = pc.pointCount;
            float mA = 0.0f;
            float iA = 0.0f;
            if (indexA == toiIndexA || indexA == toiIndexB) {
                mA = pc.invMassA;
                iA = pc.invIA;
            }
            float mB = 0.0f;
            float iB = 0.0f;
            if (indexB == toiIndexA || indexB == toiIndexB) {
                mB = pc.invMassB;
                iB = pc.invIB;
            }
            Vec2 cA = this.positions[indexA].c;
            float aA = this.positions[indexA].a;
            Vec2 cB = this.positions[indexB].c;
            float aB = this.positions[indexB].a;
            for (int j = 0; j < pointCount; ++j) {
                Rot xfAq = this.xfA.q;
                Rot xfBq = this.xfB.q;
                xfAq.set(aA);
                xfBq.set(aB);
                this.xfA.p.x = cA.x - xfAq.c * localCenterAx + xfAq.s * localCenterAy;
                this.xfA.p.y = cA.y - xfAq.s * localCenterAx - xfAq.c * localCenterAy;
                this.xfB.p.x = cB.x - xfBq.c * localCenterBx + xfBq.s * localCenterBy;
                this.xfB.p.y = cB.y - xfBq.s * localCenterBx - xfBq.c * localCenterBy;
                PositionSolverManifold psm = this.psolver;
                psm.initialize(pc, this.xfA, this.xfB, j);
                Vec2 normal = psm.normal;
                Vec2 point = psm.point;
                float separation = psm.separation;
                float rAx = point.x - cA.x;
                float rAy = point.y - cA.y;
                float rBx = point.x - cB.x;
                float rBy = point.y - cB.y;
                minSeparation = MathUtils.min(minSeparation, separation);
                float C = MathUtils.clamp(Settings.toiBaugarte * (separation + Settings.linearSlop), -Settings.maxLinearCorrection, 0.0f);
                float rnA = rAx * normal.y - rAy * normal.x;
                float rnB = rBx * normal.y - rBy * normal.x;
                float K = mA + mB + iA * rnA * rnA + iB * rnB * rnB;
                float impulse = K > 0.0f ? -C / K : 0.0f;
                float Px = normal.x * impulse;
                float Py = normal.y * impulse;
                cA.x -= Px * mA;
                cA.y -= Py * mA;
                aA -= iA * (rAx * Py - rAy * Px);
                cB.x += Px * mB;
                cB.y += Py * mB;
                aB += iB * (rBx * Py - rBy * Px);
            }
            this.positions[indexA].a = aA;
            this.positions[indexB].a = aB;
        }
        return minSeparation >= -1.5f * Settings.linearSlop;
    }

    public static class ContactSolverDef {
        public TimeStep step;
        public Contact[] contacts;
        public int count;
        public Position[] positions;
        public Velocity[] velocities;
    }
}

