/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.DistanceJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class DistanceJoint
extends Joint {
    private float frequencyHz;
    private float dampingRatio;
    private float bias;
    private final Vec2 localAnchorA;
    private final Vec2 localAnchorB;
    private float gamma;
    private float impulse;
    private float length;
    private int indexA;
    private int indexB;
    private final Vec2 u = new Vec2();
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 localCenterA = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private float invMassA;
    private float invMassB;
    private float invIA;
    private float invIB;
    private float mass;

    protected DistanceJoint(IWorldPool argWorld, DistanceJointDef def) {
        super(argWorld, def);
        this.localAnchorA = def.localAnchorA.clone();
        this.localAnchorB = def.localAnchorB.clone();
        this.length = def.length;
        this.impulse = 0.0f;
        this.frequencyHz = def.frequencyHz;
        this.dampingRatio = def.dampingRatio;
        this.gamma = 0.0f;
        this.bias = 0.0f;
    }

    public void setFrequency(float hz) {
        this.frequencyHz = hz;
    }

    public float getFrequency() {
        return this.frequencyHz;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float argLength) {
        this.length = argLength;
    }

    public void setDampingRatio(float damp) {
        this.dampingRatio = damp;
    }

    public float getDampingRatio() {
        return this.dampingRatio;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.bodyA.getWorldPointToOut(this.localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    public Vec2 getLocalAnchorA() {
        return this.localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.localAnchorB;
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        argOut.x = this.impulse * this.u.x * invDt;
        argOut.y = this.impulse * this.u.y * invDt;
    }

    @Override
    public float getReactionTorque(float invDt) {
        return 0.0f;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.localCenterA.set(this.bodyA.sweep.localCenter);
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassA = this.bodyA.invMass;
        this.invMassB = this.bodyB.invMass;
        this.invIA = this.bodyA.invI;
        this.invIB = this.bodyB.invI;
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, this.u.set(this.localAnchorA).subLocal(this.localCenterA), this.rA);
        Rot.mulToOutUnsafe(qB, this.u.set(this.localAnchorB).subLocal(this.localCenterB), this.rB);
        this.u.set(cB).addLocal(this.rB).subLocal(cA).subLocal(this.rA);
        this.pool.pushRot(2);
        float length = this.u.length();
        if (length > Settings.linearSlop) {
            this.u.x *= 1.0f / length;
            this.u.y *= 1.0f / length;
        } else {
            this.u.set(0.0f, 0.0f);
        }
        float crAu = Vec2.cross(this.rA, this.u);
        float crBu = Vec2.cross(this.rB, this.u);
        float invMass = this.invMassA + this.invIA * crAu * crAu + this.invMassB + this.invIB * crBu * crBu;
        float f = this.mass = invMass != 0.0f ? 1.0f / invMass : 0.0f;
        if (this.frequencyHz > 0.0f) {
            float C = length - this.length;
            float omega = (float)Math.PI * 2 * this.frequencyHz;
            float d = 2.0f * this.mass * this.dampingRatio * omega;
            float k = this.mass * omega * omega;
            float h = data.step.dt;
            this.gamma = h * (d + h * k);
            this.gamma = this.gamma != 0.0f ? 1.0f / this.gamma : 0.0f;
            this.bias = C * h * k * this.gamma;
            this.mass = (invMass += this.gamma) != 0.0f ? 1.0f / invMass : 0.0f;
        } else {
            this.gamma = 0.0f;
            this.bias = 0.0f;
        }
        if (data.step.warmStarting) {
            this.impulse *= data.step.dtRatio;
            Vec2 P = this.pool.popVec2();
            P.set(this.u).mulLocal(this.impulse);
            vA.x -= this.invMassA * P.x;
            vA.y -= this.invMassA * P.y;
            wA -= this.invIA * Vec2.cross(this.rA, P);
            vB.x += this.invMassB * P.x;
            vB.y += this.invMassB * P.y;
            wB += this.invIB * Vec2.cross(this.rB, P);
            this.pool.pushVec2(1);
        } else {
            this.impulse = 0.0f;
        }
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Vec2 vpA = this.pool.popVec2();
        Vec2 vpB = this.pool.popVec2();
        Vec2.crossToOutUnsafe(wA, this.rA, vpA);
        vpA.addLocal(vA);
        Vec2.crossToOutUnsafe(wB, this.rB, vpB);
        vpB.addLocal(vB);
        float Cdot = Vec2.dot(this.u, vpB.subLocal(vpA));
        float impulse = -this.mass * (Cdot + this.bias + this.gamma * this.impulse);
        this.impulse += impulse;
        float Px = impulse * this.u.x;
        float Py = impulse * this.u.y;
        vA.x -= this.invMassA * Px;
        vA.y -= this.invMassA * Py;
        vB.x += this.invMassB * Px;
        vB.y += this.invMassB * Py;
        data.velocities[this.indexA].w = wA -= this.invIA * (this.rA.x * Py - this.rA.y * Px);
        data.velocities[this.indexB].w = wB += this.invIB * (this.rB.x * Py - this.rB.y * Px);
        this.pool.pushVec2(2);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        if (this.frequencyHz > 0.0f) {
            return true;
        }
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        Vec2 u = this.pool.popVec2();
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, u.set(this.localAnchorA).subLocal(this.localCenterA), rA);
        Rot.mulToOutUnsafe(qB, u.set(this.localAnchorB).subLocal(this.localCenterB), rB);
        u.set(cB).addLocal(rB).subLocal(cA).subLocal(rA);
        float length = u.normalize();
        float C = length - this.length;
        C = MathUtils.clamp(C, -Settings.maxLinearCorrection, Settings.maxLinearCorrection);
        float impulse = -this.mass * C;
        float Px = impulse * u.x;
        float Py = impulse * u.y;
        cA.x -= this.invMassA * Px;
        cA.y -= this.invMassA * Py;
        cB.x += this.invMassB * Px;
        cB.y += this.invMassB * Py;
        data.positions[this.indexA].a = aA -= this.invIA * (rA.x * Py - rA.y * Px);
        data.positions[this.indexB].a = aB += this.invIB * (rB.x * Py - rB.y * Px);
        this.pool.pushVec2(3);
        this.pool.pushRot(2);
        return MathUtils.abs(C) < Settings.linearSlop;
    }
}

