/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.Mat22;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.MotorJointDef;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class MotorJoint
extends Joint {
    private final Vec2 linearOffset = new Vec2();
    private float angularOffset;
    private final Vec2 linearImpulse = new Vec2();
    private float angularImpulse;
    private float maxForce;
    private float maxTorque;
    private float correctionFactor;
    private int indexA;
    private int indexB;
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 localCenterA = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private final Vec2 linearError = new Vec2();
    private float angularError;
    private float invMassA;
    private float invMassB;
    private float invIA;
    private float invIB;
    private final Mat22 linearMass = new Mat22();
    private float angularMass;

    public MotorJoint(IWorldPool pool, MotorJointDef def) {
        super(pool, def);
        this.linearOffset.set(def.linearOffset);
        this.angularOffset = def.angularOffset;
        this.angularImpulse = 0.0f;
        this.maxForce = def.maxForce;
        this.maxTorque = def.maxTorque;
        this.correctionFactor = def.correctionFactor;
    }

    @Override
    public void getAnchorA(Vec2 out) {
        out.set(this.bodyA.getPosition());
    }

    @Override
    public void getAnchorB(Vec2 out) {
        out.set(this.bodyB.getPosition());
    }

    @Override
    public void getReactionForce(float invDt, Vec2 out) {
        out.set(this.linearImpulse).mulLocal(invDt);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return this.angularImpulse * invDt;
    }

    public float getCorrectionFactor() {
        return this.correctionFactor;
    }

    public void setCorrectionFactor(float correctionFactor) {
        this.correctionFactor = correctionFactor;
    }

    public void setLinearOffset(Vec2 linearOffset) {
        if (linearOffset.x != this.linearOffset.x || linearOffset.y != this.linearOffset.y) {
            this.bodyA.setAwake(true);
            this.bodyB.setAwake(true);
            this.linearOffset.set(linearOffset);
        }
    }

    public void getLinearOffset(Vec2 out) {
        out.set(this.linearOffset);
    }

    public Vec2 getLinearOffset() {
        return this.linearOffset;
    }

    public void setAngularOffset(float angularOffset) {
        if (angularOffset != this.angularOffset) {
            this.bodyA.setAwake(true);
            this.bodyB.setAwake(true);
            this.angularOffset = angularOffset;
        }
    }

    public float getAngularOffset() {
        return this.angularOffset;
    }

    public void setMaxForce(float force) {
        assert (force >= 0.0f);
        this.maxForce = force;
    }

    public float getMaxForce() {
        return this.maxForce;
    }

    public void setMaxTorque(float torque) {
        assert (torque >= 0.0f);
        this.maxTorque = torque;
    }

    public float getMaxTorque() {
        return this.maxTorque;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.localCenterA.set(this.bodyA.sweep.localCenter);
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassA = this.bodyA.invMass;
        this.invMassB = this.bodyB.invMass;
        this.invIA = this.bodyA.invI;
        this.invIB = this.bodyB.invI;
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        Mat22 K = this.pool.popMat22();
        qA.set(aA);
        qB.set(aB);
        this.rA.x = qA.c * -this.localCenterA.x - qA.s * -this.localCenterA.y;
        this.rA.y = qA.s * -this.localCenterA.x + qA.c * -this.localCenterA.y;
        this.rB.x = qB.c * -this.localCenterB.x - qB.s * -this.localCenterB.y;
        this.rB.y = qB.s * -this.localCenterB.x + qB.c * -this.localCenterB.y;
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        K.ex.x = mA + mB + iA * this.rA.y * this.rA.y + iB * this.rB.y * this.rB.y;
        K.ey.x = K.ex.y = -iA * this.rA.x * this.rA.y - iB * this.rB.x * this.rB.y;
        K.ey.y = mA + mB + iA * this.rA.x * this.rA.x + iB * this.rB.x * this.rB.x;
        K.invertToOut(this.linearMass);
        this.angularMass = iA + iB;
        if (this.angularMass > 0.0f) {
            this.angularMass = 1.0f / this.angularMass;
        }
        Rot.mulToOutUnsafe(qA, this.linearOffset, temp);
        this.linearError.x = cB.x + this.rB.x - cA.x - this.rA.x - temp.x;
        this.linearError.y = cB.y + this.rB.y - cA.y - this.rA.y - temp.y;
        this.angularError = aB - aA - this.angularOffset;
        if (data.step.warmStarting) {
            this.linearImpulse.x *= data.step.dtRatio;
            this.linearImpulse.y *= data.step.dtRatio;
            this.angularImpulse *= data.step.dtRatio;
            Vec2 P = this.linearImpulse;
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * (this.rA.x * P.y - this.rA.y * P.x + this.angularImpulse);
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * (this.rB.x * P.y - this.rB.y * P.x + this.angularImpulse);
        } else {
            this.linearImpulse.setZero();
            this.angularImpulse = 0.0f;
        }
        this.pool.pushVec2(1);
        this.pool.pushMat22(1);
        this.pool.pushRot(2);
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        float h = data.step.dt;
        float inv_h = data.step.inv_dt;
        Vec2 temp = this.pool.popVec2();
        float Cdot = wB - wA + inv_h * this.correctionFactor * this.angularError;
        float impulse = -this.angularMass * Cdot;
        float oldImpulse = this.angularImpulse;
        float maxImpulse = h * this.maxTorque;
        this.angularImpulse = MathUtils.clamp(this.angularImpulse + impulse, -maxImpulse, maxImpulse);
        impulse = this.angularImpulse - oldImpulse;
        Vec2 Cdot2 = this.pool.popVec2();
        Cdot2.x = vB.x + -(wB += iB * impulse) * this.rB.y - vA.x - -(wA -= iA * impulse) * this.rA.y + inv_h * this.correctionFactor * this.linearError.x;
        Cdot2.y = vB.y + wB * this.rB.x - vA.y - wA * this.rA.x + inv_h * this.correctionFactor * this.linearError.y;
        Mat22.mulToOutUnsafe(this.linearMass, Cdot2, temp);
        temp.negateLocal();
        Vec2 oldImpulse2 = this.pool.popVec2();
        oldImpulse2.set(this.linearImpulse);
        this.linearImpulse.addLocal(temp);
        float maxImpulse2 = h * this.maxForce;
        if (this.linearImpulse.lengthSquared() > maxImpulse2 * maxImpulse2) {
            this.linearImpulse.normalize();
            this.linearImpulse.mulLocal(maxImpulse2);
        }
        temp.x = this.linearImpulse.x - oldImpulse2.x;
        temp.y = this.linearImpulse.y - oldImpulse2.y;
        vA.x -= mA * temp.x;
        vA.y -= mA * temp.y;
        vB.x += mB * temp.x;
        vB.y += mB * temp.y;
        this.pool.pushVec2(3);
        data.velocities[this.indexA].w = wA -= iA * (this.rA.x * temp.y - this.rA.y * temp.x);
        data.velocities[this.indexB].w = wB += iB * (this.rB.x * temp.y - this.rB.y * temp.x);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        return true;
    }
}

