/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.Mat22;
import de.pirckheimer_gymnasium.jbox2d.common.Mat33;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.common.Vec3;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.LimitState;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PrismaticJointDef;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class PrismaticJoint
extends Joint {
    protected final Vec2 localAnchorA;
    protected final Vec2 localAnchorB;
    protected final Vec2 localXAxisA;
    protected final Vec2 localYAxisA;
    protected float referenceAngle;
    private final Vec3 impulse;
    private float motorImpulse;
    private float lowerTranslation;
    private float upperTranslation;
    private float maxMotorForce;
    private float motorSpeed;
    private boolean enableLimit;
    private boolean enableMotor;
    private LimitState limitState;
    private int indexA;
    private int indexB;
    private final Vec2 localCenterA = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private float invMassA;
    private float invMassB;
    private float invIA;
    private float invIB;
    private final Vec2 axis;
    private final Vec2 perp;
    private float s1;
    private float s2;
    private float a1;
    private float a2;
    private final Mat33 K;
    private float motorMass;

    protected PrismaticJoint(IWorldPool argWorld, PrismaticJointDef def) {
        super(argWorld, def);
        this.localAnchorA = new Vec2(def.localAnchorA);
        this.localAnchorB = new Vec2(def.localAnchorB);
        this.localXAxisA = new Vec2(def.localAxisA);
        this.localXAxisA.normalize();
        this.localYAxisA = new Vec2();
        Vec2.crossToOutUnsafe(1.0f, this.localXAxisA, this.localYAxisA);
        this.referenceAngle = def.referenceAngle;
        this.impulse = new Vec3();
        this.motorMass = 0.0f;
        this.motorImpulse = 0.0f;
        this.lowerTranslation = def.lowerTranslation;
        this.upperTranslation = def.upperTranslation;
        this.maxMotorForce = def.maxMotorForce;
        this.motorSpeed = def.motorSpeed;
        this.enableLimit = def.enableLimit;
        this.enableMotor = def.enableMotor;
        this.limitState = LimitState.INACTIVE;
        this.K = new Mat33();
        this.axis = new Vec2();
        this.perp = new Vec2();
    }

    public Vec2 getLocalAnchorA() {
        return this.localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.bodyA.getWorldPointToOut(this.localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        Vec2 temp = this.pool.popVec2();
        temp.set(this.axis).mulLocal(this.motorImpulse + this.impulse.z);
        argOut.set(this.perp).mulLocal(this.impulse.x).addLocal(temp).mulLocal(invDt);
        this.pool.pushVec2(1);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return invDt * this.impulse.y;
    }

    public float getJointSpeed() {
        Body bA = this.bodyA;
        Body bB = this.bodyB;
        Vec2 temp = this.pool.popVec2();
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        Vec2 p1 = this.pool.popVec2();
        Vec2 p2 = this.pool.popVec2();
        Vec2 d = this.pool.popVec2();
        Vec2 axis = this.pool.popVec2();
        Vec2 temp2 = this.pool.popVec2();
        Vec2 temp3 = this.pool.popVec2();
        temp.set(this.localAnchorA).subLocal(bA.sweep.localCenter);
        Rot.mulToOutUnsafe(bA.xf.q, temp, rA);
        temp.set(this.localAnchorB).subLocal(bB.sweep.localCenter);
        Rot.mulToOutUnsafe(bB.xf.q, temp, rB);
        p1.set(bA.sweep.c).addLocal(rA);
        p2.set(bB.sweep.c).addLocal(rB);
        d.set(p2).subLocal(p1);
        Rot.mulToOutUnsafe(bA.xf.q, this.localXAxisA, axis);
        Vec2 vA = bA.linearVelocity;
        Vec2 vB = bB.linearVelocity;
        float wA = bA.angularVelocity;
        float wB = bB.angularVelocity;
        Vec2.crossToOutUnsafe(wA, axis, temp);
        Vec2.crossToOutUnsafe(wB, rB, temp2);
        Vec2.crossToOutUnsafe(wA, rA, temp3);
        temp2.addLocal(vB).subLocal(vA).subLocal(temp3);
        float speed = Vec2.dot(d, temp) + Vec2.dot(axis, temp2);
        this.pool.pushVec2(9);
        return speed;
    }

    public float getJointTranslation() {
        Vec2 pA = this.pool.popVec2();
        Vec2 pB = this.pool.popVec2();
        Vec2 axis = this.pool.popVec2();
        this.bodyA.getWorldPointToOut(this.localAnchorA, pA);
        this.bodyB.getWorldPointToOut(this.localAnchorB, pB);
        this.bodyA.getWorldVectorToOutUnsafe(this.localXAxisA, axis);
        pB.subLocal(pA);
        float translation = Vec2.dot(pB, axis);
        this.pool.pushVec2(3);
        return translation;
    }

    public boolean isLimitEnabled() {
        return this.enableLimit;
    }

    public void enableLimit(boolean flag) {
        if (flag != this.enableLimit) {
            this.bodyA.setAwake(true);
            this.bodyB.setAwake(true);
            this.enableLimit = flag;
            this.impulse.z = 0.0f;
        }
    }

    public float getLowerLimit() {
        return this.lowerTranslation;
    }

    public float getUpperLimit() {
        return this.upperTranslation;
    }

    public void setLimits(float lower, float upper) {
        assert (lower <= upper);
        if (lower != this.lowerTranslation || upper != this.upperTranslation) {
            this.bodyA.setAwake(true);
            this.bodyB.setAwake(true);
            this.lowerTranslation = lower;
            this.upperTranslation = upper;
            this.impulse.z = 0.0f;
        }
    }

    public boolean isMotorEnabled() {
        return this.enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.bodyA.setAwake(true);
        this.bodyB.setAwake(true);
        this.enableMotor = flag;
    }

    public void setMotorSpeed(float speed) {
        this.bodyA.setAwake(true);
        this.bodyB.setAwake(true);
        this.motorSpeed = speed;
    }

    public float getMotorSpeed() {
        return this.motorSpeed;
    }

    public void setMaxMotorForce(float force) {
        this.bodyA.setAwake(true);
        this.bodyB.setAwake(true);
        this.maxMotorForce = force;
    }

    public float getMotorForce(float inv_dt) {
        return this.motorImpulse * inv_dt;
    }

    public float getMaxMotorForce() {
        return this.maxMotorForce;
    }

    public float getReferenceAngle() {
        return this.referenceAngle;
    }

    public Vec2 getLocalAxisA() {
        return this.localXAxisA;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.localCenterA.set(this.bodyA.sweep.localCenter);
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassA = this.bodyA.invMass;
        this.invMassB = this.bodyB.invMass;
        this.invIA = this.bodyA.invI;
        this.invIB = this.bodyB.invI;
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 d = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, d.set(this.localAnchorA).subLocal(this.localCenterA), rA);
        Rot.mulToOutUnsafe(qB, d.set(this.localAnchorB).subLocal(this.localCenterB), rB);
        d.set(cB).subLocal(cA).addLocal(rB).subLocal(rA);
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Rot.mulToOutUnsafe(qA, this.localXAxisA, this.axis);
        temp.set(d).addLocal(rA);
        this.a1 = Vec2.cross(temp, this.axis);
        this.a2 = Vec2.cross(rB, this.axis);
        this.motorMass = mA + mB + iA * this.a1 * this.a1 + iB * this.a2 * this.a2;
        if (this.motorMass > 0.0f) {
            this.motorMass = 1.0f / this.motorMass;
        }
        Rot.mulToOutUnsafe(qA, this.localYAxisA, this.perp);
        temp.set(d).addLocal(rA);
        this.s1 = Vec2.cross(temp, this.perp);
        this.s2 = Vec2.cross(rB, this.perp);
        float k11 = mA + mB + iA * this.s1 * this.s1 + iB * this.s2 * this.s2;
        float k12 = iA * this.s1 + iB * this.s2;
        float k13 = iA * this.s1 * this.a1 + iB * this.s2 * this.a2;
        float k22 = iA + iB;
        if (k22 == 0.0f) {
            k22 = 1.0f;
        }
        float k23 = iA * this.a1 + iB * this.a2;
        float k33 = mA + mB + iA * this.a1 * this.a1 + iB * this.a2 * this.a2;
        this.K.ex.set(k11, k12, k13);
        this.K.ey.set(k12, k22, k23);
        this.K.ez.set(k13, k23, k33);
        if (this.enableLimit) {
            float jointTranslation = Vec2.dot(this.axis, d);
            if (MathUtils.abs(this.upperTranslation - this.lowerTranslation) < 2.0f * Settings.linearSlop) {
                this.limitState = LimitState.EQUAL;
            } else if (jointTranslation <= this.lowerTranslation) {
                if (this.limitState != LimitState.AT_LOWER) {
                    this.limitState = LimitState.AT_LOWER;
                    this.impulse.z = 0.0f;
                }
            } else if (jointTranslation >= this.upperTranslation) {
                if (this.limitState != LimitState.AT_UPPER) {
                    this.limitState = LimitState.AT_UPPER;
                    this.impulse.z = 0.0f;
                }
            } else {
                this.limitState = LimitState.INACTIVE;
                this.impulse.z = 0.0f;
            }
        } else {
            this.limitState = LimitState.INACTIVE;
            this.impulse.z = 0.0f;
        }
        if (!this.enableMotor) {
            this.motorImpulse = 0.0f;
        }
        if (data.step.warmStarting) {
            this.impulse.mulLocal(data.step.dtRatio);
            this.motorImpulse *= data.step.dtRatio;
            Vec2 P = this.pool.popVec2();
            temp.set(this.axis).mulLocal(this.motorImpulse + this.impulse.z);
            P.set(this.perp).mulLocal(this.impulse.x).addLocal(temp);
            float LA = this.impulse.x * this.s1 + this.impulse.y + (this.motorImpulse + this.impulse.z) * this.a1;
            float LB = this.impulse.x * this.s2 + this.impulse.y + (this.motorImpulse + this.impulse.z) * this.a2;
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * LA;
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * LB;
            this.pool.pushVec2(1);
        } else {
            this.impulse.setZero();
            this.motorImpulse = 0.0f;
        }
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        this.pool.pushRot(2);
        this.pool.pushVec2(4);
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Vec2 temp = this.pool.popVec2();
        if (this.enableMotor && this.limitState != LimitState.EQUAL) {
            temp.set(vB).subLocal(vA);
            float Cdot = Vec2.dot(this.axis, temp) + this.a2 * wB - this.a1 * wA;
            float impulse = this.motorMass * (this.motorSpeed - Cdot);
            float oldImpulse = this.motorImpulse;
            float maxImpulse = data.step.dt * this.maxMotorForce;
            this.motorImpulse = MathUtils.clamp(this.motorImpulse + impulse, -maxImpulse, maxImpulse);
            impulse = this.motorImpulse - oldImpulse;
            Vec2 P = this.pool.popVec2();
            P.set(this.axis).mulLocal(impulse);
            float LA = impulse * this.a1;
            float LB = impulse * this.a2;
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * LA;
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * LB;
            this.pool.pushVec2(1);
        }
        Vec2 Cdot1 = this.pool.popVec2();
        temp.set(vB).subLocal(vA);
        Cdot1.x = Vec2.dot(this.perp, temp) + this.s2 * wB - this.s1 * wA;
        Cdot1.y = wB - wA;
        if (this.enableLimit && this.limitState != LimitState.INACTIVE) {
            temp.set(vB).subLocal(vA);
            float Cdot2 = Vec2.dot(this.axis, temp) + this.a2 * wB - this.a1 * wA;
            Vec3 Cdot = this.pool.popVec3();
            Cdot.set(Cdot1.x, Cdot1.y, Cdot2);
            Vec3 f1 = this.pool.popVec3();
            Vec3 df = this.pool.popVec3();
            f1.set(this.impulse);
            this.K.solve33ToOut(Cdot.negateLocal(), df);
            this.impulse.addLocal(df);
            if (this.limitState == LimitState.AT_LOWER) {
                this.impulse.z = MathUtils.max(this.impulse.z, 0.0f);
            } else if (this.limitState == LimitState.AT_UPPER) {
                this.impulse.z = MathUtils.min(this.impulse.z, 0.0f);
            }
            Vec2 b = this.pool.popVec2();
            Vec2 f2r = this.pool.popVec2();
            temp.set(this.K.ez.x, this.K.ez.y).mulLocal(this.impulse.z - f1.z);
            b.set(Cdot1).negateLocal().subLocal(temp);
            this.K.solve22ToOut(b, f2r);
            f2r.addLocal(f1.x, f1.y);
            this.impulse.x = f2r.x;
            this.impulse.y = f2r.y;
            df.set(this.impulse).subLocal(f1);
            Vec2 P = this.pool.popVec2();
            temp.set(this.axis).mulLocal(df.z);
            P.set(this.perp).mulLocal(df.x).addLocal(temp);
            float LA = df.x * this.s1 + df.y + df.z * this.a1;
            float LB = df.x * this.s2 + df.y + df.z * this.a2;
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * LA;
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * LB;
            this.pool.pushVec2(3);
            this.pool.pushVec3(3);
        } else {
            Vec2 df = this.pool.popVec2();
            this.K.solve22ToOut(Cdot1.negateLocal(), df);
            Cdot1.negateLocal();
            this.impulse.x += df.x;
            this.impulse.y += df.y;
            Vec2 P = this.pool.popVec2();
            P.set(this.perp).mulLocal(df.x);
            float LA = df.x * this.s1 + df.y;
            float LB = df.x * this.s2 + df.y;
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * LA;
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * LB;
            this.pool.pushVec2(2);
        }
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        this.pool.pushVec2(2);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        Vec2 d = this.pool.popVec2();
        Vec2 axis = this.pool.popVec2();
        Vec2 perp = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        Vec2 C1 = this.pool.popVec2();
        Vec3 impulse = this.pool.popVec3();
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        qA.set(aA);
        qB.set(aB);
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), rB);
        d.set(cB).addLocal(rB).subLocal(cA).subLocal(rA);
        Rot.mulToOutUnsafe(qA, this.localXAxisA, axis);
        float a1 = Vec2.cross(temp.set(d).addLocal(rA), axis);
        float a2 = Vec2.cross(rB, axis);
        Rot.mulToOutUnsafe(qA, this.localYAxisA, perp);
        float s1 = Vec2.cross(temp.set(d).addLocal(rA), perp);
        float s2 = Vec2.cross(rB, perp);
        C1.x = Vec2.dot(perp, d);
        C1.y = aB - aA - this.referenceAngle;
        float linearError = MathUtils.abs(C1.x);
        float angularError = MathUtils.abs(C1.y);
        boolean active = false;
        float C2 = 0.0f;
        if (this.enableLimit) {
            float translation = Vec2.dot(axis, d);
            if (MathUtils.abs(this.upperTranslation - this.lowerTranslation) < 2.0f * Settings.linearSlop) {
                C2 = MathUtils.clamp(translation, -Settings.maxLinearCorrection, Settings.maxLinearCorrection);
                linearError = MathUtils.max(linearError, MathUtils.abs(translation));
                active = true;
            } else if (translation <= this.lowerTranslation) {
                C2 = MathUtils.clamp(translation - this.lowerTranslation + Settings.linearSlop, -Settings.maxLinearCorrection, 0.0f);
                linearError = MathUtils.max(linearError, this.lowerTranslation - translation);
                active = true;
            } else if (translation >= this.upperTranslation) {
                C2 = MathUtils.clamp(translation - this.upperTranslation - Settings.linearSlop, 0.0f, Settings.maxLinearCorrection);
                linearError = MathUtils.max(linearError, translation - this.upperTranslation);
                active = true;
            }
        }
        float v = mA + mB + iA * s1 * s1 + iB * s2 * s2;
        if (active) {
            k12 = iA * s1 + iB * s2;
            float k13 = iA * s1 * a1 + iB * s2 * a2;
            float k22 = iA + iB;
            if (k22 == 0.0f) {
                k22 = 1.0f;
            }
            float k23 = iA * a1 + iB * a2;
            float k33 = mA + mB + iA * a1 * a1 + iB * a2 * a2;
            Mat33 K = this.pool.popMat33();
            K.ex.set(v, k12, k13);
            K.ey.set(k12, k22, k23);
            K.ez.set(k13, k23, k33);
            Vec3 C = this.pool.popVec3();
            C.x = C1.x;
            C.y = C1.y;
            C.z = C2;
            K.solve33ToOut(C.negateLocal(), impulse);
            this.pool.pushVec3(1);
            this.pool.pushMat33(1);
        } else {
            k12 = iA * s1 + iB * s2;
            float k22 = iA + iB;
            if (k22 == 0.0f) {
                k22 = 1.0f;
            }
            Mat22 K = this.pool.popMat22();
            K.ex.set(v, k12);
            K.ey.set(k12, k22);
            K.solveToOut(C1.negateLocal(), temp);
            C1.negateLocal();
            impulse.x = temp.x;
            impulse.y = temp.y;
            impulse.z = 0.0f;
            this.pool.pushMat22(1);
        }
        float Px = impulse.x * perp.x + impulse.z * axis.x;
        float Py = impulse.x * perp.y + impulse.z * axis.y;
        float LA = impulse.x * s1 + impulse.y + impulse.z * a1;
        float LB = impulse.x * s2 + impulse.y + impulse.z * a2;
        cA.x -= mA * Px;
        cA.y -= mA * Py;
        cB.x += mB * Px;
        cB.y += mB * Py;
        data.positions[this.indexA].a = aA -= iA * LA;
        data.positions[this.indexB].a = aB += iB * LB;
        this.pool.pushVec2(7);
        this.pool.pushVec3(1);
        this.pool.pushRot(2);
        return linearError <= Settings.linearSlop && angularError <= Settings.angularSlop;
    }
}

