/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PulleyJointDef;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class PulleyJoint
extends Joint {
    public static final float MIN_PULLEY_LENGTH = 2.0f;
    private final Vec2 groundAnchorA = new Vec2();
    private final Vec2 groundAnchorB = new Vec2();
    private final float lengthA;
    private final float lengthB;
    private final Vec2 localAnchorA = new Vec2();
    private final Vec2 localAnchorB = new Vec2();
    private final float constant;
    private final float ratio;
    private float impulse;
    private int indexA;
    private int indexB;
    private final Vec2 uA = new Vec2();
    private final Vec2 uB = new Vec2();
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 localCenterA = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private float invMassA;
    private float invMassB;
    private float invIA;
    private float invIB;
    private float mass;

    protected PulleyJoint(IWorldPool argWorldPool, PulleyJointDef def) {
        super(argWorldPool, def);
        this.groundAnchorA.set(def.groundAnchorA);
        this.groundAnchorB.set(def.groundAnchorB);
        this.localAnchorA.set(def.localAnchorA);
        this.localAnchorB.set(def.localAnchorB);
        assert (def.ratio != 0.0f);
        this.ratio = def.ratio;
        this.lengthA = def.lengthA;
        this.lengthB = def.lengthB;
        this.constant = def.lengthA + this.ratio * def.lengthB;
        this.impulse = 0.0f;
    }

    public float getLengthA() {
        return this.lengthA;
    }

    public float getLengthB() {
        return this.lengthB;
    }

    public float getCurrentLengthA() {
        Vec2 p = this.pool.popVec2();
        this.bodyA.getWorldPointToOut(this.localAnchorA, p);
        p.subLocal(this.groundAnchorA);
        float length = p.length();
        this.pool.pushVec2(1);
        return length;
    }

    public float getCurrentLengthB() {
        Vec2 p = this.pool.popVec2();
        this.bodyB.getWorldPointToOut(this.localAnchorB, p);
        p.subLocal(this.groundAnchorB);
        float length = p.length();
        this.pool.pushVec2(1);
        return length;
    }

    public Vec2 getLocalAnchorA() {
        return this.localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.localAnchorB;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.bodyA.getWorldPointToOut(this.localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        argOut.set(this.uB).mulLocal(this.impulse).mulLocal(invDt);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return 0.0f;
    }

    public Vec2 getGroundAnchorA() {
        return this.groundAnchorA;
    }

    public Vec2 getGroundAnchorB() {
        return this.groundAnchorB;
    }

    public float getLength1() {
        Vec2 p = this.pool.popVec2();
        this.bodyA.getWorldPointToOut(this.localAnchorA, p);
        p.subLocal(this.groundAnchorA);
        float len = p.length();
        this.pool.pushVec2(1);
        return len;
    }

    public float getLength2() {
        Vec2 p = this.pool.popVec2();
        this.bodyB.getWorldPointToOut(this.localAnchorB, p);
        p.subLocal(this.groundAnchorB);
        float len = p.length();
        this.pool.pushVec2(1);
        return len;
    }

    public float getRatio() {
        return this.ratio;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.localCenterA.set(this.bodyA.sweep.localCenter);
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassA = this.bodyA.invMass;
        this.invMassB = this.bodyB.invMass;
        this.invIA = this.bodyA.invI;
        this.invIB = this.bodyB.invI;
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), this.rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), this.rB);
        this.uA.set(cA).addLocal(this.rA).subLocal(this.groundAnchorA);
        this.uB.set(cB).addLocal(this.rB).subLocal(this.groundAnchorB);
        float lengthA = this.uA.length();
        float lengthB = this.uB.length();
        if (lengthA > 10.0f * Settings.linearSlop) {
            this.uA.mulLocal(1.0f / lengthA);
        } else {
            this.uA.setZero();
        }
        if (lengthB > 10.0f * Settings.linearSlop) {
            this.uB.mulLocal(1.0f / lengthB);
        } else {
            this.uB.setZero();
        }
        float ruA = Vec2.cross(this.rA, this.uA);
        float ruB = Vec2.cross(this.rB, this.uB);
        float mA = this.invMassA + this.invIA * ruA * ruA;
        float mB = this.invMassB + this.invIB * ruB * ruB;
        this.mass = mA + this.ratio * this.ratio * mB;
        if (this.mass > 0.0f) {
            this.mass = 1.0f / this.mass;
        }
        if (data.step.warmStarting) {
            this.impulse *= data.step.dtRatio;
            Vec2 PA = this.pool.popVec2();
            Vec2 PB = this.pool.popVec2();
            PA.set(this.uA).mulLocal(-this.impulse);
            PB.set(this.uB).mulLocal(-this.ratio * this.impulse);
            vA.x += this.invMassA * PA.x;
            vA.y += this.invMassA * PA.y;
            wA += this.invIA * Vec2.cross(this.rA, PA);
            vB.x += this.invMassB * PB.x;
            vB.y += this.invMassB * PB.y;
            wB += this.invIB * Vec2.cross(this.rB, PB);
            this.pool.pushVec2(2);
        } else {
            this.impulse = 0.0f;
        }
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        this.pool.pushVec2(1);
        this.pool.pushRot(2);
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Vec2 vpA = this.pool.popVec2();
        Vec2 vpB = this.pool.popVec2();
        Vec2 PA = this.pool.popVec2();
        Vec2 PB = this.pool.popVec2();
        Vec2.crossToOutUnsafe(wA, this.rA, vpA);
        vpA.addLocal(vA);
        Vec2.crossToOutUnsafe(wB, this.rB, vpB);
        vpB.addLocal(vB);
        float Cdot = -Vec2.dot(this.uA, vpA) - this.ratio * Vec2.dot(this.uB, vpB);
        float impulse = -this.mass * Cdot;
        this.impulse += impulse;
        PA.set(this.uA).mulLocal(-impulse);
        PB.set(this.uB).mulLocal(-this.ratio * impulse);
        vA.x += this.invMassA * PA.x;
        vA.y += this.invMassA * PA.y;
        vB.x += this.invMassB * PB.x;
        vB.y += this.invMassB * PB.y;
        data.velocities[this.indexA].w = wA += this.invIA * Vec2.cross(this.rA, PA);
        data.velocities[this.indexB].w = wB += this.invIB * Vec2.cross(this.rB, PB);
        this.pool.pushVec2(4);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        Vec2 uA = this.pool.popVec2();
        Vec2 uB = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        Vec2 PA = this.pool.popVec2();
        Vec2 PB = this.pool.popVec2();
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), rB);
        uA.set(cA).addLocal(rA).subLocal(this.groundAnchorA);
        uB.set(cB).addLocal(rB).subLocal(this.groundAnchorB);
        float lengthA = uA.length();
        float lengthB = uB.length();
        if (lengthA > 10.0f * Settings.linearSlop) {
            uA.mulLocal(1.0f / lengthA);
        } else {
            uA.setZero();
        }
        if (lengthB > 10.0f * Settings.linearSlop) {
            uB.mulLocal(1.0f / lengthB);
        } else {
            uB.setZero();
        }
        float ruA = Vec2.cross(rA, uA);
        float ruB = Vec2.cross(rB, uB);
        float mA = this.invMassA + this.invIA * ruA * ruA;
        float mB = this.invMassB + this.invIB * ruB * ruB;
        float mass = mA + this.ratio * this.ratio * mB;
        if (mass > 0.0f) {
            mass = 1.0f / mass;
        }
        float C = this.constant - lengthA - this.ratio * lengthB;
        float linearError = MathUtils.abs(C);
        float impulse = -mass * C;
        PA.set(uA).mulLocal(-impulse);
        PB.set(uB).mulLocal(-this.ratio * impulse);
        cA.x += this.invMassA * PA.x;
        cA.y += this.invMassA * PA.y;
        cB.x += this.invMassB * PB.x;
        cB.y += this.invMassB * PB.y;
        data.positions[this.indexA].a = aA += this.invIA * Vec2.cross(rA, PA);
        data.positions[this.indexB].a = aB += this.invIB * Vec2.cross(rB, PB);
        this.pool.pushRot(2);
        this.pool.pushVec2(7);
        return linearError < Settings.linearSlop;
    }
}

