/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.LimitState;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RopeJointDef;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class RopeJoint
extends Joint {
    private final Vec2 localAnchorA = new Vec2();
    private final Vec2 localAnchorB = new Vec2();
    private float maxLength;
    private float length;
    private float impulse;
    private int indexA;
    private int indexB;
    private final Vec2 u = new Vec2();
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 localCenterA = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private float invMassA;
    private float invMassB;
    private float invIA;
    private float invIB;
    private float mass;
    private LimitState state;

    protected RopeJoint(IWorldPool worldPool, RopeJointDef def) {
        super(worldPool, def);
        this.localAnchorA.set(def.localAnchorA);
        this.localAnchorB.set(def.localAnchorB);
        this.maxLength = def.maxLength;
        this.mass = 0.0f;
        this.impulse = 0.0f;
        this.state = LimitState.INACTIVE;
        this.length = 0.0f;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.localCenterA.set(this.bodyA.sweep.localCenter);
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassA = this.bodyA.invMass;
        this.invMassB = this.bodyB.invMass;
        this.invIA = this.bodyA.invI;
        this.invIB = this.bodyB.invI;
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), this.rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), this.rB);
        this.u.set(cB).addLocal(this.rB).subLocal(cA).subLocal(this.rA);
        this.length = this.u.length();
        float C = this.length - this.maxLength;
        this.state = C > 0.0f ? LimitState.AT_UPPER : LimitState.INACTIVE;
        if (!(this.length > Settings.linearSlop)) {
            this.u.setZero();
            this.mass = 0.0f;
            this.impulse = 0.0f;
            this.pool.pushRot(2);
            this.pool.pushVec2(1);
            return;
        }
        this.u.mulLocal(1.0f / this.length);
        float crA = Vec2.cross(this.rA, this.u);
        float crB = Vec2.cross(this.rB, this.u);
        float invMass = this.invMassA + this.invIA * crA * crA + this.invMassB + this.invIB * crB * crB;
        float f = this.mass = invMass != 0.0f ? 1.0f / invMass : 0.0f;
        if (data.step.warmStarting) {
            this.impulse *= data.step.dtRatio;
            float Px = this.impulse * this.u.x;
            float Py = this.impulse * this.u.y;
            vA.x -= this.invMassA * Px;
            vA.y -= this.invMassA * Py;
            wA -= this.invIA * (this.rA.x * Py - this.rA.y * Px);
            vB.x += this.invMassB * Px;
            vB.y += this.invMassB * Py;
            wB += this.invIB * (this.rB.x * Py - this.rB.y * Px);
        } else {
            this.impulse = 0.0f;
        }
        this.pool.pushRot(2);
        this.pool.pushVec2(1);
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Vec2 vpA = this.pool.popVec2();
        Vec2 vpB = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        Vec2.crossToOutUnsafe(wA, this.rA, vpA);
        vpA.addLocal(vA);
        Vec2.crossToOutUnsafe(wB, this.rB, vpB);
        vpB.addLocal(vB);
        float C = this.length - this.maxLength;
        float Cdot = Vec2.dot(this.u, temp.set(vpB).subLocal(vpA));
        if (C < 0.0f) {
            Cdot += data.step.inv_dt * C;
        }
        float impulse = -this.mass * Cdot;
        float oldImpulse = this.impulse;
        this.impulse = MathUtils.min(0.0f, this.impulse + impulse);
        impulse = this.impulse - oldImpulse;
        float Px = impulse * this.u.x;
        float Py = impulse * this.u.y;
        vA.x -= this.invMassA * Px;
        vA.y -= this.invMassA * Py;
        vB.x += this.invMassB * Px;
        vB.y += this.invMassB * Py;
        this.pool.pushVec2(3);
        data.velocities[this.indexA].w = wA -= this.invIA * (this.rA.x * Py - this.rA.y * Px);
        data.velocities[this.indexB].w = wB += this.invIB * (this.rB.x * Py - this.rB.y * Px);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 u = this.pool.popVec2();
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), rB);
        u.set(cB).addLocal(rB).subLocal(cA).subLocal(rA);
        float length = u.normalize();
        float C = length - this.maxLength;
        C = MathUtils.clamp(C, 0.0f, Settings.maxLinearCorrection);
        float impulse = -this.mass * C;
        float Px = impulse * u.x;
        float Py = impulse * u.y;
        cA.x -= this.invMassA * Px;
        cA.y -= this.invMassA * Py;
        cB.x += this.invMassB * Px;
        cB.y += this.invMassB * Py;
        this.pool.pushRot(2);
        this.pool.pushVec2(4);
        data.positions[this.indexA].a = aA -= this.invIA * (rA.x * Py - rA.y * Px);
        data.positions[this.indexB].a = aB += this.invIB * (rB.x * Py - rB.y * Px);
        return length - this.maxLength < Settings.linearSlop;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.bodyA.getWorldPointToOut(this.localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        argOut.set(this.u).mulLocal(invDt).mulLocal(this.impulse);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return 0.0f;
    }

    public Vec2 getLocalAnchorA() {
        return this.localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.localAnchorB;
    }

    public float getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(float maxLength) {
        this.maxLength = maxLength;
    }

    public LimitState getLimitState() {
        return this.state;
    }
}

