/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.util.FileUtil;
import de.pirckheimer_gymnasium.engine_pi.util.ImageUtil;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.nio.file.Path;

public class ImageFontGlyph {
    char glyph;
    BufferedImage image;
    String filename;

    public ImageFontGlyph(Path path) {
        this.filename = FileUtil.getFileName(path);
        try {
            this.image = (BufferedImage)Resources.IMAGES.get(path.toUri().toURL());
            this.image = ImageUtil.addAlphaChannel(this.image);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (this.filename.length() == 1) {
            this.glyph = this.filename.charAt(0);
        }
    }

    public char getGlyph() {
        return this.glyph;
    }

    public String getContent() {
        return String.valueOf(this.glyph);
    }

    public void setGlyph(char glyph) {
        this.glyph = glyph;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getUnicodeName() {
        return this.filename.substring(5).replace("-", " ").toUpperCase();
    }

    public String getHexNumber() {
        return this.filename.substring(0, 4).toUpperCase();
    }
}

