/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.actor.Joint;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;

public final class RevoluteJoint
extends Joint<de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint> {
    private double lowerLimit;
    private double upperLimit;
    private boolean motorEnabled;
    private boolean limitEnabled;
    private double motorSpeed;
    private double maximumMotorTorque;

    @API
    public void setMaximumMotorTorque(double maximumMotorTorque) {
        this.maximumMotorTorque = maximumMotorTorque;
        this.motorEnabled = true;
        de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint joint = (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint)this.getJoint();
        if (joint != null) {
            joint.setMaxMotorTorque((float)maximumMotorTorque);
            joint.enableMotor(true);
        }
    }

    @API
    public double getMaximumMotorTorque() {
        return this.maximumMotorTorque;
    }

    @API
    public double getLowerLimit() {
        return this.lowerLimit;
    }

    @API
    public void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
        this.limitEnabled = true;
        de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint joint = (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint)this.getJoint();
        if (joint != null) {
            joint.setLimits((float)lowerLimit, (float)this.upperLimit);
            joint.enableLimit(true);
        }
    }

    @API
    public double getUpperLimit() {
        return this.upperLimit;
    }

    @API
    public void setUpperLimit(double upperLimit) {
        this.upperLimit = upperLimit;
        this.limitEnabled = true;
        de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint joint = (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint)this.getJoint();
        if (joint != null) {
            joint.setLimits((float)this.lowerLimit, (float)upperLimit);
            joint.enableLimit(true);
        }
    }

    @API
    public void setLimits(double lowerLimit, double upperLimit) {
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.limitEnabled = true;
        de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint joint = (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint)this.getJoint();
        if (joint != null) {
            joint.setLimits((float)lowerLimit, (float)upperLimit);
            joint.enableLimit(true);
        }
    }

    @API
    public double getMotorSpeed() {
        de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint joint = (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint)this.getJoint();
        if (joint != null) {
            return Math.toDegrees(joint.getMotorSpeed()) / 360.0;
        }
        return this.motorSpeed;
    }

    @API
    public void setMotorSpeed(double motorSpeed) {
        this.motorSpeed = motorSpeed;
        this.motorEnabled = true;
        de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint joint = (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint)this.getJoint();
        if (joint != null) {
            joint.setMotorSpeed((float)Math.toRadians(motorSpeed * 360.0));
            joint.enableMotor(true);
        }
    }

    @API
    public boolean isMotorEnabled() {
        return this.motorEnabled;
    }

    @API
    public void setMotorEnabled(boolean motorEnabled) {
        this.motorEnabled = motorEnabled;
        de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint joint = (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint)this.getJoint();
        if (joint != null) {
            joint.enableMotor(motorEnabled);
        }
    }

    @API
    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    @API
    public void setLimitEnabled(boolean limitEnabled) {
        this.limitEnabled = limitEnabled;
        de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint joint = (de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint)this.getJoint();
        if (joint != null) {
            joint.enableMotor(limitEnabled);
        }
    }

    @Override
    protected void updateCustomProperties(de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint joint) {
        joint.setMotorSpeed((float)Math.toRadians(this.motorSpeed * 360.0));
        joint.setMaxMotorTorque((float)this.maximumMotorTorque);
        joint.setLimits((float)this.lowerLimit, (float)this.upperLimit);
        joint.enableLimit(this.limitEnabled);
        joint.enableMotor(this.motorEnabled);
    }
}

