/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.debug;

import de.pirckheimer_gymnasium.engine_pi.Camera;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.debug.DebugConfiguration;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public final class CoordinateSystemDrawer {
    private static final int GRID_SIZE_IN_PIXELS = 160;
    private static final int GRID_SIZE_METER_LIMIT = 100000;
    private static final int DEBUG_TEXT_SIZE = 12;
    private static final Font FONT = new Font("Monospaced", 0, 12);
    private static final Color COLOR = new Color(255, 255, 255, 150);
    private static final int LABEL_SHIFT = 5;
    private final Graphics2D g;
    AffineTransform pre;
    private final int width;
    private final int height;
    private final Vector center;
    private final double pixelPerMeter;
    private final int gridSizeInMeters;
    private final double gridSizeInPixels;
    private final int maxWindowSideInPixels;
    private int startX;
    private int stopX;
    private int startY;
    private int stopY;

    public CoordinateSystemDrawer(Graphics2D g, Scene scene, int width, int height) {
        this.g = g;
        this.width = width;
        this.height = height;
        this.pre = g.getTransform();
        Camera camera = scene.getCamera();
        this.center = camera.getCenter();
        double rotation = -camera.getRotation();
        g.setClip(0, 0, width, height);
        g.translate(width / 2, height / 2);
        this.pixelPerMeter = camera.getMeter();
        g.rotate(Math.toRadians(rotation), 0.0, 0.0);
        g.translate(-this.center.getX() * this.pixelPerMeter, this.center.getY() * this.pixelPerMeter);
        this.gridSizeInMeters = DebugConfiguration.coordinateSystemLinesEveryNMeter > 0 ? DebugConfiguration.coordinateSystemLinesEveryNMeter : (int)Math.round(160.0 / this.pixelPerMeter);
        this.gridSizeInPixels = (double)this.gridSizeInMeters * this.pixelPerMeter;
        this.maxWindowSideInPixels = Math.max(width, height);
    }

    private double getWidthInMeter() {
        return (double)this.width / this.pixelPerMeter;
    }

    private double getWidthInMeter(double factor) {
        return this.getWidthInMeter() * factor;
    }

    private double getHalfWidthInMeter() {
        return this.getWidthInMeter() / 2.0;
    }

    private double getHeightInMeter() {
        return (double)this.height / this.pixelPerMeter;
    }

    private double getHeightInMeter(double factor) {
        return this.getHeightInMeter() * factor;
    }

    private double getHalfHeightInMeter() {
        return this.getHeightInMeter() / 2.0;
    }

    private int getLineThickness(int value) {
        return value == 0 ? 3 : 1;
    }

    private void drawHorizontalLines() {
        for (int y = this.startY; y <= this.stopY; y += this.gridSizeInMeters) {
            this.g.fillRect((int)((double)(this.startX - 1) * this.pixelPerMeter), (int)((double)y * this.pixelPerMeter - 1.0), (int)((double)this.maxWindowSideInPixels + 3.0 * this.gridSizeInPixels), this.getLineThickness(y));
        }
    }

    private void drawVerticalLines() {
        for (int x = this.startX; x <= this.stopX; x += this.gridSizeInMeters) {
            this.g.fillRect((int)((double)x * this.pixelPerMeter) - 1, (int)((double)(this.startY - 1) * this.pixelPerMeter), this.getLineThickness(x), (int)((double)this.maxWindowSideInPixels + 3.0 * this.gridSizeInPixels));
        }
    }

    private int calculateStartLinePosition(double cameraPosition) {
        int start = (int)(cameraPosition - (double)this.maxWindowSideInPixels / 2.0 / this.pixelPerMeter);
        start -= start % this.gridSizeInMeters + this.gridSizeInMeters;
        return start;
    }

    private int calculateStopLinePosition(int start) {
        return (int)((double)start + (double)this.maxWindowSideInPixels / this.pixelPerMeter + (double)(this.gridSizeInMeters * 2));
    }

    private void drawCoordinateLabels() {
        for (int x = this.startX; x <= this.stopX; x += this.gridSizeInMeters) {
            for (int y = this.startY; y <= this.stopY; y += this.gridSizeInMeters) {
                this.g.drawString(x + "|" + -y, (int)((double)x * this.pixelPerMeter + 5.0), (int)((double)y * this.pixelPerMeter - 5.0));
            }
        }
    }

    private void drawOneLineVerticalCoordinateLabels(double x) {
        for (int y = this.startY; y <= this.stopY; y += this.gridSizeInMeters) {
            this.g.drawString("" + -y, (int)(x * this.pixelPerMeter + 5.0), (int)((double)y * this.pixelPerMeter - 5.0));
        }
    }

    private void drawVerticalCoordinateLabels() {
        this.drawOneLineVerticalCoordinateLabels(this.center.getX() - this.getHalfWidthInMeter());
        this.drawOneLineVerticalCoordinateLabels(0.0);
        this.drawOneLineVerticalCoordinateLabels(this.center.getX() + this.getHalfWidthInMeter() - this.getWidthInMeter(0.04));
    }

    private void drawOneLineHorizontalCoordinateLabels(double y) {
        for (int x = this.startX; x <= this.stopX; x += this.gridSizeInMeters) {
            this.g.drawString("" + x, (int)((double)x * this.pixelPerMeter + 5.0), (int)(-1.0 * y * this.pixelPerMeter - 5.0));
        }
    }

    private void drawHorizontalCoordinateLabels() {
        this.drawOneLineHorizontalCoordinateLabels(this.center.getY() - this.getHalfHeightInMeter() + this.getHeightInMeter(0.02));
        this.drawOneLineHorizontalCoordinateLabels(0.0);
        this.drawOneLineHorizontalCoordinateLabels(this.center.getY() + (this.getHalfHeightInMeter() - this.getHeightInMeter(0.04)));
    }

    @Internal
    public void draw() {
        if (this.gridSizeInMeters > 0 && this.gridSizeInMeters < 100000) {
            this.startX = this.calculateStartLinePosition(this.center.getX());
            this.startY = this.calculateStartLinePosition(-1.0 * this.center.getY());
            this.stopX = this.calculateStopLinePosition(this.startX);
            this.stopY = this.calculateStopLinePosition(this.startY);
            this.g.setFont(FONT);
            this.g.setColor(COLOR);
            this.drawVerticalLines();
            this.drawHorizontalLines();
            this.drawHorizontalCoordinateLabels();
            this.drawVerticalCoordinateLabels();
            if (DebugConfiguration.coordinateSystemLabelsEachIntersectionGridLines) {
                this.drawCoordinateLabels();
            }
        }
        this.g.setTransform(this.pre);
    }

    public static void main(String[] args) {
        Game.debug();
        Scene scene = Game.start();
        scene.addKeyStrokeListener(event -> {
            switch (event.getKeyCode()) {
                case 49: {
                    DebugConfiguration.coordinateSystemLinesEveryNMeter = 1;
                    break;
                }
                case 50: {
                    DebugConfiguration.coordinateSystemLinesEveryNMeter = 2;
                    break;
                }
                case 51: {
                    DebugConfiguration.coordinateSystemLinesEveryNMeter = 3;
                    break;
                }
                case 52: {
                    DebugConfiguration.coordinateSystemLinesEveryNMeter = 4;
                    break;
                }
                case 53: {
                    DebugConfiguration.coordinateSystemLinesEveryNMeter = 5;
                }
            }
        });
    }
}

