/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.debug;

import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.util.Graphics2DUtil;
import java.awt.Color;
import java.awt.Graphics2D;

public final class InfoBoxDrawer {
    private static void drawGravityVector(Graphics2D g, int x, int y, Vector gravity, Color color) {
        Graphics2DUtil.drawArrowLine(g, x, y, x + (int)gravity.getX() * 2, y + (int)gravity.getY() * -2, 5, 5, color);
    }

    @Internal
    public static void draw(Graphics2D g, Scene scene, double frameDuration, int actorsCount) {
        Graphics2DUtil.drawTextBox(g, "FPS: " + String.valueOf(frameDuration == 0.0 ? "\u221e" : Long.valueOf(Math.round(1.0 / frameDuration))), 10, Resources.COLORS.getSafe("blue"));
        Graphics2DUtil.drawTextBox(g, "Actors: " + actorsCount, 50, Resources.COLORS.getSafe("green"));
        Vector gravity = scene.getGravity();
        Color gravityColor = Resources.colorScheme.getBluePurple();
        if (!gravity.isNull()) {
            Graphics2DUtil.drawTextBox(g, String.format("G(x,y): %.2f,%.2f", gravity.getX(), gravity.getY()), 90, gravityColor);
            InfoBoxDrawer.drawGravityVector(g, 40, 145, gravity, gravityColor);
        }
    }

    public static void main(String[] args) {
        Game.debug();
        Game.start();
    }
}

