/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.physics;

import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.CircleShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.PolygonShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Supplier;

public final class FixtureBuilder {
    public static FixtureData rectangle(double width, double height) {
        PolygonShape shape = new PolygonShape();
        shape.set(new Vec2[]{new Vec2(0.0f, 0.0f), new Vec2(0.0f, (float)height), new Vec2((float)width, (float)height), new Vec2((float)width, 0.0f)}, 4);
        shape.centroid.set(new Vec2((float)width / 2.0f, (float)height / 2.0f));
        return new FixtureData((Shape)shape);
    }

    public static FixtureData circle(double mx, double my, double radius) {
        CircleShape circleShape = new CircleShape();
        circleShape.p.set((float)mx, (float)my);
        circleShape.setRadius((float)radius);
        return new FixtureData((Shape)circleShape);
    }

    public static FixtureData polygon(Vector ... points) {
        if (points.length < 3) {
            throw new IllegalArgumentException("Eine polygonale Shape ben\u00f6tigt mindestens 3 Punkte.");
        }
        Vec2[] vec2s = new Vec2[points.length];
        for (int i = 0; i < points.length; ++i) {
            vec2s[i] = points[i].toVec2();
        }
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.set(vec2s, vec2s.length);
        return new FixtureData((Shape)polygonShape);
    }

    public static Shape axisParallelRectangular(double sx, double sy, double width, double height) {
        PolygonShape rectShape = new PolygonShape();
        rectShape.set(new Vec2[]{new Vec2((float)sx, (float)sy), new Vec2((float)sx, (float)(sy + height)), new Vec2((float)(sx + width), (float)(sy + height)), new Vec2((float)(sx + width), (float)sy)}, 4);
        return rectShape;
    }

    public static Supplier<List<FixtureData>> fromString(String code) {
        try (Scanner scanner = new Scanner(code.replace(" ", ""));){
            scanner.useDelimiter("&");
            ArrayList<FixtureData> shapeList = new ArrayList<FixtureData>();
            while (scanner.hasNext()) {
                String line = scanner.next();
                Shape shape = FixtureBuilder.fromLine(line);
                shapeList.add(new FixtureData(shape));
            }
            Supplier<List<FixtureData>> supplier = () -> shapeList;
            return supplier;
        }
    }

    private static Shape fromLine(String line) {
        char shape = line.charAt(0);
        line = line.substring(1);
        String[] split = line.split(",");
        switch (shape) {
            case 'R': {
                if (split.length != 4) {
                    throw new IllegalArgumentException("Fehlerhafte Eingabe");
                }
                double sx = Double.parseDouble(split[0]);
                double sy = Double.parseDouble(split[1]);
                double width = Double.parseDouble(split[2]);
                double height = Double.parseDouble(split[3]);
                return FixtureBuilder.axisParallelRectangular(sx, sy, width, height);
            }
            case 'P': {
                if (split.length % 2 != 0) {
                    throw new IllegalArgumentException("Fehlerhafte Eingabe");
                }
                Vec2[] polyPoints = new Vec2[split.length / 2];
                for (int i = 0; i < polyPoints.length; ++i) {
                    double px = Double.parseDouble(split[2 * i]);
                    double py = Double.parseDouble(split[2 * i + 1]);
                    polyPoints[i] = new Vec2((float)px, (float)py);
                }
                PolygonShape polygonShape = new PolygonShape();
                polygonShape.set(polyPoints, polyPoints.length);
                return polygonShape;
            }
            case 'C': {
                if (split.length != 3) {
                    throw new IllegalArgumentException("Fehlerhafte Eingabe");
                }
                CircleShape circleShape = new CircleShape();
                circleShape.p.set(Float.parseFloat(split[0]), Float.parseFloat(split[1]));
                circleShape.setRadius(Float.parseFloat(split[2]));
                return circleShape;
            }
        }
        throw new IllegalArgumentException("Fehlerhafte Eingabe!");
    }
}

