/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.resources;

import de.pirckheimer_gymnasium.engine_pi.resources.Container;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoadException;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoader;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceManipulator;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourcesContainerClearedListener;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourcesContainerListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class ResourcesContainer<T>
implements Container<T> {
    private static final ExecutorService ASYNC_POOL = Executors.newWorkStealingPool();
    private final Map<String, T> resources = new ConcurrentHashMap<String, T>();
    private final Map<String, String> aliases = new ConcurrentHashMap<String, String>();
    private final List<ResourcesContainerListener<T>> listeners = new CopyOnWriteArrayList<ResourcesContainerListener<T>>();
    private final List<ResourcesContainerClearedListener> clearedListeners = new CopyOnWriteArrayList<ResourcesContainerClearedListener>();
    private ResourceManipulator<T> manipulator;

    public ResourcesContainerListener<T> addContainerListener(ResourcesContainerListener<T> listener) {
        this.listeners.add(listener);
        return listener;
    }

    public void removeContainerListener(ResourcesContainerListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void addClearedListener(ResourcesContainerClearedListener listener) {
        this.clearedListeners.add(listener);
    }

    public void removeClearedListener(ResourcesContainerClearedListener listener) {
        this.clearedListeners.remove(listener);
    }

    public void addManipulator(ResourceManipulator<T> manipulator) {
        this.manipulator = manipulator;
    }

    public void removeManipulator() {
        this.manipulator = null;
    }

    @Override
    public T add(String name, T resource) {
        T r;
        if (this.manipulator != null && (r = this.manipulator.beforeAdd(name, resource)) != null) {
            resource = r;
        }
        this.resources.put(name, resource);
        for (ResourcesContainerListener<T> listener : this.listeners) {
            listener.added(name, resource);
        }
        return resource;
    }

    public T add(URL name, T resource) {
        return this.add(name.toString(), resource);
    }

    @Override
    public void clear() {
        this.resources.clear();
        for (ResourcesContainerListener<T> listener : this.listeners) {
            listener.cleared();
        }
    }

    public boolean contains(String name) {
        return this.resources.containsKey(this.getIdentifier(name));
    }

    public boolean contains(URL name) {
        return this.contains(name.toString());
    }

    public boolean contains(T resource) {
        return this.resources.containsValue(resource);
    }

    @Override
    public int count() {
        return this.resources.size();
    }

    public Collection<T> get(Predicate<T> pred) {
        if (pred == null) {
            return new ArrayList();
        }
        return this.resources.values().stream().filter(pred).toList();
    }

    @Override
    public T get(String name) {
        return this.get(this.getIdentifier(name), false);
    }

    public T get(URL name) {
        return this.get(name, false);
    }

    public T get(String name, Supplier<? extends T> loadCallback) {
        Optional<T> opt = this.tryGet(name);
        if (opt.isPresent()) {
            return opt.get();
        }
        T resource = loadCallback.get();
        if (resource != null) {
            return this.add(name, resource);
        }
        return null;
    }

    public T get(URL name, Supplier<? extends T> loadCallback) {
        return this.get(name.toString(), loadCallback);
    }

    public T get(String name, boolean forceLoad) {
        if (name == null) {
            return null;
        }
        T resource = this.resources.get(name);
        if (forceLoad || resource == null) {
            resource = this.loadResource(name);
            if (resource == null) {
                return null;
            }
            return this.add(name, resource);
        }
        return resource;
    }

    public T get(URL name, boolean forceLoad) {
        return this.get(name.toString(), forceLoad);
    }

    public T[] getMultiple(String[] names) {
        Object[] resources = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            resources[i] = this.get(names[i]);
        }
        return resources;
    }

    public Future<T> getAsync(URL location) {
        return ASYNC_POOL.submit(() -> this.get(location));
    }

    public Future<T> getAsync(String name) {
        return this.getAsync(ResourceLoader.getLocation(this.getIdentifier(name)));
    }

    public Collection<T> getAll() {
        return this.resources.values();
    }

    public T remove(String name) {
        T removedResource = this.resources.remove(name);
        if (removedResource != null) {
            for (ResourcesContainerListener<T> listener : this.listeners) {
                listener.removed(name, removedResource);
            }
        }
        return removedResource;
    }

    public T remove(URL name) {
        return this.remove(name.toString());
    }

    public Optional<T> tryGet(String name) {
        if (this.contains(name)) {
            return Optional.of(this.get(name));
        }
        return Optional.empty();
    }

    public Optional<T> tryGet(URL name) {
        return this.tryGet(name.getPath());
    }

    protected abstract T load(URL var1) throws Exception;

    protected String getAlias(String name, T resource) {
        return null;
    }

    protected Map<String, T> getResources() {
        return this.resources;
    }

    protected T loadResource(String identifier) {
        T newResource;
        try {
            newResource = this.load(ResourceLoader.getLocation(identifier));
        }
        catch (Exception e) {
            throw new ResourceLoadException(e);
        }
        String alias = this.getAlias(identifier, newResource);
        if (alias != null) {
            this.aliases.put(alias, identifier);
        }
        return newResource;
    }

    private String getIdentifier(String name) {
        return this.aliases.getOrDefault(name, name);
    }
}

