/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi;

import de.pirckheimer_gymnasium.engine_pi.Bounds;
import de.pirckheimer_gymnasium.engine_pi.Game;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.debug.ToStringFormatter;
import java.awt.Point;

public final class Camera {
    public static final double DEFAULT_METER = 32.0;
    public static final double DEFAULT_ZOOM_FACTOR = 0.05;
    private Vector center;
    private Bounds bounds;
    private Actor focus = null;
    private Vector offset = Vector.NULL;
    private double meter = 32.0;
    private double rotation = 0.0;

    @Internal
    public Camera() {
        this.center = new Vector(0.0, 0.0);
    }

    @API
    public void setFocus(Actor focus) {
        this.focus = focus;
    }

    @API
    public void removeFocus() {
        this.focus = null;
    }

    @API
    public boolean hasFocus() {
        return this.focus != null;
    }

    @API
    public void setOffset(Vector offset) {
        this.offset = offset;
    }

    @API
    public Vector getOffset() {
        return this.offset;
    }

    @API
    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    @API
    public boolean hasBounds() {
        return this.bounds != null;
    }

    @API
    public void setMeter(double pixelCount) {
        if (pixelCount <= 0.0) {
            throw new IllegalArgumentException("Der Kamerazoom kann nicht kleiner oder gleich 0 sein.");
        }
        this.meter = pixelCount;
    }

    @API
    public void zoomIn(double factor) {
        this.meter += this.meter * factor;
    }

    @API
    public void zoomIn() {
        this.zoomIn(0.05);
    }

    @API
    public void zoomOut(double factor) {
        this.meter -= this.meter * factor;
    }

    @API
    public void zoomOut() {
        this.zoomOut(0.05);
    }

    @API
    public double getMeter() {
        if (Game.isPixelMultiplication()) {
            return this.meter * (double)Game.getPixelMultiplication();
        }
        return this.meter;
    }

    @API
    public void moveBy(Vector vector) {
        this.center = this.center.add(vector);
    }

    @API
    public void moveBy(double x, double y) {
        this.moveBy(new Vector(x, y));
    }

    @API
    public void moveTo(Vector vector) {
        this.center = vector;
    }

    @API
    public void moveTo(int x, int y) {
        this.moveTo(new Vector(x, y));
    }

    @API
    public void rotateBy(double angle) {
        this.rotation += angle;
        this.rotation %= 360.0;
    }

    @API
    public void rotateTo(double angle) {
        this.rotation = angle % 360.0;
    }

    @API
    public void setPostion(double x, double y) {
        this.setCenter(new Vector(x, y));
    }

    @API
    public void setCenter(double x, double y) {
        this.setCenter(new Vector(x, y));
    }

    @API
    public void setCenter(Vector position) {
        this.center = position;
    }

    @API
    public Vector getCenter() {
        return this.moveIntoBounds(this.center.add(this.offset));
    }

    @Internal
    public Point toScreenPixelLocation(Vector locationInWorld, double pixelPerMeter) {
        Vector cameraRelativeLocInPx = this.center.multiply(pixelPerMeter);
        Vector frameSize = Game.getWindowSize();
        return new Point((int)(frameSize.getX() / 2.0 + cameraRelativeLocInPx.getX()), (int)(frameSize.getY() / 2.0 + cameraRelativeLocInPx.getY()));
    }

    public void onFrameUpdate() {
        if (this.hasFocus()) {
            this.center = this.focus.getCenter();
        }
        this.center = this.moveIntoBounds(this.center);
    }

    public double getRotation() {
        return this.rotation;
    }

    private Vector moveIntoBounds(Vector position) {
        if (!this.hasBounds()) {
            return position;
        }
        double x = Math.max(this.bounds.x(), Math.min(position.getX(), this.bounds.x() + this.bounds.width()));
        double y = Math.max(this.bounds.y(), Math.min(position.getY(), this.bounds.y() + this.bounds.height()));
        return new Vector(x, y);
    }

    public String toString() {
        ToStringFormatter formatter = new ToStringFormatter("Camera");
        formatter.add("meter", this.meter);
        formatter.add("center", this.center);
        if (this.rotation != 0.0) {
            formatter.add("rotation", this.rotation);
        }
        if (this.focus != null) {
            formatter.add("focus", this.focus);
        }
        return formatter.format();
    }
}

