/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.collision;

import de.pirckheimer_gymnasium.jbox2d.collision.Distance;
import de.pirckheimer_gymnasium.jbox2d.collision.Type;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Sweep;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;

class SeparationFunction {
    public Distance.DistanceProxy proxyA;
    public Distance.DistanceProxy proxyB;
    public Type type;
    public final Vec2 localPoint = new Vec2();
    public final Vec2 axis = new Vec2();
    public Sweep sweepA;
    public Sweep sweepB;
    private final Vec2 localPointA = new Vec2();
    private final Vec2 localPointB = new Vec2();
    private final Vec2 pointA = new Vec2();
    private final Vec2 pointB = new Vec2();
    private final Vec2 localPointA1 = new Vec2();
    private final Vec2 localPointA2 = new Vec2();
    private final Vec2 normal = new Vec2();
    private final Vec2 localPointB1 = new Vec2();
    private final Vec2 localPointB2 = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Transform xfa = new Transform();
    private final Transform xfb = new Transform();
    private final Vec2 axisA = new Vec2();
    private final Vec2 axisB = new Vec2();

    SeparationFunction() {
    }

    public float initialize(Distance.SimplexCache cache, Distance.DistanceProxy proxyA, Sweep sweepA, Distance.DistanceProxy proxyB, Sweep sweepB, float t1) {
        this.proxyA = proxyA;
        this.proxyB = proxyB;
        int count = cache.count;
        assert (0 < count && count < 3);
        this.sweepA = sweepA;
        this.sweepB = sweepB;
        this.sweepA.getTransform(this.xfa, t1);
        this.sweepB.getTransform(this.xfb, t1);
        if (count == 1) {
            this.type = Type.POINTS;
            this.localPointA.set(this.proxyA.getVertex(cache.indexA[0]));
            this.localPointB.set(this.proxyB.getVertex(cache.indexB[0]));
            Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
            Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
            this.axis.set(this.pointB).subLocal(this.pointA);
            return this.axis.normalize();
        }
        if (cache.indexA[0] == cache.indexA[1]) {
            this.type = Type.FACE_B;
            this.localPointB1.set(this.proxyB.getVertex(cache.indexB[0]));
            this.localPointB2.set(this.proxyB.getVertex(cache.indexB[1]));
            this.temp.set(this.localPointB2).subLocal(this.localPointB1);
            Vec2.crossToOutUnsafe(this.temp, 1.0f, this.axis);
            this.axis.normalize();
            Rot.mulToOutUnsafe(this.xfb.q, this.axis, this.normal);
            this.localPoint.set(this.localPointB1).addLocal(this.localPointB2).mulLocal(0.5f);
            Transform.mulToOutUnsafe(this.xfb, this.localPoint, this.pointB);
            this.localPointA.set(proxyA.getVertex(cache.indexA[0]));
            Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
            this.temp.set(this.pointA).subLocal(this.pointB);
            float s = Vec2.dot(this.temp, this.normal);
            if (s < 0.0f) {
                this.axis.negateLocal();
                s = -s;
            }
            return s;
        }
        this.type = Type.FACE_A;
        this.localPointA1.set(this.proxyA.getVertex(cache.indexA[0]));
        this.localPointA2.set(this.proxyA.getVertex(cache.indexA[1]));
        this.temp.set(this.localPointA2).subLocal(this.localPointA1);
        Vec2.crossToOutUnsafe(this.temp, 1.0f, this.axis);
        this.axis.normalize();
        Rot.mulToOutUnsafe(this.xfa.q, this.axis, this.normal);
        this.localPoint.set(this.localPointA1).addLocal(this.localPointA2).mulLocal(0.5f);
        Transform.mulToOutUnsafe(this.xfa, this.localPoint, this.pointA);
        this.localPointB.set(this.proxyB.getVertex(cache.indexB[0]));
        Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
        this.temp.set(this.pointB).subLocal(this.pointA);
        float s = Vec2.dot(this.temp, this.normal);
        if (s < 0.0f) {
            this.axis.negateLocal();
            s = -s;
        }
        return s;
    }

    public float findMinSeparation(int[] indexes, float t) {
        this.sweepA.getTransform(this.xfa, t);
        this.sweepB.getTransform(this.xfb, t);
        switch (this.type) {
            case POINTS: {
                Rot.mulTransUnsafe(this.xfa.q, this.axis, this.axisA);
                Rot.mulTransUnsafe(this.xfb.q, this.axis.negateLocal(), this.axisB);
                this.axis.negateLocal();
                indexes[0] = this.proxyA.getSupport(this.axisA);
                indexes[1] = this.proxyB.getSupport(this.axisB);
                this.localPointA.set(this.proxyA.getVertex(indexes[0]));
                this.localPointB.set(this.proxyB.getVertex(indexes[1]));
                Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
                Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
                return Vec2.dot(this.pointB.subLocal(this.pointA), this.axis);
            }
            case FACE_A: {
                Rot.mulToOutUnsafe(this.xfa.q, this.axis, this.normal);
                Transform.mulToOutUnsafe(this.xfa, this.localPoint, this.pointA);
                Rot.mulTransUnsafe(this.xfb.q, this.normal.negateLocal(), this.axisB);
                this.normal.negateLocal();
                indexes[0] = -1;
                indexes[1] = this.proxyB.getSupport(this.axisB);
                this.localPointB.set(this.proxyB.getVertex(indexes[1]));
                Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
                return Vec2.dot(this.pointB.subLocal(this.pointA), this.normal);
            }
            case FACE_B: {
                Rot.mulToOutUnsafe(this.xfb.q, this.axis, this.normal);
                Transform.mulToOutUnsafe(this.xfb, this.localPoint, this.pointB);
                Rot.mulTransUnsafe(this.xfa.q, this.normal.negateLocal(), this.axisA);
                this.normal.negateLocal();
                indexes[1] = -1;
                indexes[0] = this.proxyA.getSupport(this.axisA);
                this.localPointA.set(this.proxyA.getVertex(indexes[0]));
                Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
                return Vec2.dot(this.pointA.subLocal(this.pointB), this.normal);
            }
        }
        assert (false);
        indexes[0] = -1;
        indexes[1] = -1;
        return 0.0f;
    }

    public float evaluate(int indexA, int indexB, float t) {
        this.sweepA.getTransform(this.xfa, t);
        this.sweepB.getTransform(this.xfb, t);
        switch (this.type) {
            case POINTS: {
                this.localPointA.set(this.proxyA.getVertex(indexA));
                this.localPointB.set(this.proxyB.getVertex(indexB));
                Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
                Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
                return Vec2.dot(this.pointB.subLocal(this.pointA), this.axis);
            }
            case FACE_A: {
                Rot.mulToOutUnsafe(this.xfa.q, this.axis, this.normal);
                Transform.mulToOutUnsafe(this.xfa, this.localPoint, this.pointA);
                this.localPointB.set(this.proxyB.getVertex(indexB));
                Transform.mulToOutUnsafe(this.xfb, this.localPointB, this.pointB);
                return Vec2.dot(this.pointB.subLocal(this.pointA), this.normal);
            }
            case FACE_B: {
                Rot.mulToOutUnsafe(this.xfb.q, this.axis, this.normal);
                Transform.mulToOutUnsafe(this.xfb, this.localPoint, this.pointB);
                this.localPointA.set(this.proxyA.getVertex(indexA));
                Transform.mulToOutUnsafe(this.xfa, this.localPointA, this.pointA);
                return Vec2.dot(this.pointA.subLocal(this.pointB), this.normal);
            }
        }
        assert (false);
        return 0.0f;
    }
}

