/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics;

import de.pirckheimer_gymnasium.jbox2d.callbacks.ContactImpulse;
import de.pirckheimer_gymnasium.jbox2d.callbacks.ContactListener;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Sweep;
import de.pirckheimer_gymnasium.jbox2d.common.Timer;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.BodyType;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Profile;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.TimeStep;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Contact;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactSolver;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.ContactVelocityConstraint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Position;
import de.pirckheimer_gymnasium.jbox2d.dynamics.contacts.Velocity;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;

public class Island {
    public ContactListener listener;
    public Body[] bodies;
    public Contact[] contacts;
    public Joint[] joints;
    public Position[] positions;
    public Velocity[] velocities;
    public int bodyCount;
    public int jointCount;
    public int contactCount;
    public int bodyCapacity;
    public int contactCapacity;
    public int jointCapacity;
    private final ContactSolver contactSolver = new ContactSolver();
    private final Timer timer = new Timer();
    private final SolverData solverData = new SolverData();
    private final ContactSolver.ContactSolverDef solverDef = new ContactSolver.ContactSolverDef();
    private final ContactSolver toiContactSolver = new ContactSolver();
    private final ContactSolver.ContactSolverDef toiSolverDef = new ContactSolver.ContactSolverDef();
    private final ContactImpulse impulse = new ContactImpulse();

    public void init(int bodyCapacity, int contactCapacity, int jointCapacity, ContactListener listener) {
        int i;
        Object[] old;
        this.bodyCapacity = bodyCapacity;
        this.contactCapacity = contactCapacity;
        this.jointCapacity = jointCapacity;
        this.bodyCount = 0;
        this.contactCount = 0;
        this.jointCount = 0;
        this.listener = listener;
        if (this.bodies == null || this.bodyCapacity > this.bodies.length) {
            this.bodies = new Body[this.bodyCapacity];
        }
        if (this.joints == null || this.jointCapacity > this.joints.length) {
            this.joints = new Joint[this.jointCapacity];
        }
        if (this.contacts == null || this.contactCapacity > this.contacts.length) {
            this.contacts = new Contact[this.contactCapacity];
        }
        if (this.velocities == null || this.bodyCapacity > this.velocities.length) {
            old = this.velocities == null ? new Velocity[]{} : this.velocities;
            this.velocities = new Velocity[this.bodyCapacity];
            System.arraycopy(old, 0, this.velocities, 0, old.length);
            for (i = old.length; i < this.velocities.length; ++i) {
                this.velocities[i] = new Velocity();
            }
        }
        if (this.positions == null || this.bodyCapacity > this.positions.length) {
            old = this.positions == null ? new Position[]{} : this.positions;
            this.positions = new Position[this.bodyCapacity];
            System.arraycopy(old, 0, this.positions, 0, old.length);
            for (i = old.length; i < this.positions.length; ++i) {
                this.positions[i] = new Position();
            }
        }
    }

    public void clear() {
        this.bodyCount = 0;
        this.contactCount = 0;
        this.jointCount = 0;
    }

    public void solve(Profile profile, TimeStep step, Vec2 gravity, boolean allowSleep) {
        int i;
        int i2;
        float h = step.dt;
        for (i2 = 0; i2 < this.bodyCount; ++i2) {
            Body b = this.bodies[i2];
            Sweep bmSweep = b.sweep;
            Vec2 c = bmSweep.c;
            float a = bmSweep.a;
            Vec2 v = b.linearVelocity;
            float w = b.angularVelocity;
            bmSweep.c0.set(bmSweep.c);
            bmSweep.a0 = bmSweep.a;
            if (b.type == BodyType.DYNAMIC) {
                v.x += h * (b.gravityScale * gravity.x + b.invMass * b.force.x);
                v.y += h * (b.gravityScale * gravity.y + b.invMass * b.force.y);
                w += h * b.invI * b.torque;
                v.x *= 1.0f / (1.0f + h * b.linearDamping);
                v.y *= 1.0f / (1.0f + h * b.linearDamping);
                w *= 1.0f / (1.0f + h * b.angularDamping);
            }
            this.positions[i2].c.x = c.x;
            this.positions[i2].c.y = c.y;
            this.positions[i2].a = a;
            this.velocities[i2].v.x = v.x;
            this.velocities[i2].v.y = v.y;
            this.velocities[i2].w = w;
        }
        this.timer.reset();
        this.solverData.step = step;
        this.solverData.positions = this.positions;
        this.solverData.velocities = this.velocities;
        this.solverDef.step = step;
        this.solverDef.contacts = this.contacts;
        this.solverDef.count = this.contactCount;
        this.solverDef.positions = this.positions;
        this.solverDef.velocities = this.velocities;
        this.contactSolver.init(this.solverDef);
        this.contactSolver.initializeVelocityConstraints();
        if (step.warmStarting) {
            this.contactSolver.warmStart();
        }
        for (i2 = 0; i2 < this.jointCount; ++i2) {
            this.joints[i2].initVelocityConstraints(this.solverData);
        }
        profile.solveInit.accum(this.timer.getMilliseconds());
        this.timer.reset();
        for (i2 = 0; i2 < step.velocityIterations; ++i2) {
            for (int j = 0; j < this.jointCount; ++j) {
                this.joints[j].solveVelocityConstraints(this.solverData);
            }
            this.contactSolver.solveVelocityConstraints();
        }
        this.contactSolver.storeImpulses();
        profile.solveVelocity.accum(this.timer.getMilliseconds());
        for (i2 = 0; i2 < this.bodyCount; ++i2) {
            float rotation;
            Vec2 c = this.positions[i2].c;
            float a = this.positions[i2].a;
            Vec2 v = this.velocities[i2].v;
            float w = this.velocities[i2].w;
            float translationx = v.x * h;
            float translationy = v.y * h;
            if (translationx * translationx + translationy * translationy > Settings.maxTranslationSquared) {
                float ratio = Settings.maxTranslation / MathUtils.sqrt(translationx * translationx + translationy * translationy);
                v.x *= ratio;
                v.y *= ratio;
            }
            if ((rotation = h * w) * rotation > Settings.maxRotationSquared) {
                float ratio = Settings.maxRotation / MathUtils.abs(rotation);
                w *= ratio;
            }
            c.x += h * v.x;
            c.y += h * v.y;
            this.positions[i2].a = a += h * w;
            this.velocities[i2].w = w;
        }
        this.timer.reset();
        boolean positionSolved = false;
        for (i = 0; i < step.positionIterations; ++i) {
            boolean contactsOkay = this.contactSolver.solvePositionConstraints();
            boolean jointsOkay = true;
            for (int j = 0; j < this.jointCount; ++j) {
                boolean jointOkay = this.joints[j].solvePositionConstraints(this.solverData);
                jointsOkay = jointsOkay && jointOkay;
            }
            if (!contactsOkay || !jointsOkay) continue;
            positionSolved = true;
            break;
        }
        for (i = 0; i < this.bodyCount; ++i) {
            Body body = this.bodies[i];
            body.sweep.c.x = this.positions[i].c.x;
            body.sweep.c.y = this.positions[i].c.y;
            body.sweep.a = this.positions[i].a;
            body.linearVelocity.x = this.velocities[i].v.x;
            body.linearVelocity.y = this.velocities[i].v.y;
            body.angularVelocity = this.velocities[i].w;
            body.synchronizeTransform();
        }
        profile.solvePosition.accum(this.timer.getMilliseconds());
        this.report(this.contactSolver.velocityConstraints);
        if (allowSleep) {
            int i3;
            float minSleepTime = Float.MAX_VALUE;
            float linTolSqr = Settings.linearSleepTolerance * Settings.linearSleepTolerance;
            float angTolSqr = Settings.angularSleepTolerance * Settings.angularSleepTolerance;
            for (i3 = 0; i3 < this.bodyCount; ++i3) {
                Body b = this.bodies[i3];
                if (b.getType() == BodyType.STATIC) continue;
                if ((b.flags & 4) == 0 || b.angularVelocity * b.angularVelocity > angTolSqr || Vec2.dot(b.linearVelocity, b.linearVelocity) > linTolSqr) {
                    b.sleepTime = 0.0f;
                    minSleepTime = 0.0f;
                    continue;
                }
                b.sleepTime += h;
                minSleepTime = MathUtils.min(minSleepTime, b.sleepTime);
            }
            if (minSleepTime >= Settings.timeToSleep && positionSolved) {
                for (i3 = 0; i3 < this.bodyCount; ++i3) {
                    Body b = this.bodies[i3];
                    b.setAwake(false);
                }
            }
        }
    }

    public void solveTOI(TimeStep subStep, int toiIndexA, int toiIndexB) {
        boolean contactsOkay;
        int i;
        assert (toiIndexA < this.bodyCount);
        assert (toiIndexB < this.bodyCount);
        for (i = 0; i < this.bodyCount; ++i) {
            this.positions[i].c.x = this.bodies[i].sweep.c.x;
            this.positions[i].c.y = this.bodies[i].sweep.c.y;
            this.positions[i].a = this.bodies[i].sweep.a;
            this.velocities[i].v.x = this.bodies[i].linearVelocity.x;
            this.velocities[i].v.y = this.bodies[i].linearVelocity.y;
            this.velocities[i].w = this.bodies[i].angularVelocity;
        }
        this.toiSolverDef.contacts = this.contacts;
        this.toiSolverDef.count = this.contactCount;
        this.toiSolverDef.step = subStep;
        this.toiSolverDef.positions = this.positions;
        this.toiSolverDef.velocities = this.velocities;
        this.toiContactSolver.init(this.toiSolverDef);
        for (i = 0; i < subStep.positionIterations && !(contactsOkay = this.toiContactSolver.solveTOIPositionConstraints(toiIndexA, toiIndexB)); ++i) {
        }
        this.bodies[toiIndexA].sweep.c0.x = this.positions[toiIndexA].c.x;
        this.bodies[toiIndexA].sweep.c0.y = this.positions[toiIndexA].c.y;
        this.bodies[toiIndexA].sweep.a0 = this.positions[toiIndexA].a;
        this.bodies[toiIndexB].sweep.c0.set(this.positions[toiIndexB].c);
        this.bodies[toiIndexB].sweep.a0 = this.positions[toiIndexB].a;
        this.toiContactSolver.initializeVelocityConstraints();
        for (i = 0; i < subStep.velocityIterations; ++i) {
            this.toiContactSolver.solveVelocityConstraints();
        }
        float h = subStep.dt;
        for (int i2 = 0; i2 < this.bodyCount; ++i2) {
            float rotation;
            Vec2 c = this.positions[i2].c;
            float a = this.positions[i2].a;
            Vec2 v = this.velocities[i2].v;
            float w = this.velocities[i2].w;
            float translationx = v.x * h;
            float translationy = v.y * h;
            if (translationx * translationx + translationy * translationy > Settings.maxTranslationSquared) {
                float ratio = Settings.maxTranslation / MathUtils.sqrt(translationx * translationx + translationy * translationy);
                v.mulLocal(ratio);
            }
            if ((rotation = h * w) * rotation > Settings.maxRotationSquared) {
                float ratio = Settings.maxRotation / MathUtils.abs(rotation);
                w *= ratio;
            }
            c.x += v.x * h;
            c.y += v.y * h;
            this.positions[i2].c.x = c.x;
            this.positions[i2].c.y = c.y;
            this.positions[i2].a = a += h * w;
            this.velocities[i2].v.x = v.x;
            this.velocities[i2].v.y = v.y;
            this.velocities[i2].w = w;
            Body body = this.bodies[i2];
            body.sweep.c.x = c.x;
            body.sweep.c.y = c.y;
            body.sweep.a = a;
            body.linearVelocity.x = v.x;
            body.linearVelocity.y = v.y;
            body.angularVelocity = w;
            body.synchronizeTransform();
        }
        this.report(this.toiContactSolver.velocityConstraints);
    }

    public void add(Body body) {
        assert (this.bodyCount < this.bodyCapacity);
        body.islandIndex = this.bodyCount;
        this.bodies[this.bodyCount] = body;
        ++this.bodyCount;
    }

    public void add(Contact contact) {
        assert (this.contactCount < this.contactCapacity);
        this.contacts[this.contactCount++] = contact;
    }

    public void add(Joint joint) {
        assert (this.jointCount < this.jointCapacity);
        this.joints[this.jointCount++] = joint;
    }

    public void report(ContactVelocityConstraint[] constraints) {
        if (this.listener == null) {
            return;
        }
        for (int i = 0; i < this.contactCount; ++i) {
            Contact c = this.contacts[i];
            ContactVelocityConstraint vc = constraints[i];
            this.impulse.count = vc.pointCount;
            for (int j = 0; j < vc.pointCount; ++j) {
                this.impulse.normalImpulses[j] = vc.points[j].normalImpulse;
                this.impulse.tangentImpulses[j] = vc.points[j].tangentImpulse;
            }
            this.listener.postSolve(c, this.impulse);
        }
    }
}

