/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.dynamics.Body;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.GearJointDef;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.JointType;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.PrismaticJoint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.RevoluteJoint;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class GearJoint
extends Joint {
    private final Joint joint1;
    private final Joint joint2;
    private final JointType typeA;
    private final JointType typeB;
    private final Body bodyC;
    private final Body bodyD;
    private final Vec2 localAnchorA = new Vec2();
    private final Vec2 localAnchorB = new Vec2();
    private final Vec2 localAnchorC = new Vec2();
    private final Vec2 localAnchorD = new Vec2();
    private final Vec2 localAxisC = new Vec2();
    private final Vec2 localAxisD = new Vec2();
    private final float referenceAngleA;
    private final float referenceAngleB;
    private final float constant;
    private float ratio;
    private float impulse;
    private int indexA;
    private int indexB;
    private int indexC;
    private int indexD;
    private final Vec2 lcA = new Vec2();
    private final Vec2 lcB = new Vec2();
    private final Vec2 lcC = new Vec2();
    private final Vec2 lcD = new Vec2();
    private float mA;
    private float mB;
    private float mC;
    private float mD;
    private float iA;
    private float iB;
    private float iC;
    private float iD;
    private final Vec2 JvAC = new Vec2();
    private final Vec2 JvBD = new Vec2();
    private float JwA;
    private float JwB;
    private float JwC;
    private float JwD;
    private float mass;

    protected GearJoint(IWorldPool argWorldPool, GearJointDef def) {
        super(argWorldPool, def);
        float coordinateB;
        float coordinateA;
        this.joint1 = def.joint1;
        this.joint2 = def.joint2;
        this.typeA = this.joint1.getType();
        this.typeB = this.joint2.getType();
        assert (this.typeA == JointType.REVOLUTE || this.typeA == JointType.PRISMATIC);
        assert (this.typeB == JointType.REVOLUTE || this.typeB == JointType.PRISMATIC);
        this.bodyC = this.joint1.getBodyA();
        this.bodyA = this.joint1.getBodyB();
        Transform xfA = this.bodyA.xf;
        float aA = this.bodyA.sweep.a;
        Transform xfC = this.bodyC.xf;
        float aC = this.bodyC.sweep.a;
        if (this.typeA == JointType.REVOLUTE) {
            RevoluteJoint revolute = (RevoluteJoint)def.joint1;
            this.localAnchorC.set(revolute.localAnchorA);
            this.localAnchorA.set(revolute.localAnchorB);
            this.referenceAngleA = revolute.referenceAngle;
            this.localAxisC.setZero();
            coordinateA = aA - aC - this.referenceAngleA;
        } else {
            Vec2 pA = this.pool.popVec2();
            Vec2 temp = this.pool.popVec2();
            PrismaticJoint prismatic = (PrismaticJoint)def.joint1;
            this.localAnchorC.set(prismatic.localAnchorA);
            this.localAnchorA.set(prismatic.localAnchorB);
            this.referenceAngleA = prismatic.referenceAngle;
            this.localAxisC.set(prismatic.localXAxisA);
            Rot.mulToOutUnsafe(xfA.q, this.localAnchorA, temp);
            temp.addLocal(xfA.p).subLocal(xfC.p);
            Rot.mulTransUnsafe(xfC.q, temp, pA);
            coordinateA = Vec2.dot(pA.subLocal(this.localAnchorC), this.localAxisC);
            this.pool.pushVec2(2);
        }
        this.bodyD = this.joint2.getBodyA();
        this.bodyB = this.joint2.getBodyB();
        Transform xfB = this.bodyB.xf;
        float aB = this.bodyB.sweep.a;
        Transform xfD = this.bodyD.xf;
        float aD = this.bodyD.sweep.a;
        if (this.typeB == JointType.REVOLUTE) {
            RevoluteJoint revolute = (RevoluteJoint)def.joint2;
            this.localAnchorD.set(revolute.localAnchorA);
            this.localAnchorB.set(revolute.localAnchorB);
            this.referenceAngleB = revolute.referenceAngle;
            this.localAxisD.setZero();
            coordinateB = aB - aD - this.referenceAngleB;
        } else {
            Vec2 pB = this.pool.popVec2();
            Vec2 temp = this.pool.popVec2();
            PrismaticJoint prismatic = (PrismaticJoint)def.joint2;
            this.localAnchorD.set(prismatic.localAnchorA);
            this.localAnchorB.set(prismatic.localAnchorB);
            this.referenceAngleB = prismatic.referenceAngle;
            this.localAxisD.set(prismatic.localXAxisA);
            Rot.mulToOutUnsafe(xfB.q, this.localAnchorB, temp);
            temp.addLocal(xfB.p).subLocal(xfD.p);
            Rot.mulTransUnsafe(xfD.q, temp, pB);
            coordinateB = Vec2.dot(pB.subLocal(this.localAnchorD), this.localAxisD);
            this.pool.pushVec2(2);
        }
        this.ratio = def.ratio;
        this.constant = coordinateA + this.ratio * coordinateB;
        this.impulse = 0.0f;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.bodyA.getWorldPointToOut(this.localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        argOut.set(this.JvAC).mulLocal(this.impulse);
        argOut.mulLocal(invDt);
    }

    @Override
    public float getReactionTorque(float invDt) {
        float L = this.impulse * this.JwA;
        return invDt * L;
    }

    public void setRatio(float argRatio) {
        this.ratio = argRatio;
    }

    public float getRatio() {
        return this.ratio;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.indexC = this.bodyC.islandIndex;
        this.indexD = this.bodyD.islandIndex;
        this.lcA.set(this.bodyA.sweep.localCenter);
        this.lcB.set(this.bodyB.sweep.localCenter);
        this.lcC.set(this.bodyC.sweep.localCenter);
        this.lcD.set(this.bodyD.sweep.localCenter);
        this.mA = this.bodyA.invMass;
        this.mB = this.bodyB.invMass;
        this.mC = this.bodyC.invMass;
        this.mD = this.bodyD.invMass;
        this.iA = this.bodyA.invI;
        this.iB = this.bodyB.invI;
        this.iC = this.bodyC.invI;
        this.iD = this.bodyD.invI;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        float aC = data.positions[this.indexC].a;
        Vec2 vC = data.velocities[this.indexC].v;
        float wC = data.velocities[this.indexC].w;
        float aD = data.positions[this.indexD].a;
        Vec2 vD = data.velocities[this.indexD].v;
        float wD = data.velocities[this.indexD].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Rot qC = this.pool.popRot();
        Rot qD = this.pool.popRot();
        qA.set(aA);
        qB.set(aB);
        qC.set(aC);
        qD.set(aD);
        this.mass = 0.0f;
        Vec2 temp = this.pool.popVec2();
        if (this.typeA == JointType.REVOLUTE) {
            this.JvAC.setZero();
            this.JwA = 1.0f;
            this.JwC = 1.0f;
            this.mass += this.iA + this.iC;
        } else {
            Vec2 rC = this.pool.popVec2();
            Vec2 rA = this.pool.popVec2();
            Rot.mulToOutUnsafe(qC, this.localAxisC, this.JvAC);
            Rot.mulToOutUnsafe(qC, temp.set(this.localAnchorC).subLocal(this.lcC), rC);
            Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.lcA), rA);
            this.JwC = Vec2.cross(rC, this.JvAC);
            this.JwA = Vec2.cross(rA, this.JvAC);
            this.mass += this.mC + this.mA + this.iC * this.JwC * this.JwC + this.iA * this.JwA * this.JwA;
            this.pool.pushVec2(2);
        }
        if (this.typeB == JointType.REVOLUTE) {
            this.JvBD.setZero();
            this.JwB = this.ratio;
            this.JwD = this.ratio;
            this.mass += this.ratio * this.ratio * (this.iB + this.iD);
        } else {
            Vec2 u = this.pool.popVec2();
            Vec2 rD = this.pool.popVec2();
            Vec2 rB = this.pool.popVec2();
            Rot.mulToOutUnsafe(qD, this.localAxisD, u);
            Rot.mulToOutUnsafe(qD, temp.set(this.localAnchorD).subLocal(this.lcD), rD);
            Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.lcB), rB);
            this.JvBD.set(u).mulLocal(this.ratio);
            this.JwD = this.ratio * Vec2.cross(rD, u);
            this.JwB = this.ratio * Vec2.cross(rB, u);
            this.mass += this.ratio * this.ratio * (this.mD + this.mB) + this.iD * this.JwD * this.JwD + this.iB * this.JwB * this.JwB;
            this.pool.pushVec2(3);
        }
        float f = this.mass = this.mass > 0.0f ? 1.0f / this.mass : 0.0f;
        if (data.step.warmStarting) {
            vA.x += this.mA * this.impulse * this.JvAC.x;
            vA.y += this.mA * this.impulse * this.JvAC.y;
            wA += this.iA * this.impulse * this.JwA;
            vB.x += this.mB * this.impulse * this.JvBD.x;
            vB.y += this.mB * this.impulse * this.JvBD.y;
            wB += this.iB * this.impulse * this.JwB;
            vC.x -= this.mC * this.impulse * this.JvAC.x;
            vC.y -= this.mC * this.impulse * this.JvAC.y;
            wC -= this.iC * this.impulse * this.JwC;
            vD.x -= this.mD * this.impulse * this.JvBD.x;
            vD.y -= this.mD * this.impulse * this.JvBD.y;
            wD -= this.iD * this.impulse * this.JwD;
        } else {
            this.impulse = 0.0f;
        }
        this.pool.pushVec2(1);
        this.pool.pushRot(4);
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        data.velocities[this.indexC].w = wC;
        data.velocities[this.indexD].w = wD;
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Vec2 vC = data.velocities[this.indexC].v;
        float wC = data.velocities[this.indexC].w;
        Vec2 vD = data.velocities[this.indexD].v;
        float wD = data.velocities[this.indexD].w;
        Vec2 temp1 = this.pool.popVec2();
        Vec2 temp2 = this.pool.popVec2();
        float Cdot = Vec2.dot(this.JvAC, temp1.set(vA).subLocal(vC)) + Vec2.dot(this.JvBD, temp2.set(vB).subLocal(vD));
        this.pool.pushVec2(2);
        float impulse = -this.mass * (Cdot += this.JwA * wA - this.JwC * wC + (this.JwB * wB - this.JwD * wD));
        this.impulse += impulse;
        vA.x += this.mA * impulse * this.JvAC.x;
        vA.y += this.mA * impulse * this.JvAC.y;
        wA += this.iA * impulse * this.JwA;
        vB.x += this.mB * impulse * this.JvBD.x;
        vB.y += this.mB * impulse * this.JvBD.y;
        wB += this.iB * impulse * this.JwB;
        vC.x -= this.mC * impulse * this.JvAC.x;
        vC.y -= this.mC * impulse * this.JvAC.y;
        vD.x -= this.mD * impulse * this.JvBD.x;
        vD.y -= this.mD * impulse * this.JvBD.y;
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        data.velocities[this.indexC].w = wC -= this.iC * impulse * this.JwC;
        data.velocities[this.indexD].w = wD -= this.iD * impulse * this.JwD;
    }

    public Joint getJoint1() {
        return this.joint1;
    }

    public Joint getJoint2() {
        return this.joint2;
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        float coordinateB;
        float JwD;
        float JwB;
        float coordinateA;
        float JwC;
        float JwA;
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Vec2 cC = data.positions[this.indexC].c;
        float aC = data.positions[this.indexC].a;
        Vec2 cD = data.positions[this.indexD].c;
        float aD = data.positions[this.indexD].a;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Rot qC = this.pool.popRot();
        Rot qD = this.pool.popRot();
        qA.set(aA);
        qB.set(aB);
        qC.set(aC);
        qD.set(aD);
        float linearError = 0.0f;
        Vec2 temp = this.pool.popVec2();
        Vec2 JvAC = this.pool.popVec2();
        Vec2 JvBD = this.pool.popVec2();
        float mass = 0.0f;
        if (this.typeA == JointType.REVOLUTE) {
            JvAC.setZero();
            JwA = 1.0f;
            JwC = 1.0f;
            mass += this.iA + this.iC;
            coordinateA = aA - aC - this.referenceAngleA;
        } else {
            Vec2 rC = this.pool.popVec2();
            Vec2 rA = this.pool.popVec2();
            Vec2 pC = this.pool.popVec2();
            Vec2 pA = this.pool.popVec2();
            Rot.mulToOutUnsafe(qC, this.localAxisC, JvAC);
            Rot.mulToOutUnsafe(qC, temp.set(this.localAnchorC).subLocal(this.lcC), rC);
            Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.lcA), rA);
            JwC = Vec2.cross(rC, JvAC);
            JwA = Vec2.cross(rA, JvAC);
            mass += this.mC + this.mA + this.iC * JwC * JwC + this.iA * JwA * JwA;
            pC.set(this.localAnchorC).subLocal(this.lcC);
            Rot.mulTransUnsafe(qC, temp.set(rA).addLocal(cA).subLocal(cC), pA);
            coordinateA = Vec2.dot(pA.subLocal(pC), this.localAxisC);
            this.pool.pushVec2(4);
        }
        if (this.typeB == JointType.REVOLUTE) {
            JvBD.setZero();
            JwB = this.ratio;
            JwD = this.ratio;
            mass += this.ratio * this.ratio * (this.iB + this.iD);
            coordinateB = aB - aD - this.referenceAngleB;
        } else {
            Vec2 u = this.pool.popVec2();
            Vec2 rD = this.pool.popVec2();
            Vec2 rB = this.pool.popVec2();
            Vec2 pD = this.pool.popVec2();
            Vec2 pB = this.pool.popVec2();
            Rot.mulToOutUnsafe(qD, this.localAxisD, u);
            Rot.mulToOutUnsafe(qD, temp.set(this.localAnchorD).subLocal(this.lcD), rD);
            Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.lcB), rB);
            JvBD.set(u).mulLocal(this.ratio);
            JwD = Vec2.cross(rD, u);
            JwB = Vec2.cross(rB, u);
            mass += this.ratio * this.ratio * (this.mD + this.mB) + this.iD * JwD * JwD + this.iB * JwB * JwB;
            pD.set(this.localAnchorD).subLocal(this.lcD);
            Rot.mulTransUnsafe(qD, temp.set(rB).addLocal(cB).subLocal(cD), pB);
            coordinateB = Vec2.dot(pB.subLocal(pD), this.localAxisD);
            this.pool.pushVec2(5);
        }
        float C = coordinateA + this.ratio * coordinateB - this.constant;
        float impulse = 0.0f;
        if (mass > 0.0f) {
            impulse = -C / mass;
        }
        this.pool.pushVec2(3);
        this.pool.pushRot(4);
        cA.x += this.mA * impulse * JvAC.x;
        cA.y += this.mA * impulse * JvAC.y;
        aA += this.iA * impulse * JwA;
        cB.x += this.mB * impulse * JvBD.x;
        cB.y += this.mB * impulse * JvBD.y;
        aB += this.iB * impulse * JwB;
        cC.x -= this.mC * impulse * JvAC.x;
        cC.y -= this.mC * impulse * JvAC.y;
        cD.x -= this.mD * impulse * JvBD.x;
        cD.y -= this.mD * impulse * JvBD.y;
        data.positions[this.indexA].a = aA;
        data.positions[this.indexB].a = aB;
        data.positions[this.indexC].a = aC -= this.iC * impulse * JwC;
        data.positions[this.indexD].a = aD -= this.iD * impulse * JwD;
        return linearError < Settings.linearSlop;
    }
}

