/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.actor.Geometry;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.CircleShape;
import de.pirckheimer_gymnasium.jbox2d.collision.shapes.Shape;
import java.awt.Graphics2D;

public class Circle
extends Geometry {
    private double diameter;

    public Circle() {
        this(1.0);
    }

    public Circle(double diameter) {
        super(() -> new FixtureData(Circle.createCircleShape(diameter)));
        this.diameter = diameter;
        this.setColor("blue");
    }

    @API
    public double getDiameter() {
        return this.diameter;
    }

    @API
    public double getRadius() {
        return this.diameter / 2.0;
    }

    @Override
    public void render(Graphics2D g, double pixelPerMeter) {
        g.setColor(this.getColor());
        g.fillOval(0, -((int)(this.diameter * pixelPerMeter)), (int)(this.diameter * pixelPerMeter), (int)(this.diameter * pixelPerMeter));
    }

    @API
    public void resetRadius(double radius) {
        this.diameter = 2.0 * radius;
        FixtureData[] fixtureData = this.getPhysicsHandler().getPhysicsData().generateFixtureData();
        FixtureData thatoneCircle = fixtureData[0];
        thatoneCircle.setShape(Circle.createCircleShape(this.diameter));
        this.setFixture(() -> thatoneCircle);
    }

    @Internal
    private static Shape createCircleShape(double diameter) {
        CircleShape shape = new CircleShape();
        shape.radius = (float)diameter / 2.0f;
        shape.p.set(shape.radius, shape.radius);
        return shape;
    }
}

