/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Scene;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Actable;
import de.pirckheimer_gymnasium.engine_pi.actor.Actor;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Group
implements Actable {
    private final List<Actor> actors;
    private Scene scene;

    public Group(Actor ... actors) {
        this.actors = new ArrayList<Actor>(Arrays.asList(actors));
    }

    public Group(Scene scene) {
        this(new Actor[0]);
        this.scene = scene;
    }

    public void addtoScene(Scene scene) {
        this.scene = scene;
        this.actors.forEach(actor -> scene.add((Actor)actor));
    }

    public void add(Actor ... actors) {
        this.actors.addAll(Arrays.asList(actors));
        if (this.scene != null) {
            this.actors.forEach(actor -> this.scene.add((Actor)actor));
        }
    }

    @Override
    @API
    public final void moveBy(Vector vector) {
        this.actors.forEach(actor -> actor.moveBy(vector));
    }

    @Override
    public final void moveBy(double dX, double dY) {
        this.moveBy(new Vector(dX, dY));
    }
}

