/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.dynamics.joints;

import de.pirckheimer_gymnasium.jbox2d.common.Mat33;
import de.pirckheimer_gymnasium.jbox2d.common.MathUtils;
import de.pirckheimer_gymnasium.jbox2d.common.Rot;
import de.pirckheimer_gymnasium.jbox2d.common.Settings;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.common.Vec3;
import de.pirckheimer_gymnasium.jbox2d.dynamics.SolverData;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.Joint;
import de.pirckheimer_gymnasium.jbox2d.dynamics.joints.WeldJointDef;
import de.pirckheimer_gymnasium.jbox2d.pooling.IWorldPool;

public class WeldJoint
extends Joint {
    private float frequencyHz;
    private float dampingRatio;
    private float bias;
    private final Vec2 localAnchorA;
    private final Vec2 localAnchorB;
    private final float referenceAngle;
    private float gamma;
    private final Vec3 impulse;
    private int indexA;
    private int indexB;
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();
    private final Vec2 localCenterA = new Vec2();
    private final Vec2 localCenterB = new Vec2();
    private float invMassA;
    private float invMassB;
    private float invIA;
    private float invIB;
    private final Mat33 mass = new Mat33();

    protected WeldJoint(IWorldPool argWorld, WeldJointDef def) {
        super(argWorld, def);
        this.localAnchorA = new Vec2(def.localAnchorA);
        this.localAnchorB = new Vec2(def.localAnchorB);
        this.referenceAngle = def.referenceAngle;
        this.frequencyHz = def.frequencyHz;
        this.dampingRatio = def.dampingRatio;
        this.impulse = new Vec3();
        this.impulse.setZero();
    }

    public float getReferenceAngle() {
        return this.referenceAngle;
    }

    public Vec2 getLocalAnchorA() {
        return this.localAnchorA;
    }

    public Vec2 getLocalAnchorB() {
        return this.localAnchorB;
    }

    public float getFrequency() {
        return this.frequencyHz;
    }

    public void setFrequency(float frequencyHz) {
        this.frequencyHz = frequencyHz;
    }

    public float getDampingRatio() {
        return this.dampingRatio;
    }

    public void setDampingRatio(float dampingRatio) {
        this.dampingRatio = dampingRatio;
    }

    @Override
    public void getAnchorA(Vec2 argOut) {
        this.bodyA.getWorldPointToOut(this.localAnchorA, argOut);
    }

    @Override
    public void getAnchorB(Vec2 argOut) {
        this.bodyB.getWorldPointToOut(this.localAnchorB, argOut);
    }

    @Override
    public void getReactionForce(float invDt, Vec2 argOut) {
        argOut.set(this.impulse.x, this.impulse.y);
        argOut.mulLocal(invDt);
    }

    @Override
    public float getReactionTorque(float invDt) {
        return invDt * this.impulse.z;
    }

    @Override
    public void initVelocityConstraints(SolverData data) {
        this.indexA = this.bodyA.islandIndex;
        this.indexB = this.bodyB.islandIndex;
        this.localCenterA.set(this.bodyA.sweep.localCenter);
        this.localCenterB.set(this.bodyB.sweep.localCenter);
        this.invMassA = this.bodyA.invMass;
        this.invMassB = this.bodyB.invMass;
        this.invIA = this.bodyA.invI;
        this.invIB = this.bodyB.invI;
        float aA = data.positions[this.indexA].a;
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        float aB = data.positions[this.indexB].a;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), this.rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), this.rB);
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Mat33 K = this.pool.popMat33();
        K.ex.x = mA + mB + this.rA.y * this.rA.y * iA + this.rB.y * this.rB.y * iB;
        K.ey.x = -this.rA.y * this.rA.x * iA - this.rB.y * this.rB.x * iB;
        K.ez.x = -this.rA.y * iA - this.rB.y * iB;
        K.ex.y = K.ey.x;
        K.ey.y = mA + mB + this.rA.x * this.rA.x * iA + this.rB.x * this.rB.x * iB;
        K.ez.y = this.rA.x * iA + this.rB.x * iB;
        K.ex.z = K.ez.x;
        K.ey.z = K.ez.y;
        K.ez.z = iA + iB;
        if (this.frequencyHz > 0.0f) {
            K.getInverse22(this.mass);
            float invM = iA + iB;
            float m = invM > 0.0f ? 1.0f / invM : 0.0f;
            float C = aB - aA - this.referenceAngle;
            float omega = (float)Math.PI * 2 * this.frequencyHz;
            float d = 2.0f * m * this.dampingRatio * omega;
            float k = m * omega * omega;
            float h = data.step.dt;
            this.gamma = h * (d + h * k);
            this.gamma = this.gamma != 0.0f ? 1.0f / this.gamma : 0.0f;
            this.bias = C * h * k * this.gamma;
            this.mass.ez.z = (invM += this.gamma) != 0.0f ? 1.0f / invM : 0.0f;
        } else {
            K.getSymInverse33(this.mass);
            this.gamma = 0.0f;
            this.bias = 0.0f;
        }
        if (data.step.warmStarting) {
            Vec2 P = this.pool.popVec2();
            this.impulse.mulLocal(data.step.dtRatio);
            P.set(this.impulse.x, this.impulse.y);
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * (Vec2.cross(this.rA, P) + this.impulse.z);
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * (Vec2.cross(this.rB, P) + this.impulse.z);
            this.pool.pushVec2(1);
        } else {
            this.impulse.setZero();
        }
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        this.pool.pushVec2(1);
        this.pool.pushRot(2);
        this.pool.pushMat33(1);
    }

    @Override
    public void solveVelocityConstraints(SolverData data) {
        Vec2 vA = data.velocities[this.indexA].v;
        float wA = data.velocities[this.indexA].w;
        Vec2 vB = data.velocities[this.indexB].v;
        float wB = data.velocities[this.indexB].w;
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Vec2 Cdot1 = this.pool.popVec2();
        Vec2 P = this.pool.popVec2();
        Vec2 temp = this.pool.popVec2();
        if (this.frequencyHz > 0.0f) {
            float Cdot2 = wB - wA;
            float impulse2 = -this.mass.ez.z * (Cdot2 + this.bias + this.gamma * this.impulse.z);
            this.impulse.z += impulse2;
            Vec2.crossToOutUnsafe(wB += iB * impulse2, this.rB, Cdot1);
            Vec2.crossToOutUnsafe(wA -= iA * impulse2, this.rA, temp);
            Cdot1.addLocal(vB).subLocal(vA).subLocal(temp);
            Mat33.mul22ToOutUnsafe(this.mass, Cdot1, P);
            P.negateLocal();
            this.impulse.x += P.x;
            this.impulse.y += P.y;
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * Vec2.cross(this.rA, P);
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * Vec2.cross(this.rB, P);
        } else {
            Vec2.crossToOutUnsafe(wA, this.rA, temp);
            Vec2.crossToOutUnsafe(wB, this.rB, Cdot1);
            Cdot1.addLocal(vB).subLocal(vA).subLocal(temp);
            float Cdot2 = wB - wA;
            Vec3 Cdot = this.pool.popVec3();
            Cdot.set(Cdot1.x, Cdot1.y, Cdot2);
            Vec3 impulse = this.pool.popVec3();
            Mat33.mulToOutUnsafe(this.mass, Cdot, impulse);
            impulse.negateLocal();
            this.impulse.addLocal(impulse);
            P.set(impulse.x, impulse.y);
            vA.x -= mA * P.x;
            vA.y -= mA * P.y;
            wA -= iA * (Vec2.cross(this.rA, P) + impulse.z);
            vB.x += mB * P.x;
            vB.y += mB * P.y;
            wB += iB * (Vec2.cross(this.rB, P) + impulse.z);
            this.pool.pushVec3(2);
        }
        data.velocities[this.indexA].w = wA;
        data.velocities[this.indexB].w = wB;
        this.pool.pushVec2(3);
    }

    @Override
    public boolean solvePositionConstraints(SolverData data) {
        float angularError;
        float positionError;
        Vec2 cA = data.positions[this.indexA].c;
        float aA = data.positions[this.indexA].a;
        Vec2 cB = data.positions[this.indexB].c;
        float aB = data.positions[this.indexB].a;
        Rot qA = this.pool.popRot();
        Rot qB = this.pool.popRot();
        Vec2 temp = this.pool.popVec2();
        Vec2 rA = this.pool.popVec2();
        Vec2 rB = this.pool.popVec2();
        qA.set(aA);
        qB.set(aB);
        float mA = this.invMassA;
        float mB = this.invMassB;
        float iA = this.invIA;
        float iB = this.invIB;
        Rot.mulToOutUnsafe(qA, temp.set(this.localAnchorA).subLocal(this.localCenterA), rA);
        Rot.mulToOutUnsafe(qB, temp.set(this.localAnchorB).subLocal(this.localCenterB), rB);
        Mat33 K = this.pool.popMat33();
        Vec2 C1 = this.pool.popVec2();
        Vec2 P = this.pool.popVec2();
        K.ex.x = mA + mB + rA.y * rA.y * iA + rB.y * rB.y * iB;
        K.ey.x = -rA.y * rA.x * iA - rB.y * rB.x * iB;
        K.ez.x = -rA.y * iA - rB.y * iB;
        K.ex.y = K.ey.x;
        K.ey.y = mA + mB + rA.x * rA.x * iA + rB.x * rB.x * iB;
        K.ez.y = rA.x * iA + rB.x * iB;
        K.ex.z = K.ez.x;
        K.ey.z = K.ez.y;
        K.ez.z = iA + iB;
        if (this.frequencyHz > 0.0f) {
            C1.set(cB).addLocal(rB).subLocal(cA).subLocal(rA);
            positionError = C1.length();
            angularError = 0.0f;
            K.solve22ToOut(C1, P);
            P.negateLocal();
            cA.x -= mA * P.x;
            cA.y -= mA * P.y;
            aA -= iA * Vec2.cross(rA, P);
            cB.x += mB * P.x;
            cB.y += mB * P.y;
            aB += iB * Vec2.cross(rB, P);
        } else {
            C1.set(cB).addLocal(rB).subLocal(cA).subLocal(rA);
            float C2 = aB - aA - this.referenceAngle;
            positionError = C1.length();
            angularError = MathUtils.abs(C2);
            Vec3 C = this.pool.popVec3();
            Vec3 impulse = this.pool.popVec3();
            C.set(C1.x, C1.y, C2);
            K.solve33ToOut(C, impulse);
            impulse.negateLocal();
            P.set(impulse.x, impulse.y);
            cA.x -= mA * P.x;
            cA.y -= mA * P.y;
            aA -= iA * (Vec2.cross(rA, P) + impulse.z);
            cB.x += mB * P.x;
            cB.y += mB * P.y;
            aB += iB * (Vec2.cross(rB, P) + impulse.z);
            this.pool.pushVec3(2);
        }
        data.positions[this.indexA].a = aA;
        data.positions[this.indexB].a = aB;
        this.pool.pushVec2(5);
        this.pool.pushRot(2);
        this.pool.pushMat33(1);
        return positionError <= Settings.linearSlop && angularError <= Settings.angularSlop;
    }
}

