/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.jbox2d.particle;

import de.pirckheimer_gymnasium.jbox2d.common.Transform;
import de.pirckheimer_gymnasium.jbox2d.common.Vec2;
import de.pirckheimer_gymnasium.jbox2d.particle.ParticleSystem;

public class ParticleGroup {
    ParticleSystem system;
    int firstIndex = 0;
    int lastIndex = 0;
    int groupFlags = 0;
    float strength = 1.0f;
    ParticleGroup prev;
    ParticleGroup next;
    int timestamp = -1;
    float mass = 0.0f;
    float inertia = 0.0f;
    final Vec2 center = new Vec2();
    final Vec2 linearVelocity = new Vec2();
    float angularVelocity = 0.0f;
    final Transform transform = new Transform();
    boolean destroyAutomatically;
    boolean toBeDestroyed;
    boolean toBeSplit;
    Object userData;

    public ParticleGroup() {
        this.transform.setIdentity();
        this.destroyAutomatically = true;
        this.toBeDestroyed = false;
        this.toBeSplit = false;
    }

    public ParticleGroup getNext() {
        return this.next;
    }

    public int getParticleCount() {
        return this.lastIndex - this.firstIndex;
    }

    public int getBufferIndex() {
        return this.firstIndex;
    }

    public int getGroupFlags() {
        return this.groupFlags;
    }

    public void setGroupFlags(int flags) {
        this.groupFlags = flags;
    }

    public float getMass() {
        this.updateStatistics();
        return this.mass;
    }

    public float getInertia() {
        this.updateStatistics();
        return this.inertia;
    }

    public Vec2 getCenter() {
        this.updateStatistics();
        return this.center;
    }

    public Vec2 getLinearVelocity() {
        this.updateStatistics();
        return this.linearVelocity;
    }

    public float getAngularVelocity() {
        this.updateStatistics();
        return this.angularVelocity;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Vec2 getPosition() {
        return this.transform.p;
    }

    public float getAngle() {
        return this.transform.q.getAngle();
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object data) {
        this.userData = data;
    }

    public void updateStatistics() {
        if (this.timestamp != this.system.timestamp) {
            Vec2 vel;
            Vec2 pos;
            int i;
            float m = this.system.getParticleMass();
            this.mass = 0.0f;
            this.center.setZero();
            this.linearVelocity.setZero();
            for (i = this.firstIndex; i < this.lastIndex; ++i) {
                this.mass += m;
                pos = ((Vec2[])this.system.positionBuffer.data)[i];
                this.center.x += m * pos.x;
                this.center.y += m * pos.y;
                vel = ((Vec2[])this.system.velocityBuffer.data)[i];
                this.linearVelocity.x += m * vel.x;
                this.linearVelocity.y += m * vel.y;
            }
            if (this.mass > 0.0f) {
                this.center.x *= 1.0f / this.mass;
                this.center.y *= 1.0f / this.mass;
                this.linearVelocity.x *= 1.0f / this.mass;
                this.linearVelocity.y *= 1.0f / this.mass;
            }
            this.inertia = 0.0f;
            this.angularVelocity = 0.0f;
            for (i = this.firstIndex; i < this.lastIndex; ++i) {
                pos = ((Vec2[])this.system.positionBuffer.data)[i];
                vel = ((Vec2[])this.system.velocityBuffer.data)[i];
                float px = pos.x - this.center.x;
                float py = pos.y - this.center.y;
                float vx = vel.x - this.linearVelocity.x;
                float vy = vel.y - this.linearVelocity.y;
                this.inertia += m * (px * px + py * py);
                this.angularVelocity += m * (px * vy - py * vx);
            }
            if (this.inertia > 0.0f) {
                this.angularVelocity *= 1.0f / this.inertia;
            }
            this.timestamp = this.system.timestamp;
        }
    }
}

