/**
 * <p>
 * Eine Variante der Engine <a href=
 * "https://informatikschulbuch.de/wp-content/daten/Informatik3/Vorlagen/Kapitel4/BlueJ_Java/GraphicsAndGames_BlueJ_Java.zip">GraphicsAndGames</a>
 * des Cornelsen-Verlag mit englischer API.
 * </p>
 *
 * <ul>
 * <li><a href=
 * "http://gng4java.informatikschulbuch.de/package-summary.html">Dokumentation
 * der Java-Variante der Graphics and Games-API als JavaDoc.</a></li>
 * <li><a href=
 * "https://informatikschulbuch.de/jahrgangsstufe-9-uebersicht/objektorientierte-modellierung-und-programmierung/">Website
 * der Buchautoren</a></li>
 * <li><a href=
 * "https://www.learnj.de/doku.php?id=api:documentation:gng:start">GamesAndGraphics
 * auf der online-IDE</a></li>
 * <li><a href="https://java.arrrg.de/">GamesAndGraphics im Browser auf
 * PurpleJ</a></li>
 * </ul>
 *
 * <p>
 * Die Koordinate (0|0) befindet sich im linken oberen Eck des Spielfelds.
 * Steigend (positive) y-Werte bewegen die Figur nach unten. X- und y-Werte sind
 * in der Einheit Pixel anzugeben. Die Zeichenfläche ist {@code 800x600} Pixel
 * groß.
 * </p>
 *
 * <p>
 * Das Paket stellt ein Fenster mit einer Malfläche zur Verfügung, auf der
 * Objekte der Klassen Rechteck, Kreis und Dreieck sowie Turtle dargestellt
 * werden können. Die Zeichenfläche wird beim ersten Anlegen eines
 * Zeichenobjekts automatisch nach dem Muster Singleton angelegt.
 * </p>
 *
 * <p>
 * Die Klassen dieses Pakets sind in vielen Aufgaben bzw. Projekten des
 * Cornelsen-Verlags mitgeliefert. Die Klasse Zelle findet sich nicht in den
 * Vorlagen des Verlags. Einige Klassen, Attribute, Konstrukturen und Methoden
 * mussten auf {@code public} gesetzt werden, damit sie von diesem Paket aus
 * verwendet werden können.
 * </p>
 *
 * <a href=
 * "https://informatikschulbuch.de/wp-content/daten/Informatik3/Vorlagen/Kapitel4/BlueJ_Java/GraphicsAndGames_BlueJ_Java.zip">GraphicsAndGames
 * auf informatikschulbuch.de</a>
 */
package de.pirckheimer_gymnasium.engine_pi.little_engine;
