/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.actor;

import de.pirckheimer_gymnasium.engine_pi.Resources;
import de.pirckheimer_gymnasium.engine_pi.Vector;
import de.pirckheimer_gymnasium.engine_pi.actor.Geometry;
import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.annotations.Internal;
import de.pirckheimer_gymnasium.engine_pi.debug.ToStringFormatter;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureBuilder;
import de.pirckheimer_gymnasium.engine_pi.physics.FixtureData;
import de.pirckheimer_gymnasium.engine_pi.util.FontMetrics;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class Text
extends Geometry {
    private static final int SIZE = 1000;
    private double height;
    private int fontStyle;
    private String content;
    private Font font;
    private transient int cachedDescent;
    private transient double cachedScaleFactor;

    @Internal
    private static FixtureData createShape(String content, double height, Font font) {
        Vector sizeInPixels = FontMetrics.getSize(content, font);
        return FixtureBuilder.rectangle(sizeInPixels.getX() * height / sizeInPixels.getY(), height);
    }

    @API
    public Text(String content) {
        this(content, 1.0);
    }

    @API
    public Text(String content, double height) {
        this(content, height, "SansSerif");
    }

    @API
    public Text(String content, double height, String fontName) {
        this(content, height, fontName, 0);
    }

    @API
    public Text(String content, double height, String fontName, int style) {
        super(() -> Text.createShape(content == null ? "" : content, height, Resources.FONTS.get(fontName).deriveFont(style, 1000.0f)));
        this.content = content == null ? "" : content;
        this.height = height;
        this.setStyle(style);
        this.setFont(fontName);
        this.setColor("black");
    }

    @API
    public Text setFont(Font font) {
        this.font = font.deriveFont(this.fontStyle, 1000.0f);
        this.update();
        return this;
    }

    @API
    public Text setFont(String fontName) {
        this.setFont(Resources.FONTS.get(fontName));
        return this;
    }

    @API
    public Font getFont() {
        return this.font;
    }

    @API
    public Text setContent(String content) {
        String normalizedContent = content;
        if (normalizedContent == null) {
            normalizedContent = "";
        }
        if (!this.content.equals(normalizedContent)) {
            this.content = normalizedContent;
            this.update();
        }
        return this;
    }

    @API
    public Text setContent(Object content) {
        this.setContent(String.valueOf(content));
        return this;
    }

    @API
    public String getContent() {
        return this.content;
    }

    @API
    public Text setStyle(int style) {
        if (style >= 0 && style <= 3 && style != this.fontStyle) {
            this.fontStyle = style;
            this.font = this.font.deriveFont(style, 1000.0f);
            this.update();
        }
        return this;
    }

    @API
    public int getStyle() {
        return this.fontStyle;
    }

    @API
    public Text setHeight(double height) {
        if (this.height != height) {
            this.height = height;
            this.update();
        }
        return this;
    }

    @API
    public double getHeight() {
        return this.height;
    }

    @API
    public double getWidth() {
        Vector sizeInPixels = FontMetrics.getSize(this.content, this.font);
        return sizeInPixels.getX() * this.height / sizeInPixels.getY();
    }

    @API
    public Text setWidth(double width) {
        Vector sizeInPixels = FontMetrics.getSize(this.content, this.font);
        this.setHeight(width / sizeInPixels.getX() * sizeInPixels.getY());
        return this;
    }

    @Internal
    private void update() {
        Vector size = FontMetrics.getSize(this.content, this.font);
        this.cachedScaleFactor = this.height / size.getY();
        this.cachedDescent = FontMetrics.getDescent(this.font);
        this.setFixture(() -> Text.createShape(this.content, this.height, this.font));
    }

    @Override
    @Internal
    public void render(Graphics2D g, double pixelPerMeter) {
        AffineTransform pre = g.getTransform();
        Font preFont = g.getFont();
        g.setColor(this.getColor());
        g.scale(this.cachedScaleFactor * pixelPerMeter, this.cachedScaleFactor * pixelPerMeter);
        g.setFont(this.font);
        g.drawString(this.content, 0, -this.cachedDescent);
        g.setFont(preFont);
        g.setTransform(pre);
    }

    public String toString() {
        ToStringFormatter formatter = new ToStringFormatter("Text");
        formatter.add("content", this.content);
        return formatter.format();
    }
}

