/*
 * Decompiled with CFR 0.152.
 */
package de.pirckheimer_gymnasium.engine_pi.debug;

import de.pirckheimer_gymnasium.engine_pi.annotations.API;
import de.pirckheimer_gymnasium.engine_pi.debug.MainAnimation;
import de.pirckheimer_gymnasium.engine_pi.resources.ResourceLoader;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

public final class Version {
    private static final Properties PROJECT_PROPERTIES = Version.getProjectProperties();
    private static final Properties GIT_PROPERTIES = Version.getGitProperties();

    @API
    public static boolean isJar() {
        String className = MainAnimation.class.getName().replace('.', '/');
        String classJar = MainAnimation.class.getResource("/" + className + ".class").toString();
        return classJar.startsWith("jar:");
    }

    @API
    public static String getJarName() {
        String className = MainAnimation.class.getName().replace('.', '/');
        String classJar = MainAnimation.class.getResource("/" + className + ".class").toString();
        if (classJar.startsWith("jar:")) {
            String[] values;
            for (String value : values = classJar.split("/")) {
                if (!value.contains("!")) continue;
                try {
                    return URLDecoder.decode(value.substring(0, value.length() - 1), StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }

    @API
    public static long getBuildTime() {
        try {
            String uri = MainAnimation.class.getName().replace('.', '/') + ".class";
            JarURLConnection j = (JarURLConnection)ClassLoader.getSystemResource(uri).openConnection();
            long time = j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime();
            return time > 0L ? time : System.currentTimeMillis();
        }
        catch (Exception e) {
            return System.currentTimeMillis();
        }
    }

    private static Properties getProjectProperties() {
        Properties properties = new Properties();
        try {
            properties.load(ResourceLoader.loadAsStream("project.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String getVersion() {
        return PROJECT_PROPERTIES.getProperty("version");
    }

    private static Properties getGitProperties() {
        Properties properties = new Properties();
        try {
            properties.load(ResourceLoader.loadAsStream("git.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String getGitCommitIdAbbrev() {
        return GIT_PROPERTIES.getProperty("git.commit.id.abbrev");
    }
}

