/*
 *    Copyright (C) 2015 QAware GmbH
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package de.qaware.seu.as.code.plugins.credentials.impl;

/**
 * Encrypts and decrypts data.
 *
 * @author phxql
 */
public interface Encryptor {
    /**
     * Encrypts the given plaintext.
     *
     * @param plaintext Plaintext.
     * @return Ciphertext.
     */
    byte[] encrypt(byte[] plaintext);

    /**
     * Decrypts the given ciphertext.
     *
     * @param ciphertext Ciphertext.
     * @return Plaintext.
     */
    byte[] decrypt(byte[] ciphertext);
}
