/*
 * Decompiled with CFR 0.152.
 */
package de.qaware.seu.as.code.plugins.credentials;

import de.qaware.seu.as.code.plugins.credentials.SetCredentialsTask;
import de.qaware.seu.as.code.plugins.credentials.impl.DPAPIEncryptor;
import de.qaware.seu.as.code.plugins.credentials.impl.PropertyCredentials;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class SeuacCredentialsPlugin
implements Plugin<Project> {
    private static final String PROPERTIES_FILE = "secure-credentials.properties";
    private static final String CREDENTIALS_PROPERTY = "credentials";

    public void apply(Project project) {
        PropertyCredentials credentials;
        try {
            credentials = new PropertyCredentials(new File(project.getGradle().getGradleUserHomeDir(), PROPERTIES_FILE), new DPAPIEncryptor());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        project.getExtensions().getExtraProperties().set(CREDENTIALS_PROPERTY, (Object)credentials);
        SetCredentialsTask setCredentialsTask = (SetCredentialsTask)project.getTasks().create("setCredentials", SetCredentialsTask.class);
        setCredentialsTask.setCredentials(credentials);
    }
}

