/*
 * Decompiled with CFR 0.152.
 */
package de.qaware.seu.as.code.plugins.credentials.impl;

import de.qaware.seu.as.code.plugins.credentials.Credentials;
import de.qaware.seu.as.code.plugins.credentials.impl.Encryptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;

public class PropertyCredentials
implements Credentials {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Properties properties;
    private final File credentialsFile;
    private final Encryptor encryptor;

    public PropertyCredentials(File credentialsFile, Encryptor encryptor) throws IOException {
        this.credentialsFile = credentialsFile;
        this.encryptor = encryptor;
        this.properties = new Properties();
        if (credentialsFile.exists()) {
            this.loadProperties(credentialsFile);
        }
    }

    private void loadProperties(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.properties.load(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
    }

    @Override
    public String get(String key) {
        String encodedValue = this.properties.getProperty(key);
        if (encodedValue == null) {
            return null;
        }
        byte[] encryptedValue = Base64.decodeBase64((String)encodedValue);
        byte[] decryptedValue = this.encryptor.decrypt(encryptedValue);
        return new String(decryptedValue, UTF_8);
    }

    @Override
    public void set(String key, String value) {
        byte[] encryptedValue = this.encryptor.encrypt(value.getBytes(UTF_8));
        String encodedValue = Base64.encodeBase64String((byte[])encryptedValue);
        this.properties.setProperty(key, encodedValue);
    }

    @Override
    public void save() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.credentialsFile);
        try {
            this.properties.store(fileOutputStream, "");
        }
        finally {
            fileOutputStream.close();
        }
    }
}

