/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.HttpMaidBuilder;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.FinalConsumer;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.closing.ClosingActions;
import de.quantummaid.httpmaid.util.Validators;
import java.io.IOException;
import java.util.Optional;

public final class HttpMaid
implements AutoCloseable {
    private final ChainRegistry chainRegistry;

    public static HttpMaid httpMaid(ChainRegistry chainRegistry) {
        Validators.validateNotNull(chainRegistry, "chainRegistry");
        return new HttpMaid(chainRegistry);
    }

    public void handle(ChainName chainName, MetaData metaData) {
        this.chainRegistry.putIntoChain(chainName, metaData, metaData1 -> {});
    }

    public void handleRequest(MetaData metaData, FinalConsumer responseHandler) {
        this.chainRegistry.putIntoChain(HttpMaidChains.INIT, metaData, finalMetaData -> {
            try {
                responseHandler.consume(metaData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public <T> T getMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getMetaDatum(key);
    }

    public <T> Optional<T> getOptionalMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getOptionalMetaDatum(key);
    }

    public String dumpChains() {
        return this.chainRegistry.dump();
    }

    public static HttpMaidBuilder anHttpMaid() {
        return HttpMaidBuilder.httpMaidBuilder();
    }

    @Override
    public void close() {
        ClosingActions closingActions = this.chainRegistry.getMetaDatum(ClosingActions.CLOSING_ACTIONS);
        closingActions.closeAll();
    }

    private HttpMaid(ChainRegistry chainRegistry) {
        this.chainRegistry = chainRegistry;
    }
}

