/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public interface Configurator {
    public static Configurator toUseModules(final ChainModule ... modules) {
        Validators.validateNotNull(modules, "modules");
        return new Configurator(){

            @Override
            public List<ChainModule> supplyModulesIfNotAlreadyPreset() {
                return Arrays.asList(modules);
            }

            @Override
            public void configure(DependencyRegistry dependencyRegistry) {
            }
        };
    }

    public static <T extends ChainModule> Configurator configuratorForType(Class<T> type, Consumer<T> configurator) {
        Validators.validateNotNull(type, "type");
        Validators.validateNotNull(configurator, "configurator");
        return dependencyRegistry -> {
            Object module = dependencyRegistry.getDependency(type);
            configurator.accept(module);
        };
    }

    public static Configurator allOf(final Configurator ... configurators) {
        return new Configurator(){

            @Override
            public List<ChainModule> supplyModulesIfNotAlreadyPreset() {
                return Arrays.stream(configurators).map(Configurator::supplyModulesIfNotAlreadyPreset).flatMap(Collection::stream).collect(Collectors.toList());
            }

            @Override
            public void init(MetaData configurationMetaData) {
                Arrays.stream(configurators).forEach(configurator -> configurator.init(configurationMetaData));
            }

            @Override
            public void configure(DependencyRegistry dependencyRegistry) {
                Arrays.stream(configurators).forEach(configurator -> configurator.configure(dependencyRegistry));
            }
        };
    }

    default public List<ChainModule> supplyModulesIfNotAlreadyPreset() {
        return Collections.emptyList();
    }

    default public void init(MetaData configurationMetaData) {
    }

    public void configure(DependencyRegistry var1);
}

