/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http.headers.accept;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.http.headers.accept.MimeType;
import de.quantummaid.httpmaid.http.headers.accept.MimeTypeMatcher;

public final class Accept {
    private final MimeTypeMatcher mimeTypeMatcher;

    public static Accept fromMetaData(MetaData metaData) {
        return metaData.getOptional(HttpMaidChainKeys.REQUEST_HEADERS).map(headers -> {
            String header = headers.getOptionalHeader("Accept").orElse("*/*");
            MimeTypeMatcher mimeTypeMatcher = MimeTypeMatcher.parseMimeTypeMatcher(header);
            return new Accept(mimeTypeMatcher);
        }).orElseGet(() -> new Accept(MimeTypeMatcher.parseMimeTypeMatcher("*/*")));
    }

    public boolean contentTypeIsAccepted(ContentType contentType) {
        MimeType mimeType = MimeType.parseMimeType(contentType.internalValueForMapping());
        return this.mimeTypeMatcher.matches(mimeType);
    }

    public String toString() {
        return "Accept(mimeTypeMatcher=" + this.mimeTypeMatcher + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Accept)) {
            return false;
        }
        Accept other = (Accept)o;
        MimeTypeMatcher this$mimeTypeMatcher = this.mimeTypeMatcher;
        MimeTypeMatcher other$mimeTypeMatcher = other.mimeTypeMatcher;
        return !(this$mimeTypeMatcher == null ? other$mimeTypeMatcher != null : !((Object)this$mimeTypeMatcher).equals(other$mimeTypeMatcher));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MimeTypeMatcher $mimeTypeMatcher = this.mimeTypeMatcher;
        result = result * 59 + ($mimeTypeMatcher == null ? 43 : ((Object)$mimeTypeMatcher).hashCode());
        return result;
    }

    private Accept(MimeTypeMatcher mimeTypeMatcher) {
        this.mimeTypeMatcher = mimeTypeMatcher;
    }
}

